/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import rdj.FCPath;
import rdj.FCPathList;
import rdj.FinalCrypt;
import rdj.GPT;
import rdj.Stat;
import rdj.Stats;
import rdj.UI;

public class DeviceController {
    int bufferSize = 0x100000;
    static long deviceSize = 0L;
    long keySize = 0L;
    static long bytesPerSector = 512L;
    static UI ui;
    private static boolean pausing;
    private static boolean stopPending;
    private TimerTask updateProgressTask;
    private Timer updateProgressTaskTimer;
    private static long lastpos;
    private static long currpos;
    private static long step;
    private static long above;
    private static long below;
    private static long cycles;
    private static boolean finished;
    private Calendar startCalendar;
    private long filesBytesTotal;
    private long filesBytesProcessed;
    private static double bytesPerMilliSecond;
    private Calendar processProgressCalendar;
    private long throughputClock;
    private long lastThroughputClock;
    private double realtimeBytesProcessed;
    private double realtimeMiBPS;

    public DeviceController(UI ui) {
        DeviceController.ui = ui;
    }

    public static synchronized byte[] readLBA(FCPath fcPath, long lba, long length) {
        long readInputDeviceChannelTransfered = 0L;
        ByteBuffer inputDeviceBuffer = ByteBuffer.allocate((int)length);
        inputDeviceBuffer.clear();
        try (SeekableByteChannel readInputDeviceChannel = Files.newByteChannel(fcPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);){
            readInputDeviceChannel.position(DeviceController.getLBAOffSet(bytesPerSector, fcPath.size, lba));
            readInputDeviceChannelTransfered = readInputDeviceChannel.read(inputDeviceBuffer);
            inputDeviceBuffer.flip();
            readInputDeviceChannel.close();
        }
        catch (IOException ex) {
            ui.log("Device().read(..) " + ex.getMessage(), true, true, true, true, false);
        }
        return inputDeviceBuffer.array();
    }

    public static synchronized byte[] readPos(FCPath fcPath, long pos, long length) {
        long readInputDeviceChannelTransfered = 0L;
        ByteBuffer inputDeviceBuffer = ByteBuffer.allocate((int)length);
        inputDeviceBuffer.clear();
        try (SeekableByteChannel readInputDeviceChannel = Files.newByteChannel(fcPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);){
            readInputDeviceChannel.position(pos);
            readInputDeviceChannelTransfered = readInputDeviceChannel.read(inputDeviceBuffer);
            inputDeviceBuffer.flip();
            readInputDeviceChannel.close();
        }
        catch (IOException ex) {
            ui.log("Device().read(..) " + ex.getMessage(), true, true, true, true, false);
        }
        return inputDeviceBuffer.array();
    }

    public static synchronized void writeLBA(String desc, byte[] bytes, FCPath fcPath, long lba) {
        long writeOutputDeviceChannelTransfered = 0L;
        ByteBuffer outputDeviceBuffer = null;
        ui.log("Write " + desc + " Pos (" + DeviceController.getLBAOffSet(bytesPerSector, fcPath.size, lba) + ") ", true, true, true, false, false);
        try (SeekableByteChannel writeOutputDeviceChannel = Files.newByteChannel(fcPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.WRITE)), new FileAttribute[0]);){
            outputDeviceBuffer = ByteBuffer.allocate(bytes.length);
            outputDeviceBuffer.put(bytes);
            outputDeviceBuffer.flip();
            writeOutputDeviceChannel.position(DeviceController.getLBAOffSet(bytesPerSector, fcPath.size, lba));
            writeOutputDeviceChannelTransfered = writeOutputDeviceChannel.write(outputDeviceBuffer);
            ui.log("Transfered: " + writeOutputDeviceChannelTransfered + "\r\n", true, true, true, false, false);
            writeOutputDeviceChannel.close();
        }
        catch (IOException ex) {
            ui.log("Error: Device.writeLBA(..): " + ex.getMessage() + "", true, true, true, true, false);
        }
    }

    public static synchronized void writePos(String desc, byte[] bytes, FCPath device, long pos) {
        long writeOutputDeviceChannelTransfered = 0L;
        ByteBuffer outputDeviceBuffer = null;
        ui.log("Wrote " + desc + " Pos(" + pos + ") ", true, true, true, false, false);
        try (SeekableByteChannel writeOutputDeviceChannel = Files.newByteChannel(device.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.WRITE)), new FileAttribute[0]);){
            outputDeviceBuffer = ByteBuffer.allocate(bytes.length);
            outputDeviceBuffer.put(bytes);
            outputDeviceBuffer.flip();
            writeOutputDeviceChannel.position(pos);
            writeOutputDeviceChannelTransfered = writeOutputDeviceChannel.write(outputDeviceBuffer);
            ui.log("Transfered: " + writeOutputDeviceChannelTransfered + "", true, true, true, false, false);
            writeOutputDeviceChannel.close();
        }
        catch (IOException ex) {
            ui.log("Error: Device.writePos(..): " + ex.getMessage() + "\r\n", true, true, true, true, false);
        }
    }

    public synchronized void createManualKeyPartition(FCPath keyFCPath, FCPath targetFCPath, long firstLBA, long lastLBA) {
        FinalCrypt.io_Throughput_Ceiling = 10.0;
        this.startCalendar = Calendar.getInstance(Locale.ROOT);
        boolean encryptkey = true;
        if (keyFCPath.size < (long)this.bufferSize) {
            this.bufferSize = (int)keyFCPath.size;
            if (FinalCrypt.verbose) {
                ui.log("BufferSize is limited to keyfile size: " + GPT.getHumanSize(this.bufferSize, 1, "Bytes") + " \r\n", true, true, true, false, false);
            }
        }
        final Stats allDataStats = new Stats();
        allDataStats.reset();
        final Stat readKeyFileStat1 = new Stat();
        readKeyFileStat1.reset();
        final Stat readKeyFileStat2 = new Stat();
        readKeyFileStat2.reset();
        final Stat writeKeyFileStat1 = new Stat();
        writeKeyFileStat1.reset();
        final Stat writeKeyFileStat2 = new Stat();
        writeKeyFileStat2.reset();
        allDataStats.setFilesTotal(1L);
        allDataStats.setFileBytesTotal(keyFCPath.size * 2L);
        allDataStats.setAllDataBytesTotal(keyFCPath.size * 2L);
        ui.log(allDataStats.getStartSummary("Creating Key Device"), true, true, false, false, false);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean inputEnded = false;
        long readKeyFileChannelPosition = 0L;
        long readKeyFileChannelTransfered = 0L;
        long writeOutputDeviceChannelPosition = 0L;
        long writeOutputDeviceChannelTransfered = 0L;
        ByteBuffer keyFileBuffer = ByteBuffer.allocate(this.bufferSize);
        keyFileBuffer.clear();
        byte[] randomizedBytes = new byte[this.bufferSize];
        ByteBuffer randomizedBuffer = ByteBuffer.allocate(this.bufferSize);
        keyFileBuffer.clear();
        ByteBuffer outputDeviceBuffer = ByteBuffer.allocate(this.bufferSize);
        outputDeviceBuffer.clear();
        this.throughputClock = 0L;
        this.lastThroughputClock = 0L;
        this.updateProgressTask = new TimerTask(){

            @Override
            public void run() {
                DeviceController.this.processProgressCalendar = Calendar.getInstance(Locale.ROOT);
                DeviceController.this.filesBytesTotal = allDataStats.getFilesBytesTotal();
                DeviceController.this.filesBytesProcessed = allDataStats.getFilesBytesProcessed();
                bytesPerMilliSecond = DeviceController.this.filesBytesProcessed / (DeviceController.this.processProgressCalendar.getTimeInMillis() - DeviceController.this.startCalendar.getTimeInMillis());
                DeviceController.this.throughputClock = System.nanoTime();
                DeviceController.this.realtimeMiBPS = DeviceController.this.realtimeBytesProcessed * (1.0E9 / (double)(DeviceController.this.throughputClock - DeviceController.this.lastThroughputClock)) / 1048576.0;
                if (DeviceController.this.realtimeMiBPS > FinalCrypt.io_Throughput_Ceiling) {
                    FinalCrypt.io_Throughput_Ceiling = DeviceController.this.realtimeMiBPS;
                }
                DeviceController.this.lastThroughputClock = DeviceController.this.throughputClock;
                DeviceController.this.realtimeBytesProcessed = 0.0;
                ui.processProgress((int)((double)((readKeyFileStat1.getFileBytesProcessed() + writeKeyFileStat1.getFileBytesProcessed() + readKeyFileStat2.getFileBytesProcessed() + writeKeyFileStat2.getFileBytesProcessed()) * 2L) / ((double)(allDataStats.getFileBytesTotal() * 3L) / 100.0)), (int)((double)(allDataStats.getFilesBytesProcessed() * 2L) / ((double)(allDataStats.getFilesBytesTotal() * 3L) / 100.0)), DeviceController.this.filesBytesTotal, DeviceController.this.filesBytesProcessed, DeviceController.this.realtimeMiBPS);
            }
        };
        this.updateProgressTaskTimer = new Timer();
        this.updateProgressTaskTimer.schedule(this.updateProgressTask, 0L, 200L);
        allDataStats.setAllDataStartNanoTime();
        ui.log("Writing " + keyFCPath.path.toAbsolutePath() + " to partition 1 (LBA:" + firstLBA + ":" + (DeviceController.getLBAOffSet(bytesPerSector, targetFCPath.size, firstLBA) + writeOutputDeviceChannelPosition) + ")", true, true, true, false, false);
        readKeyFileStat1.reset();
        writeKeyFileStat1.reset();
        this.filesBytesProcessed = 0L;
        while (!inputEnded) {
            while (pausing) {
                bytesPerMilliSecond = 0.0;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (stopPending) {
                inputEnded = true;
                break;
            }
            readKeyFileStat1.setFileStartEpoch();
            try (SeekableByteChannel readKeyFileChannel = Files.newByteChannel(keyFCPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);){
                readKeyFileChannel.position(readKeyFileChannelPosition);
                readKeyFileChannelTransfered = readKeyFileChannel.read(keyFileBuffer);
                readKeyFileChannelPosition += readKeyFileChannelTransfered;
                if (readKeyFileChannelTransfered < 1L || keyFileBuffer.limit() < this.bufferSize) {
                    inputEnded = true;
                }
                keyFileBuffer.flip();
                readKeyFileChannel.close();
                readKeyFileStat1.setFileEndEpoch();
                readKeyFileStat1.clock();
                readKeyFileStat1.addFileBytesProcessed(readKeyFileChannelTransfered);
                allDataStats.addAllDataBytesProcessed("", readKeyFileChannelTransfered);
            }
            catch (IOException ex) {
                ui.log("Files.newByteChannel(keyFilePath, FinalCrypt.getEnumSet()EnumSet.of(StandardOpenOption.READ)) " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
            SecureRandom random = new SecureRandom();
            if (encryptkey) {
                random.nextBytes(randomizedBytes);
                randomizedBuffer.put(randomizedBytes);
                randomizedBuffer.flip();
                outputDeviceBuffer = FinalCrypt.encryptBuffer(keyFileBuffer, randomizedBuffer, 0, false);
            } else {
                outputDeviceBuffer.put(keyFileBuffer);
                outputDeviceBuffer.flip();
            }
            writeKeyFileStat1.setFileStartEpoch();
            try (SeekableByteChannel writeOutputDeviceChannel = Files.newByteChannel(targetFCPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.WRITE)), new FileAttribute[0]);){
                writeOutputDeviceChannel.position(DeviceController.getLBAOffSet(bytesPerSector, targetFCPath.size, firstLBA) + writeOutputDeviceChannelPosition);
                writeOutputDeviceChannelTransfered = writeOutputDeviceChannel.write(outputDeviceBuffer);
                outputDeviceBuffer.rewind();
                this.realtimeBytesProcessed += (double)writeOutputDeviceChannelTransfered;
                this.filesBytesProcessed += writeOutputDeviceChannelTransfered;
                writeKeyFileStat1.addFileBytesProcessed(writeOutputDeviceChannelTransfered);
                allDataStats.addAllDataBytesProcessed("", readKeyFileChannelTransfered);
                writeOutputDeviceChannel.position(DeviceController.getLBAOffSet(bytesPerSector, targetFCPath.size, lastLBA + 1L) + writeOutputDeviceChannelPosition);
                writeOutputDeviceChannelTransfered = writeOutputDeviceChannel.write(outputDeviceBuffer);
                outputDeviceBuffer.rewind();
                this.realtimeBytesProcessed += (double)writeOutputDeviceChannelTransfered;
                this.filesBytesProcessed += writeOutputDeviceChannelTransfered;
                writeKeyFileStat1.addFileBytesProcessed(writeOutputDeviceChannelTransfered);
                allDataStats.addAllDataBytesProcessed("", readKeyFileChannelTransfered);
                writeOutputDeviceChannelPosition += writeOutputDeviceChannelTransfered;
                if (inputEnded) {
                    long partLength = (lastLBA - firstLBA + 1L) * bytesPerSector;
                    long gap = partLength - keyFCPath.size;
                    outputDeviceBuffer = ByteBuffer.allocate((int)gap);
                    outputDeviceBuffer.clear();
                    if (encryptkey) {
                        randomizedBytes = new byte[(int)gap];
                        random.nextBytes(randomizedBytes);
                        outputDeviceBuffer.put(randomizedBytes);
                        outputDeviceBuffer.flip();
                    } else {
                        outputDeviceBuffer.put(GPT.getZeroBytes((int)gap));
                        outputDeviceBuffer.flip();
                    }
                    writeOutputDeviceChannel.position(DeviceController.getLBAOffSet(bytesPerSector, targetFCPath.size, firstLBA) + writeOutputDeviceChannelPosition);
                    writeOutputDeviceChannelTransfered = writeOutputDeviceChannel.write(outputDeviceBuffer);
                    outputDeviceBuffer.rewind();
                    writeKeyFileStat1.addFileBytesProcessed(writeOutputDeviceChannelTransfered);
                    allDataStats.addAllDataBytesProcessed("", readKeyFileChannelTransfered);
                    writeOutputDeviceChannel.position(DeviceController.getLBAOffSet(bytesPerSector, targetFCPath.size, lastLBA + 1L) + writeOutputDeviceChannelPosition);
                    writeOutputDeviceChannelTransfered = writeOutputDeviceChannel.write(outputDeviceBuffer);
                    outputDeviceBuffer.rewind();
                    writeKeyFileStat1.addFileBytesProcessed(writeOutputDeviceChannelTransfered);
                    allDataStats.addAllDataBytesProcessed("", readKeyFileChannelTransfered);
                }
                writeOutputDeviceChannel.close();
                writeKeyFileStat1.setFileEndEpoch();
                writeKeyFileStat1.clock();
            }
            catch (IOException ex) {
                ui.log(Arrays.toString(ex.getStackTrace()), true, true, false, false, false);
            }
            keyFileBuffer.clear();
            randomizedBuffer.clear();
            outputDeviceBuffer.clear();
        }
        readKeyFileChannelPosition = 0L;
        readKeyFileChannelTransfered = 0L;
        writeOutputDeviceChannelPosition = 0L;
        writeOutputDeviceChannelTransfered = 0L;
        inputEnded = false;
        ui.log(" - Write: rd(" + readKeyFileStat1.getFileBytesThroughPut() + ") -> ", true, true, true, false, false);
        ui.log("wr(" + writeKeyFileStat1.getFileBytesThroughPut() + ") ", true, true, true, false, false);
        ui.log(" - Write: rd(" + readKeyFileStat2.getFileBytesThroughPut() + ") -> ", true, true, true, false, false);
        ui.log("wr(" + writeKeyFileStat2.getFileBytesThroughPut() + ") ", true, true, true, false, false);
        ui.log(allDataStats.getAllDataBytesProgressPercentage() + "\r\n", true, true, true, false, false);
        allDataStats.addFilesProcessed(1L);
        allDataStats.setAllDataEndNanoTime();
        allDataStats.clock();
        ui.log(allDataStats.getEndSummary("creating key device"), true, true, false, false, false);
        this.updateProgressTaskTimer.cancel();
        this.updateProgressTaskTimer.purge();
        ui.processFinished(new FCPathList<FCPath>(), false);
    }

    public synchronized void cloneKeyPartition(FCPath keyFCPath, FCPath targetFCPath, long firstLBA, long lastLBA) {
        FinalCrypt.io_Throughput_Ceiling = 10.0;
        this.startCalendar = Calendar.getInstance(Locale.ROOT);
        if (DeviceController.isValidFile(ui, keyFCPath.path, false, keyFCPath.isKey, false, true) && DeviceController.isValidFile(ui, targetFCPath.path, targetFCPath.isKey, false, false, true)) {
            long targetDeviceSize2 = targetFCPath.size;
            long keyPartitionSize = DeviceController.getKeyPartitionSize(ui, keyFCPath);
            if (keyPartitionSize < (long)this.bufferSize) {
                this.bufferSize = (int)keyPartitionSize;
                if (FinalCrypt.verbose) {
                    ui.log("BufferSize is limited to keyfile size: " + GPT.getHumanSize(this.bufferSize, 1, "Bytes") + " \r\n", true, true, true, false, false);
                }
            }
            if (keyPartitionSize < (long)this.bufferSize) {
                this.bufferSize = (int)keyPartitionSize;
                if (FinalCrypt.verbose) {
                    ui.log("BufferSize is limited to keyfile size: " + GPT.getHumanSize(this.bufferSize, 1, "Bytes") + " \r\n", true, true, true, false, false);
                }
            }
            final Stats allDataStats = new Stats();
            allDataStats.reset();
            final Stat readKeyFileStat1 = new Stat();
            readKeyFileStat1.reset();
            final Stat readKeyFileStat2 = new Stat();
            readKeyFileStat2.reset();
            final Stat writeKeyFileStat1 = new Stat();
            writeKeyFileStat1.reset();
            final Stat writeKeyFileStat2 = new Stat();
            writeKeyFileStat2.reset();
            allDataStats.setFilesTotal(1L);
            allDataStats.setFileBytesTotal(keyPartitionSize * 2L);
            allDataStats.setAllDataBytesTotal(keyPartitionSize * 2L);
            ui.log(allDataStats.getStartSummary("Cloning Key Device"), true, true, false, false, false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean inputEnded = false;
            long readKeyDeviceFileChannelPosition = 0L;
            long readKeyDeviceFileChannelTransfered = 0L;
            long readKeyDeviceFileChannelTransferedTotal = 0L;
            long writeOutputDeviceChannelPosition = 0L;
            long writeOutputDeviceChannelTransfered = 0L;
            ByteBuffer keyDeviceBuffer = ByteBuffer.allocate(this.bufferSize);
            keyDeviceBuffer.clear();
            byte[] randomizedBytes = new byte[this.bufferSize];
            ByteBuffer outputDeviceBuffer = ByteBuffer.allocate(this.bufferSize);
            outputDeviceBuffer.clear();
            this.processProgressCalendar = Calendar.getInstance(Locale.ROOT);
            this.filesBytesTotal = allDataStats.getFilesBytesTotal();
            this.filesBytesProcessed = allDataStats.getFilesBytesProcessed();
            bytesPerMilliSecond = this.filesBytesProcessed / (this.processProgressCalendar.getTimeInMillis() - this.startCalendar.getTimeInMillis());
            this.throughputClock = System.nanoTime();
            this.realtimeMiBPS = this.realtimeBytesProcessed * (1.0E9 / (double)(this.throughputClock - this.lastThroughputClock)) / 1048576.0;
            if (this.realtimeMiBPS > FinalCrypt.io_Throughput_Ceiling) {
                FinalCrypt.io_Throughput_Ceiling = this.realtimeMiBPS;
            }
            this.lastThroughputClock = this.throughputClock;
            this.realtimeBytesProcessed = 0.0;
            this.updateProgressTask = new TimerTask(){

                @Override
                public void run() {
                    DeviceController.this.processProgressCalendar = Calendar.getInstance(Locale.ROOT);
                    DeviceController.this.filesBytesTotal = allDataStats.getFilesBytesTotal();
                    DeviceController.this.filesBytesProcessed = allDataStats.getFilesBytesProcessed();
                    bytesPerMilliSecond = DeviceController.this.filesBytesProcessed / (DeviceController.this.processProgressCalendar.getTimeInMillis() - DeviceController.this.startCalendar.getTimeInMillis());
                    DeviceController.this.throughputClock = System.nanoTime();
                    DeviceController.this.realtimeMiBPS = DeviceController.this.realtimeBytesProcessed * (1.0E9 / (double)(DeviceController.this.throughputClock - DeviceController.this.lastThroughputClock)) / 1048576.0;
                    if (DeviceController.this.realtimeMiBPS > FinalCrypt.io_Throughput_Ceiling) {
                        FinalCrypt.io_Throughput_Ceiling = DeviceController.this.realtimeMiBPS;
                    }
                    DeviceController.this.lastThroughputClock = DeviceController.this.throughputClock;
                    DeviceController.this.realtimeBytesProcessed = 0.0;
                    ui.processProgress((int)((double)(readKeyFileStat1.getFileBytesProcessed() + writeKeyFileStat1.getFileBytesProcessed() + readKeyFileStat2.getFileBytesProcessed() + writeKeyFileStat2.getFileBytesProcessed()) / ((double)(allDataStats.getFileBytesTotal() * 1L) / 100.0)), (int)((double)(allDataStats.getFilesBytesProcessed() * 1L) / ((double)(allDataStats.getFilesBytesTotal() * 1L) / 100.0)), DeviceController.this.filesBytesTotal, DeviceController.this.filesBytesProcessed, DeviceController.this.realtimeMiBPS);
                }
            };
            this.updateProgressTaskTimer = new Timer();
            this.updateProgressTaskTimer.schedule(this.updateProgressTask, 0L, 200L);
            allDataStats.setAllDataStartNanoTime();
            ui.log("Cloning " + keyFCPath.path.toAbsolutePath() + " to " + targetFCPath.path.toAbsolutePath() + " partitions (LBA:" + firstLBA + ":" + (DeviceController.getLBAOffSet(bytesPerSector, targetFCPath.size, firstLBA) + writeOutputDeviceChannelPosition) + ")", true, true, true, false, false);
            readKeyDeviceFileChannelPosition = DeviceController.getLBAOffSet(bytesPerSector, targetFCPath.size, firstLBA) + readKeyDeviceFileChannelPosition;
            readKeyFileStat1.reset();
            writeKeyFileStat1.reset();
            this.filesBytesProcessed = 0L;
            while (!inputEnded) {
                Throwable throwable;
                while (pausing) {
                    bytesPerMilliSecond = 0.0;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (stopPending) {
                    inputEnded = true;
                    bytesPerMilliSecond = 0.0;
                    break;
                }
                readKeyFileStat1.setFileStartEpoch();
                try {
                    throwable = null;
                    try (SeekableByteChannel readKeyDeviceFileChannel = Files.newByteChannel(keyFCPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);){
                        readKeyDeviceFileChannel.position(readKeyDeviceFileChannelPosition);
                        readKeyDeviceFileChannelTransfered = readKeyDeviceFileChannel.read(keyDeviceBuffer);
                        keyDeviceBuffer.flip();
                        readKeyDeviceFileChannelPosition += readKeyDeviceFileChannelTransfered;
                        if ((readKeyDeviceFileChannelTransferedTotal += readKeyDeviceFileChannelTransfered) >= keyPartitionSize) {
                            inputEnded = true;
                            keyDeviceBuffer.limit((int)readKeyDeviceFileChannelTransferedTotal - (int)keyPartitionSize);
                        }
                        readKeyDeviceFileChannel.close();
                        readKeyFileStat1.setFileEndEpoch();
                        readKeyFileStat1.clock();
                        readKeyFileStat1.addFileBytesProcessed(readKeyDeviceFileChannelTransfered);
                        allDataStats.addAllDataBytesProcessed("", readKeyDeviceFileChannelTransfered);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (IOException ex) {
                    ui.log("Error: Files.newByteChannel(keyFilePath, FinalCrypt.getEnumSet()EnumSet.of(StandardOpenOption.READ)) " + ex.getMessage() + "\r\n", true, true, true, true, false);
                }
                outputDeviceBuffer.put(keyDeviceBuffer.array());
                outputDeviceBuffer.flip();
                writeKeyFileStat1.setFileStartEpoch();
                try {
                    throwable = null;
                    try (SeekableByteChannel writeOutputDeviceChannel = Files.newByteChannel(targetFCPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.WRITE)), new FileAttribute[0]);){
                        writeOutputDeviceChannel.position(DeviceController.getLBAOffSet(bytesPerSector, targetFCPath.size, firstLBA) + writeOutputDeviceChannelPosition);
                        writeOutputDeviceChannelTransfered = writeOutputDeviceChannel.write(outputDeviceBuffer);
                        outputDeviceBuffer.rewind();
                        this.realtimeBytesProcessed += (double)writeOutputDeviceChannelTransfered;
                        this.filesBytesProcessed += writeOutputDeviceChannelTransfered;
                        writeKeyFileStat1.addFileBytesProcessed(writeOutputDeviceChannelTransfered);
                        allDataStats.addAllDataBytesProcessed("", readKeyDeviceFileChannelTransfered);
                        writeOutputDeviceChannelPosition += writeOutputDeviceChannelTransfered;
                        writeOutputDeviceChannel.close();
                        writeKeyFileStat1.setFileEndEpoch();
                        writeKeyFileStat1.clock();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException ex) {
                    ui.log("Error: Files.newByteChannel(targetFCPath.path, FinalCrypt.getEnumSet()EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.SYNC))" + ex.getMessage() + "\r\n", true, true, true, true, false);
                }
                keyDeviceBuffer.clear();
            }
            readKeyDeviceFileChannelPosition = 0L;
            readKeyDeviceFileChannelTransfered = 0L;
            writeOutputDeviceChannelPosition = 0L;
            writeOutputDeviceChannelTransfered = 0L;
            inputEnded = false;
            ui.log(" - Write: rd(" + readKeyFileStat1.getFileBytesThroughPut() + ") -> ", true, true, true, false, false);
            ui.log("wr(" + writeKeyFileStat1.getFileBytesThroughPut() + ") ", true, true, true, false, false);
            ui.log(" - Write: rd(" + readKeyFileStat2.getFileBytesThroughPut() + ") -> ", true, true, true, false, false);
            ui.log("wr(" + writeKeyFileStat2.getFileBytesThroughPut() + ") ", true, true, true, false, false);
            ui.log(allDataStats.getAllDataBytesProgressPercentage(), true, true, true, false, false);
            allDataStats.addFilesProcessed(1L);
            allDataStats.setAllDataEndNanoTime();
            allDataStats.clock();
            ui.log(allDataStats.getEndSummary("cloning key device"), true, true, false, false, false);
            this.updateProgressTaskTimer.cancel();
            this.updateProgressTaskTimer.purge();
        } else {
            ui.log("Warning: Invalid key or target. Cloning aborted.\r\n", true, true, true, true, false);
        }
    }

    public static long getKeyPartitionSize(UI ui, FCPath keyFCPath) {
        GPT gpt = new GPT(ui);
        gpt.read(keyFCPath);
        long partitionSize = bytesPerSector + (gpt.gpt_Entries1.gpt_entry[0].endingLBA - gpt.gpt_Entries1.gpt_entry[0].startingLBA) * bytesPerSector;
        return partitionSize;
    }

    public static synchronized long getDeviceSize(UI ui, Path path, boolean isKey) {
        long size = DeviceController.getDeviceGuessedSize(ui, path, isKey, true);
        return size;
    }

    public static synchronized long getDeviceFileSize(UI ui, Path path, boolean isKey, boolean firstcall) {
        long deviceSize = 0L;
        try {
            deviceSize = Files.size(path);
        }
        catch (IOException ex) {
            ui.log("Error: IOException DevCTRL: getDeviceFileSize() Files.size(" + path.toAbsolutePath().toString() + ") " + ex.getMessage() + "\r\n", true, true, true, true, false);
        }
        return deviceSize;
    }

    public static synchronized long getDeviceChannelSize(UI ui, Path path, boolean isKey, boolean firstcall) {
        long deviceSize = 0L;
        try (SeekableByteChannel deviceChannel = Files.newByteChannel(path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);){
            deviceSize = deviceChannel.size();
            deviceChannel.close();
        }
        catch (IOException ex) {
            ui.log(ex.getMessage(), true, true, false, false, false);
        }
        return deviceSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long getDeviceGuessedSize(UI ui, Path path, boolean isKey, boolean firstcall) {
        boolean verbose = false;
        if (firstcall) {
            lastpos = 0L;
            currpos = 1L;
            step = 1L;
            above = 0L;
            below = 1024L;
            cycles = 0L;
            finished = false;
        }
        if (DeviceController.isValidFile(ui, path, false, isKey, false, true)) {
            while (!finished) {
                try {
                    deviceSize = DeviceController.guessDeviceSize(ui, path, verbose);
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    lastpos = Math.abs(lastpos);
                    currpos = Math.abs(currpos);
                    step = Math.abs(step);
                    below = currpos;
                    if (step < 0L) {
                        step = 1L;
                    }
                    currpos = above;
                    step = 1L;
                    lastpos = currpos;
                    DeviceController.getDeviceGuessedSize(ui, path, isKey, false);
                }
            }
        } else {
            return deviceSize;
        }
        return deviceSize;
    }

    private static synchronized long guessDeviceSize(UI ui, Path path, boolean verbose) throws IOException {
        if (verbose) {
            ui.log(String.format("%-20s %-20s %-20s %-20s %-20s %-20s \r\n", "LastPoss     ", "CurrPoss     ", "Step    ", "Above     ", "Below    ", "Cycles     "), true, true, true, false, false);
        }
        while (!finished) {
            if (verbose) {
                ui.log(String.format("%-20d %-20d %-20d %-20d %-20d %-20d \r\n", lastpos, currpos, step, above, below, cycles), true, true, true, false, false);
            }
            SeekableByteChannel deviceChannel = Files.newByteChannel(path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);
            deviceChannel.position(currpos);
            ByteBuffer bb = ByteBuffer.allocate(1);
            bb.clear();
            int transfered = 0;
            transfered = deviceChannel.read(bb);
            if (transfered < 1) {
                if (lastpos == below && currpos == below && above == below - 1L) {
                    finished = true;
                }
                below = currpos;
                currpos -= step / 2L;
                step = 1L;
            } else {
                above = currpos;
                currpos += step;
                step += step;
            }
            deviceChannel.close();
            lastpos = currpos;
            ++cycles;
        }
        return below;
    }

    private void halveTest(UI ui) {
        long deviceSize = 0L;
        long lastpos = 0L;
        long currpos = 1L;
        long step = 1L;
        long above = 0L;
        long below = 1024L;
        long target = 0x7FFFFFFFFFL;
        long cycles = 0L;
        boolean finished = false;
        boolean iofailed = false;
        iofailed = false;
        ui.log("Target: " + target + "\r\n", true, true, true, false, false);
        ui.log(String.format("%-20s %-20s %-20s %-20s %-20s %-20s \r\n", "LastPoss     ", "CurrPoss     ", "Step    ", "Above     ", "Below    ", "Cycles     "), true, true, true, false, false);
        while (!finished) {
            ui.log(String.format("%-20d %-20d %-20d %-20d %-20d %-20d \r\n", lastpos, currpos, step, above, below, cycles), true, true, true, false, false);
            if (currpos < target) {
                above = currpos;
                currpos += step;
                step += step;
            } else if (currpos > target) {
                below = currpos;
                currpos -= step / 2L;
                step = 1L;
            }
            if (currpos != 0L && currpos == lastpos) {
                finished = true;
            }
            lastpos = currpos;
            ++cycles;
        }
    }

    public static synchronized long getLBAOffSet(long bytesPerSector, long devSize, long lba) {
        if (lba >= 0L) {
            long returnValue = 0L;
            returnValue = Math.abs(lba * bytesPerSector);
            return returnValue;
        }
        long returnValue = 0L;
        returnValue = Math.abs(devSize - 0L + lba * bytesPerSector);
        return returnValue;
    }

    public static boolean isValidDir(UI ui, Path path, boolean symlink, boolean report) {
        boolean validdir = true;
        String conditions = "";
        String exist = "";
        String read = "";
        String write = "";
        String symbolic = "";
        if (!Files.exists(path, new LinkOption[0])) {
            validdir = false;
            exist = "[not found] ";
            conditions = conditions + exist;
        }
        if (!Files.isReadable(path)) {
            validdir = false;
            read = "[not readable] ";
            conditions = conditions + read;
        }
        if (!Files.isWritable(path)) {
            validdir = false;
            write = "[not writable] ";
            conditions = conditions + write;
        }
        if (!symlink && Files.isSymbolicLink(path)) {
            validdir = false;
            symbolic = "[symlink]";
            conditions = conditions + symbolic;
        }
        if (!validdir && report) {
            ui.log("Warning: Invalid Dir: " + path.toAbsolutePath().toString() + ": " + conditions + "\r\n", true, true, true, true, false);
        }
        return validdir;
    }

    public static boolean isValidFile(UI ui, Path path, boolean readSize, boolean isKey, boolean symlink, boolean report) {
        boolean validfile = true;
        String conditions = "";
        String size = "";
        String exist = "";
        String dir = "";
        String read = "";
        String write = "";
        String symbolic = "";
        long fileSize = 0L;
        if (readSize) {
            try {
                fileSize = Files.size(path);
            }
            catch (IOException ex) {
                ui.log("Error: IOException DevCTRL: isValidFile() Files.size(" + path.toAbsolutePath().toString() + ") " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
        }
        if (!Files.exists(path, new LinkOption[0])) {
            validfile = false;
            exist = "[not found] ";
            conditions = conditions + exist;
        } else {
            if (Files.isDirectory(path, new LinkOption[0])) {
                validfile = false;
                dir = "[is directory] ";
                conditions = conditions + dir;
            }
            if (readSize && fileSize == 0L) {
                validfile = false;
                size = "[empty] ";
                conditions = conditions + size;
            }
            if (!Files.isReadable(path)) {
                validfile = false;
                read = "[not readable] ";
                conditions = conditions + read;
            }
            if (!isKey && !Files.isWritable(path)) {
                validfile = false;
                write = "[not writable] ";
                conditions = conditions + write;
            }
            if (!symlink && Files.isSymbolicLink(path)) {
                validfile = false;
                symbolic = "[symlink]";
                conditions = conditions + symbolic;
            }
        }
        if (!validfile && report) {
            ui.log("Warning: DevCTRL: Invalid File: " + path.toAbsolutePath().toString() + ": " + conditions + "\r\n", true, true, true, true, false);
        }
        return validfile;
    }

    public static boolean getPausing() {
        return pausing;
    }

    public static boolean getStopPending() {
        return stopPending;
    }

    public static void setPausing(boolean val) {
        pausing = val;
        if (pausing) {
            bytesPerMilliSecond = 0.0;
        }
    }

    public static void setStopPending(boolean val) {
        stopPending = val;
    }

    static {
        lastpos = 0L;
        currpos = 1L;
        step = 1L;
        above = 0L;
        below = 1024L;
        cycles = 0L;
        finished = false;
    }
}

