/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ParameterAnnotations
extends Attribute {
    private ParameterAnnotationEntry[] parameter_annotation_table;

    ParameterAnnotations(byte parameter_annotation_type, int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(parameter_annotation_type, name_index, length, (ParameterAnnotationEntry[])null, constant_pool);
        int num_parameters = input.readUnsignedByte();
        this.parameter_annotation_table = new ParameterAnnotationEntry[num_parameters];
        for (int i = 0; i < num_parameters; ++i) {
            this.parameter_annotation_table[i] = new ParameterAnnotationEntry(input, constant_pool);
        }
    }

    public ParameterAnnotations(byte parameter_annotation_type, int name_index, int length, ParameterAnnotationEntry[] parameter_annotation_table, ConstantPool constant_pool) {
        super(parameter_annotation_type, name_index, length, constant_pool);
        this.parameter_annotation_table = parameter_annotation_table;
    }

    @Override
    public void accept(Visitor v) {
        v.visitParameterAnnotation(this);
    }

    public final void setParameterAnnotationTable(ParameterAnnotationEntry[] parameter_annotation_table) {
        this.parameter_annotation_table = parameter_annotation_table;
    }

    public final ParameterAnnotationEntry[] getParameterAnnotationTable() {
        return this.parameter_annotation_table;
    }

    public ParameterAnnotationEntry[] getParameterAnnotationEntries() {
        return this.parameter_annotation_table;
    }

    @Override
    public void dump(DataOutputStream dos) throws IOException {
        super.dump(dos);
        dos.writeByte(this.parameter_annotation_table.length);
        for (ParameterAnnotationEntry element : this.parameter_annotation_table) {
            element.dump(dos);
        }
    }

    @Override
    public Attribute copy(ConstantPool constant_pool) {
        return (Attribute)this.clone();
    }
}

