/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import java.io.DataOutputStream;
import java.io.IOException;

public class ElementValuePair {
    private final ElementValue elementValue;
    private final ConstantPool constantPool;
    private final int elementNameIndex;

    public ElementValuePair(int elementNameIndex, ElementValue elementValue, ConstantPool constantPool) {
        this.elementValue = elementValue;
        this.elementNameIndex = elementNameIndex;
        this.constantPool = constantPool;
    }

    public String getNameString() {
        ConstantUtf8 c = (ConstantUtf8)this.constantPool.getConstant(this.elementNameIndex, (byte)1);
        return c.getBytes();
    }

    public final ElementValue getValue() {
        return this.elementValue;
    }

    public int getNameIndex() {
        return this.elementNameIndex;
    }

    public String toShortString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getNameString()).append("=").append(this.getValue().toShortString());
        return result.toString();
    }

    protected void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.elementNameIndex);
        this.elementValue.dump(dos);
    }
}

