/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import java.util.TreeSet;
import jdd.graph.DepthFirstSearch;
import jdd.graph.Graph;
import jdd.graph.GraphIO;
import jdd.graph.Node;
import jdd.graph.NodeExtra4Comparator;
import jdd.util.Test;

public class TopologicalSort {
    public static Node[] sort(Graph graph) {
        DepthFirstSearch.DFS(graph);
        TreeSet<Node> treeSet = new TreeSet<Node>(NodeExtra4Comparator.nodeExtra4Comparator);
        Node[] nodeArray = graph.getNodes().elements();
        while (nodeArray.hasMoreElements()) {
            treeSet.add((Node)nodeArray.nextElement());
        }
        nodeArray = new Node[graph.numOfNodes()];
        int n = 0;
        while (!treeSet.isEmpty()) {
            Node node = (Node)treeSet.last();
            treeSet.remove(node);
            nodeArray[n++] = node;
        }
        return nodeArray;
    }

    public static void internal_test() {
        Test.start("TopologicalSort");
        Graph graph = GraphIO.loadXML("data/Bumstead.xml");
        Node[] nodeArray = TopologicalSort.sort(graph);
        Node node = nodeArray[nodeArray.length - 1];
        Test.check(node.label.equals("jacket") || node.label.equals("watch"), "Last element correct");
        Test.end();
    }
}

