/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import java.util.Enumeration;
import jdd.graph.AttributeExplorer;
import jdd.graph.Edge;
import jdd.graph.Graph;
import jdd.graph.Node;
import jdd.util.RingQueue;
import jdd.util.Test;

public class BreadthFirstSearch {
    public static void BFS_label_simple(Graph graph, Node node) {
        AttributeExplorer.setAllNodesExtra1(graph, -1);
        BreadthFirstSearch.BFS_label_internal_one(graph, node, graph.isDirected(), 0);
    }

    public static void BFS_label_complete(Graph graph, Node node) {
        AttributeExplorer.setAllNodesExtra1(graph, -1);
        int n = BreadthFirstSearch.BFS_label_internal_one(graph, node, graph.isDirected(), 0);
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            if (node2.extra1 >= 0) continue;
            n = BreadthFirstSearch.BFS_label_internal_one(graph, node2, graph.isDirected(), n);
        }
    }

    private static int BFS_label_internal_one(Graph graph, Node node, boolean bl, int n) {
        int n2 = graph.numOfNodes();
        RingQueue ringQueue = new RingQueue(n2);
        ringQueue.enqueue(node);
        while (!ringQueue.empty()) {
            Node node2 = (Node)ringQueue.dequeue();
            node2.extra1 = n++;
            Edge edge = node2.firstOut;
            while (edge != null) {
                if (edge.n2.extra1 == -1) {
                    edge.n2.extra1 = -2;
                    ringQueue.enqueue(edge.n2);
                }
                edge = edge.next;
            }
            if (bl) continue;
            edge = node2.firstIn;
            while (edge != null) {
                if (edge.n1.extra1 == -1) {
                    edge.n1.extra1 = -2;
                    ringQueue.enqueue(edge.n1);
                }
                edge = edge.prev;
            }
        }
        return n;
    }

    public static void internal_test() {
        Test.start("BreadthFirstSearch");
        Graph graph = new Graph(true);
        Node node = graph.addNode();
        Node node2 = graph.addNode();
        Node node3 = graph.addNode();
        Node node4 = graph.addNode();
        Node node5 = graph.addNode();
        Node node6 = graph.addNode();
        graph.addEdge(node, node2);
        graph.addEdge(node2, node3);
        graph.addEdge(node2, node4);
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                BreadthFirstSearch.BFS_label_simple(graph, node);
            } else {
                BreadthFirstSearch.BFS_label_complete(graph, node);
            }
            Test.checkEquality(node.extra1, 0, "node 1");
            Test.checkEquality(node2.extra1, 1, "node 2");
            Test.checkGreaterThan(node3.extra1, node2.extra1, "node 3");
            Test.checkGreaterThan(node4.extra1, node2.extra1, "node 4");
            Test.checkInequality(node3.extra1, node4.extra1, "parallel nodes have not same label");
            if (i == 0) {
                Test.checkEquality(node5.extra1, -1, "unreachable node should not be labelled (1)");
                Test.checkEquality(node6.extra1, -1, "unreachable node should not be labelled (2)");
                continue;
            }
            int n = Math.max(node3.extra1, node4.extra1);
            Test.checkGreaterThan(node5.extra1, n, "unreachable node should be labelled (1)");
            Test.checkGreaterThan(node6.extra1, n, "unreachable node should be labelled (2)");
            Test.checkInequality(node5.extra1, node6.extra1, "unreachable nodes have not same label");
        }
        Test.end();
    }
}

