/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata.bdd;

import java.util.Enumeration;
import java.util.HashMap;
import jdd.des.automata.Automata;
import jdd.des.automata.AutomataIO;
import jdd.des.automata.Automaton;
import jdd.des.automata.analysis.AutomataAnalyzer;
import jdd.graph.Edge;
import jdd.graph.Graph;
import jdd.graph.Node;
import jdd.util.Array;
import jdd.util.JDDConsole;
import jdd.util.Sort;

public class AutomataOrder {
    private static final int MAX_ROUNDS = 20;
    private static final int MIN_ITR = 50;
    private static final double STOP_CONST_C = 4.0;
    private Graph pcg;
    private Automaton[] a_order;
    private Node[] nodes;
    private HashMap node2automaton;
    private double lowest_span;
    private double[] weights;
    private int size;
    private int[] order;
    private int dfs_count;

    public AutomataOrder(Graph graph, HashMap hashMap) {
        this.node2automaton = hashMap;
        this.pcg = graph;
        this.size = graph.numOfNodes();
        this.a_order = new Automaton[this.size];
        this.nodes = new Node[this.size];
        this.order = new int[this.size];
        this.weights = new double[this.size];
        int n = 0;
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            this.nodes[n] = (Node)enumeration.nextElement();
            ++n;
        }
        this.compute_cardinality();
        int n2 = (int)(4.0 * Math.log(1 + this.size));
        if (n2 < 50) {
            n2 = 50;
        }
        this.lowest_span = Double.MAX_VALUE;
        for (int i = 0; i < 20; ++i) {
            if (i < 10) {
                this.create_dfs_order();
            } else {
                this.create_random_order();
            }
            double d = this.iterate(n2);
            if (!(this.lowest_span > d)) continue;
            this.lowest_span = d;
            this.extract_order();
        }
    }

    private double iterate(int n) {
        int n2 = n / 3;
        if (n2 < 5) {
            n2 = 5;
        }
        double d = -1.0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            this.force();
            double d2 = this.total_span();
            if (d2 == d) {
                if (++n3 < n2) continue;
                return d;
            }
            n3 = 0;
            d = d2;
        }
        return d;
    }

    private void force() {
        Node node;
        int n;
        for (n = 0; n < this.size; ++n) {
            node = this.nodes[n];
            double d = node.extra3;
            Edge edge = node.firstOut;
            while (edge != null) {
                d += edge.n2.extra3;
                edge = edge.next;
            }
            edge = node.firstIn;
            while (edge != null) {
                d += edge.n1.extra3;
                edge = edge.prev;
            }
            node.weight = d / (double)node.extra2;
        }
        for (n = 0; n < this.size; ++n) {
            node = this.nodes[n];
            node.extra4 = node.weight;
            Edge edge = node.firstOut;
            while (edge != null) {
                node.extra4 += edge.n2.extra3;
                edge = edge.next;
            }
            edge = node.firstIn;
            while (edge != null) {
                node.extra4 += edge.n1.extra3;
                edge = edge.prev;
            }
            node.extra4 /= (double)node.extraindex;
            this.weights[n] = node.extra4;
        }
        Sort.sort(this.nodes, this.weights, this.size, false);
        for (n = 0; n < this.size; ++n) {
            this.nodes[n].extra3 = n;
        }
    }

    private void compute_cardinality() {
        int n;
        for (n = 0; n < this.size; ++n) {
            this.nodes[n].extra2 = 1;
            this.nodes[n].extraindex = 1;
        }
        for (n = 0; n < this.size; ++n) {
            Edge edge = this.nodes[n].firstOut;
            while (edge != null) {
                ++edge.n1.extra2;
                ++edge.n2.extraindex;
                edge = edge.next;
            }
            edge = this.nodes[n].firstIn;
            while (edge != null) {
                ++edge.n2.extra2;
                ++edge.n1.extraindex;
                edge = edge.prev;
            }
        }
    }

    private void extract_order() {
        for (int i = 0; i < this.size; ++i) {
            this.a_order[i] = (Automaton)this.node2automaton.get(this.nodes[i]);
        }
    }

    public Automaton[] getBestOrder() {
        return this.a_order;
    }

    public double getCost() {
        return this.lowest_span;
    }

    private void create_random_order() {
        int[] nArray = Array.permutation(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.nodes[i].extra3 = nArray[i];
        }
    }

    private void create_dfs_order() {
        int n;
        int n2 = (int)(Math.random() * (double)this.size);
        this.dfs_count = 0;
        for (n = 0; n < this.size; ++n) {
            this.nodes[n].extra3 = -1.0;
        }
        this.dfs_rec(this.nodes[n2]);
        for (n = 0; n < this.size; ++n) {
            if (this.nodes[n].extra3 != -1.0) continue;
            this.dfs_rec(this.nodes[n2]);
        }
    }

    private void dfs_rec(Node node) {
        node.extra3 = this.dfs_count++;
        Edge edge = node.firstOut;
        while (edge != null) {
            if (edge.n2.extra3 == -1.0) {
                this.dfs_rec(edge.n2);
            }
            edge = edge.next;
        }
        edge = node.firstIn;
        while (edge != null) {
            if (edge.n1.extra3 == -1.0) {
                this.dfs_rec(edge.n1);
            }
            edge = edge.prev;
        }
    }

    private double total_span() {
        double d = 0.0;
        for (int i = 0; i < this.size; ++i) {
            Node node = this.nodes[i];
            double d2 = node.extra3;
            double d3 = node.extra3;
            node.extra4 = node.weight;
            Edge edge = node.firstOut;
            while (edge != null) {
                d2 = Math.min(d2, edge.n2.extra3);
                d3 = Math.max(d3, edge.n2.extra3);
                edge = edge.next;
            }
            edge = node.firstIn;
            while (edge != null) {
                d2 = Math.min(d2, edge.n1.extra3);
                d3 = Math.max(d3, edge.n1.extra3);
                edge = edge.prev;
            }
            d += d3 - d2;
        }
        return d;
    }

    public static void main(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Automata automata = AutomataIO.loadXML(stringArray[i]);
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                Graph graph = AutomataAnalyzer.getPCG(automata, hashMap, hashMap2);
                AutomataOrder automataOrder = new AutomataOrder(graph, hashMap);
                Automaton[] automatonArray = automataOrder.getBestOrder();
                JDDConsole.out.println("The automata order is:");
                for (int j = 0; j < automatonArray.length; ++j) {
                    JDDConsole.out.print(automatonArray[j].getName() + "\t");
                }
                JDDConsole.out.println("\n TOTAL COST " + automataOrder.getCost());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

