/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata;

import java.util.Enumeration;
import java.util.Iterator;
import jdd.bdd.sets.BDDUniverse;
import jdd.des.automata.Automata;
import jdd.des.automata.AutomataIO;
import jdd.des.automata.AutomataOperations;
import jdd.des.automata.Automaton;
import jdd.des.automata.AutomatonException;
import jdd.des.automata.Event;
import jdd.des.automata.State;
import jdd.des.automata.Transition;
import jdd.graph.AttributeExplorer;
import jdd.util.Configuration;
import jdd.util.Test;
import jdd.util.mixedradix.MRUniverse;
import jdd.util.sets.Set;
import jdd.util.sets.Universe;

public class ReachabilityTool {
    protected Automaton[] automata;
    protected Event[] alphabet;
    protected int size;
    protected int alphabet_size;
    protected boolean[][] event_care;
    protected State[][] map;
    protected State[] s_initial;
    protected int[] subdomains;
    protected Universe univ;
    protected Set g_r;
    protected double size_theoretical;
    protected double size_reserved;
    private static final double MAX_SEARCH_SIZE = Math.pow(2.0, 38.0);

    public ReachabilityTool(Automata automata) throws AutomatonException {
        this(AutomataOperations.asArray(automata));
    }

    public ReachabilityTool(Automaton[] automatonArray) throws AutomatonException {
        int n;
        int n2;
        this.automata = automatonArray;
        this.size = automatonArray.length;
        this.size_theoretical = 1.0;
        this.size_reserved = 1.0;
        for (int i = 0; i < this.size; ++i) {
            n2 = automatonArray[i].numOfNodes();
            this.size_theoretical *= (double)n2;
            this.size_reserved *= Math.pow(2.0, Math.ceil(Math.log(n2) / Math.log(2.0)));
        }
        if (this.size_theoretical > MAX_SEARCH_SIZE) {
            throw new AutomatonException("The current set of automata are too large (max " + this.size_theoretical + " states) for this implementation. Try to pre-sync");
        }
        java.util.Set set = AutomataOperations.getUnionAlphabet(automatonArray);
        this.alphabet_size = set.size();
        this.alphabet = new Event[this.alphabet_size];
        n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.alphabet[n2] = (Event)iterator.next();
            ++n2;
        }
        this.event_care = new boolean[this.size][this.alphabet.length];
        for (n = 0; n < this.size; ++n) {
            int n3;
            for (n3 = 0; n3 < this.alphabet.length; ++n3) {
                this.alphabet[n3].extra2 = 0;
            }
            Event event = automatonArray[n].getAlphabet().head();
            while (event != null) {
                ++event.parent.extra2;
                event = event.next;
            }
            for (n3 = 0; n3 < this.alphabet.length; ++n3) {
                this.event_care[n][n3] = this.alphabet[n3].extra2 != 0;
            }
        }
        this.map = new State[this.size][];
        this.subdomains = new int[this.size];
        for (n = 0; n < this.size; ++n) {
            this.subdomains[n] = automatonArray[n].numOfNodes();
            this.map[n] = new State[this.subdomains[n]];
            AttributeExplorer.updateExtraIndex(automatonArray[n]);
            Enumeration enumeration = automatonArray[n].getNodes().elements();
            while (enumeration.hasMoreElements()) {
                State state;
                this.map[n][state.extraindex] = state = (State)enumeration.nextElement();
            }
        }
        this.s_initial = new State[this.size];
        for (n = 0; n < this.size; ++n) {
            this.s_initial[n] = AutomataOperations.getInitialState(automatonArray[n]);
        }
        switch (Configuration.automataStateSetType) {
            case 0: {
                this.univ = new BDDUniverse(this.subdomains);
                break;
            }
            case 1: {
                this.univ = new MRUniverse(this.subdomains);
                break;
            }
            default: {
                throw new AutomatonException("invalid value in Configuration.automataStateSetType");
            }
        }
    }

    public void cleanup() {
        this.univ.free();
        this.univ = null;
    }

    public Set forward() {
        return this.forward(this.s_initial);
    }

    public Set forward(State[] stateArray) {
        Set set = this.univ.createEmptySet();
        int[] nArray = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            nArray[i] = stateArray[i].extraindex;
        }
        set.insert(nArray);
        this.g_r = set;
        this.traverse(nArray);
        this.g_r = null;
        return set;
    }

    protected int next(int n, int n2, Event event) {
        State state = this.map[n][n2];
        Transition transition = (Transition)state.firstOut;
        while (transition != null) {
            if (transition.event.parent == event) {
                State state2 = (State)transition.n2;
                return state2.extraindex;
            }
            transition = (Transition)transition.next;
        }
        return -1;
    }

    protected boolean elig(int[] nArray, int[] nArray2, int n) {
        Event event = this.alphabet[n];
        for (int i = 0; i < this.size; ++i) {
            if (!this.event_care[i][n]) {
                nArray2[i] = nArray[i];
                continue;
            }
            int n2 = this.next(i, nArray[i], event);
            if (n2 == -1) {
                return false;
            }
            nArray2[i] = n2;
        }
        return true;
    }

    protected void traverse(int[] nArray) {
        int[] nArray2 = new int[this.size];
        for (int i = 0; i < this.alphabet_size; ++i) {
            if (!this.elig(nArray, nArray2, i) || this.g_r.member(nArray2)) continue;
            this.g_r.insert(nArray2);
            this.traverse(nArray2);
        }
    }

    public double getTheoreticalSize() {
        return this.size_theoretical;
    }

    public double getReservedSize() {
        return this.size_reserved;
    }

    public Universe getUniverse() {
        return this.univ;
    }

    public static void internal_test() {
        Test.start("ReachabilityTool");
        try {
            Automata automata = AutomataIO.loadXML("data/phil.xml");
            ReachabilityTool reachabilityTool = new ReachabilityTool(automata);
            Set set = reachabilityTool.forward();
            Test.checkEquality(set.cardinality(), 19.0, "reachable states (1)");
            reachabilityTool.cleanup();
            automata = new Automata();
            for (int i = 0; i < 4; ++i) {
                Automaton automaton = automata.add("test" + i);
                Event event = automaton.addEvent("e" + i);
                State state = automaton.addState("s");
                state.setInitial(true);
                for (int j = 1; j < 6; ++j) {
                    State state2 = automaton.addState("q" + j);
                    automaton.addTransition(state, state2, event);
                    state = state2;
                }
            }
            reachabilityTool = new ReachabilityTool(automata);
            set = reachabilityTool.forward();
            Test.checkEquality(set.cardinality(), (double)((int)Math.pow(6.0, 4.0)), "reachable states (1)");
            reachabilityTool.cleanup();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Test.check(false, exception.toString());
        }
        Test.end();
    }
}

