/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter.emp;

import com.ozacc.mail.trotter.emp.BaseAction;
import com.ozacc.mail.trotter.emp.MailInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Properties;

public class CountListAction
extends BaseAction {
    private RandomAccessFile raf;
    private boolean delete;
    private String sql;
    private String sqlFileName;
    private int borderCount;
    private boolean genSql;

    public void init() {
        try {
            this.openFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string = this.getProperties().getProperty("delete");
        this.delete = Boolean.valueOf(string);
        this.sql = this.getProperties().getProperty("sql");
        this.sqlFileName = this.getProperties().getProperty("sqlfile");
        String string2 = this.getProperties().getProperty("count");
        if (this.sql != null && this.sqlFileName != null && string2 != null) {
            this.genSql = true;
            this.borderCount = Integer.parseInt(string2);
        }
    }

    public void end() {
        try {
            this.raf.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.genSql) {
            try {
                this.generateSql();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void generateSql() throws FileNotFoundException, IOException {
        BufferedReader bufferedReader = this.openListFile();
        PrintWriter printWriter = this.openTempFile();
        PrintWriter printWriter2 = this.openSqlFile();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split(",");
            String string2 = stringArray[0];
            int n = Integer.parseInt(stringArray[1]);
            if (n >= this.borderCount) {
                this.writeSql(string2, printWriter2);
                continue;
            }
            printWriter.println(string);
        }
        printWriter2.close();
        printWriter.close();
        bufferedReader.close();
        this.rename();
    }

    void rename() {
        File file = new File(this.getProperties().getProperty("file"));
        File file2 = new File(this.getProperties().getProperty("file") + ".tmp");
        boolean bl = file2.renameTo(file);
        if (!bl) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    printWriter.println(string);
                }
                printWriter.close();
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            file2.delete();
        }
    }

    private void writeSql(String string, PrintWriter printWriter) {
        String string2 = this.sql.replaceAll("\\$email", string);
        printWriter.println(string2);
        printWriter.flush();
    }

    private PrintWriter openSqlFile() throws IOException {
        return new PrintWriter(new BufferedWriter(new FileWriter(this.sqlFileName)));
    }

    private PrintWriter openTempFile() throws IOException {
        String string = this.getProperties().getProperty("file") + ".tmp";
        return new PrintWriter(new BufferedWriter(new FileWriter(string)));
    }

    private BufferedReader openListFile() throws FileNotFoundException {
        String string = this.getProperties().getProperty("file");
        return new BufferedReader(new FileReader(string));
    }

    public void execute(MailInfo mailInfo) throws Exception {
        if (mailInfo == null) {
            throw new NullPointerException("MailInfo\u304cnull");
        }
        String string = mailInfo.getEmail();
        if (string == null) {
            return;
        }
        if (string != null && this.delete) {
            mailInfo.setDelete(true);
        }
        this.add(string);
    }

    private void add(String string) throws IOException {
        int n = this.getCount(string);
        if (n < 0) {
            this.printNew(string);
        } else {
            this.printUpdate(string, ++n);
        }
    }

    private void printUpdate(String string, int n) throws IOException {
        this.raf.seek(this.getOffset(string));
        this.raf.writeBytes(string + "," + n);
    }

    private void printNew(String string) throws IOException {
        this.raf.seek(this.raf.length());
        this.raf.writeBytes(string + ",1\n");
    }

    private long getOffset(String string) throws IOException {
        this.raf.seek(0L);
        String string2 = null;
        while ((string2 = this.raf.readLine()) != null) {
            String[] stringArray = string2.split(",");
            if (!stringArray[0].equals(string)) continue;
            long l = this.raf.getFilePointer();
            return l - (long)string2.length() - 2L;
        }
        return -1L;
    }

    private int getCount(String string) throws IOException {
        this.raf.seek(0L);
        String string2 = null;
        while ((string2 = this.raf.readLine()) != null) {
            String[] stringArray = string2.split(",");
            if (!stringArray[0].equals(string)) continue;
            String string3 = stringArray[1];
            return Integer.parseInt(string3);
        }
        return -1;
    }

    private void openFile() throws FileNotFoundException {
        String string = this.getProperties().getProperty("file");
        this.raf = new RandomAccessFile(new File(string), "rw");
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        properties.setProperty("file", "emails.csv");
        CountListAction countListAction = new CountListAction();
        countListAction.setProperties(properties);
        countListAction.init();
        countListAction.rename();
        System.out.println("finish");
    }
}

