/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */
/*
 * BLACKfin port. By Suikan, 2004
 */

/*
 *	^XNReLXg샋[`iBLACKfinpj
 *
 *  ̃t@C cpu_config.h ƕĂ̂́C̃t@C TCB
 *  `ꂽɓǂޕKv̂ɑ΂āCcpu_config.h ɂ TCB 
 *  `OɓǂޕKv`܂ł邽߂łD
 */

#ifndef _CPU_CONTEXT_H_
#define _CPU_CONTEXT_H_

#include "task.h"

/*
 *  ^XNReLXg̏
 *
 *  ^XNx~ԂɈڍs鎞i^XN̐C^XN̏IjɌ
 *  ΂D{Iɂ́C^XNReLXg^XNNłԂɐ
 *  肷鏈Ccreate_context  activate_context ōs΂悢D
 */
Inline void
create_context(TCB *tcb)
{
}

/*
 *  ^XN̋N
 *
 *  ^XNx~ԂsłԂɈڍs鎞ɌĂ΂D
 */
extern void	activate_r(void);

Inline void
activate_context(TCB *tcb)
{
	VW	*sp;

	sp = (VW *)((SIZE)(tcb->tinib->stk) + tcb->tinib->stksz);
	*--sp = (VW)(tcb->tinib->exinf);	// ext_infvbV
	*--sp = (VW) ext_tsk;				// ext_tsk()̃AhXvbV
	*--sp = (VW)(tcb->tinib->task);		// ^XÑAhXvbV
	tcb->tskctxb.sp = sp;
	tcb->tskctxb.pc = activate_r;
}

/*
 *  ext_tsk X^bNɊmۂ_~[̈̃TCY
 */
#define	ACTIVATED_STACK_SIZE	(sizeof(VW) * 3)

/*
 *  calltex ͎gpȂ
 */
#define OMIT_CALLTEX

#endif /* _CPU_CONTEXT_H_ */
