/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.InstructionParser;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.Phase;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointInstruction;

public abstract class InstallableUnitPhase
extends Phase {
    public static final String PARM_ARTIFACT = "artifact";
    public static final String PARM_IU = "iu";
    public static final String PARM_INSTALL_FOLDER = "installFolder";

    protected InstallableUnitPhase(String phaseId, int weight, boolean forced) {
        super(phaseId, weight, forced);
    }

    protected InstallableUnitPhase(String phaseId, int weight) {
        this(phaseId, weight, false);
    }

    protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        parameters.put(PARM_INSTALL_FOLDER, profile.getProperty("org.eclipse.equinox.p2.installFolder"));
        return super.initializePhase(monitor, profile, parameters);
    }

    protected IStatus initializeOperand(IProfile profile, Operand operand, Map parameters, IProgressMonitor monitor) {
        InstallableUnitOperand iuOperand = (InstallableUnitOperand)operand;
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        InstallableUnitPhase.mergeStatus(status, this.initializeOperand(profile, iuOperand, parameters, monitor));
        InstallableUnitPhase.mergeStatus(status, super.initializeOperand(profile, operand, parameters, monitor));
        return status;
    }

    protected IStatus initializeOperand(IProfile profile, InstallableUnitOperand operand, Map parameters, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected IStatus completeOperand(IProfile profile, Operand operand, Map parameters, IProgressMonitor monitor) {
        InstallableUnitOperand iuOperand = (InstallableUnitOperand)operand;
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        InstallableUnitPhase.mergeStatus(status, super.completeOperand(profile, iuOperand, parameters, monitor));
        InstallableUnitPhase.mergeStatus(status, this.completeOperand(profile, iuOperand, parameters, monitor));
        return status;
    }

    protected IStatus completeOperand(IProfile profile, InstallableUnitOperand operand, Map parameters, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected final ProvisioningAction[] getActions(Operand operand) {
        if (!(operand instanceof InstallableUnitOperand)) {
            return null;
        }
        InstallableUnitOperand iuOperand = (InstallableUnitOperand)operand;
        return this.getActions(iuOperand);
    }

    protected abstract ProvisioningAction[] getActions(InstallableUnitOperand var1);

    public final boolean isApplicable(Operand operand) {
        if (!(operand instanceof InstallableUnitOperand)) {
            return false;
        }
        InstallableUnitOperand iuOperand = (InstallableUnitOperand)operand;
        return this.isApplicable(iuOperand);
    }

    protected boolean isApplicable(InstallableUnitOperand operand) {
        return true;
    }

    protected final ProvisioningAction[] getActions(IInstallableUnit unit, String key) {
        ITouchpointInstruction[] instructions = InstallableUnitPhase.getInstructions(unit, key);
        if (instructions == null || instructions.length == 0) {
            return null;
        }
        ArrayList<ProvisioningAction> actions = new ArrayList<ProvisioningAction>();
        InstructionParser instructionParser = new InstructionParser(this.getActionManager());
        int i = 0;
        while (i < instructions.length) {
            actions.addAll(Arrays.asList(instructionParser.parseActions(instructions[i], unit.getTouchpointType())));
            ++i;
        }
        return actions.toArray(new ProvisioningAction[actions.size()]);
    }

    private static final ITouchpointInstruction[] getInstructions(IInstallableUnit unit, String key) {
        ITouchpointData[] data = unit.getTouchpointData();
        if (data == null) {
            return null;
        }
        ArrayList<ITouchpointInstruction> matches = new ArrayList<ITouchpointInstruction>(data.length);
        int i = 0;
        while (i < data.length) {
            ITouchpointInstruction instructions = data[i].getInstruction(key);
            if (instructions != null) {
                matches.add(instructions);
            }
            ++i;
        }
        ITouchpointInstruction[] result = matches.toArray(new ITouchpointInstruction[matches.size()]);
        return result;
    }
}

