/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.filesystem.PrefixPool;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class FileSystemStructureProvider
implements IImportStructureProvider {
    private PrefixPool pathPrefixHistory;
    private PrefixPool rootPathHistory;

    public List getChildren(Object element) {
        File folder = (File)element;
        String[] children = folder.list();
        int childrenLength = children == null ? 0 : children.length;
        ArrayList<File> result = new ArrayList<File>(childrenLength);
        int i = 0;
        while (i < childrenLength) {
            File file = new File(folder, children[i]);
            if (!file.isDirectory() || !this.isRecursiveLink(folder, file)) {
                result.add(file);
            }
            ++i;
        }
        return result;
    }

    private void initLinkHistoriesIfNeeded() {
        if (this.pathPrefixHistory == null) {
            this.pathPrefixHistory = new PrefixPool(20);
            this.rootPathHistory = new PrefixPool(20);
        }
    }

    private boolean isRecursiveLink(File parentFile, File childFile) {
        boolean isRecursive = false;
        try {
            String parentPath = String.valueOf(parentFile.getCanonicalPath()) + '/';
            String childPath = String.valueOf(childFile.getCanonicalPath()) + '/';
            this.initLinkHistoriesIfNeeded();
            this.pathPrefixHistory.insertLonger(parentPath);
            if (this.pathPrefixHistory.containsAsPrefix(childPath)) {
                if (!this.rootPathHistory.insertShorter(childPath)) {
                    isRecursive = true;
                }
            } else if (this.rootPathHistory.hasPrefixOf(childPath)) {
                isRecursive = false;
            } else {
                this.rootPathHistory.insertShorter(childPath);
            }
        }
        catch (IOException iOException) {}
        return isRecursive;
    }

    public InputStream getContents(Object element) {
        try {
            return new FileInputStream((File)element);
        }
        catch (FileNotFoundException e) {
            IDEWorkbenchPlugin.log(e.getLocalizedMessage(), e);
            return null;
        }
    }

    public String getFullPath(Object element) {
        return ((File)element).getPath();
    }

    public String getLabel(Object element) {
        File file = (File)element;
        String name = file.getName();
        if (name.length() == 0) {
            return file.getPath();
        }
        return name;
    }

    public boolean isFolder(Object element) {
        return ((File)element).isDirectory();
    }
}

