/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class XYChopboxAnchor
extends ChopboxAnchor {
    private int xp = -1;
    private int yp = -1;

    public XYChopboxAnchor(IFigure owner) {
        super(owner);
    }

    public XYChopboxAnchor(IFigure owner, int xp, int yp) {
        super(owner);
        this.xp = xp;
        this.yp = yp;
    }

    public void setLocation(int xp, int yp) {
        this.xp = xp;
        this.yp = yp;
        this.fireAnchorMoved();
    }

    public Point getLocation(Point reference) {
        if (this.xp != -1 && this.yp != -1) {
            Rectangle bounds = this.getBox();
            Point point = new Point(bounds.x + bounds.width * this.xp / 100, bounds.y + bounds.height * this.yp / 100);
            this.getOwner().translateToAbsolute((Translatable)point);
            return point;
        }
        return super.getLocation(reference);
    }

    public Point getReferencePoint() {
        if (this.xp != -1 && this.yp != -1) {
            Rectangle bounds = this.getBox();
            Point point = new Point(bounds.x + bounds.width * this.xp / 100, bounds.y + bounds.height * this.yp / 100);
            this.getOwner().translateToAbsolute((Translatable)point);
            return point;
        }
        return super.getReferencePoint();
    }

    public boolean equals(Object obj) {
        if (obj instanceof XYChopboxAnchor) {
            XYChopboxAnchor other = (XYChopboxAnchor)((Object)obj);
            return other.getOwner() == this.getOwner() && other.getBox().equals((Object)this.getBox()) && other.xp == this.xp && other.yp == this.yp && super.equals((Object)other);
        }
        return false;
    }

    public int hashCode() {
        if (this.getOwner() != null) {
            return this.getOwner().hashCode();
        }
        return super.hashCode();
    }
}

