/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.component.AttributeSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.ImplementInfoSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.TableNameSettingPanel;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.IAttribute;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TableEditDialog
extends Dialog {
    private AbstractEntityModel original;
    private AbstractEntityModel editedValue;
    private List<EditAttribute> editAttributeList = new ArrayList<EditAttribute>();
    private String title;
    private TableNameSettingPanel panel1;
    private AttributeSettingPanel panel2;
    private ImplementInfoSettingPanel panel3;
    private List<IAttribute> newAttributeOrder = new ArrayList<IAttribute>();
    private List<IAttribute> addAttributes = new ArrayList<IAttribute>();
    private List<IAttribute> editAttributes = new ArrayList<IAttribute>();

    public TableEditDialog(Shell parentShell, String title, AbstractEntityModel original) {
        super(parentShell);
        this.title = title;
        this.original = original;
        for (IAttribute a : this.original.getAttributes()) {
            this.editAttributeList.add(new EditAttribute(a));
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.panel1 = new TableNameSettingPanel(composite, 0);
        GridData gridData = new GridData(768);
        this.panel1.setLayoutData(gridData);
        gridData = new GridData(768);
        this.panel3 = new ImplementInfoSettingPanel(composite, 0);
        this.panel3.setLayoutData(gridData);
        gridData = new GridData(768);
        this.panel2 = new AttributeSettingPanel(composite, 0);
        this.panel2.setLayoutData(gridData);
        composite.pack();
        this.initializeValue();
        return composite;
    }

    private void initializeValue() {
        this.panel1.setTableName(this.original.getName());
        this.panel2.setAttributeTableRow(this.editAttributeList);
        this.panel3.initializeValue(this.original.isNotImplement(), this.original.getImplementName());
    }

    protected void okPressed() {
        try {
            this.editedValue = (AbstractEntityModel)this.original.getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.editedValue.setName(this.panel1.getTableName());
        this.editedValue.setNotImplement(this.panel3.isNotImplement());
        this.editedValue.setImplementName(this.panel3.getImplementName());
        this.createEditAttributeResult();
        super.okPressed();
    }

    private void createEditAttributeResult() {
        for (EditAttribute ea : this.editAttributeList) {
            IAttribute originalAttribute = ea.getOriginalAttribute();
            if (ea.isAdded()) {
                ea.copyToOriginal();
                this.addAttributes.add(ea.getOriginalAttribute());
            } else if (ea.isNameChanged()) {
                this.editAttributes.add(originalAttribute);
            }
            this.newAttributeOrder.add(originalAttribute);
        }
        this.editedValue.setAttributes(this.newAttributeOrder);
    }

    public List<EditAttribute> getEditAttributeList() {
        return this.editAttributeList;
    }

    public AbstractEntityModel getEditedValue() {
        return this.editedValue;
    }
}

