/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.collector.util;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.LogId;
import jp.terasoluna.fw.collector.util.strategy.ComparatorCompareStrategy;
import jp.terasoluna.fw.collector.util.strategy.CompareStrategy;
import jp.terasoluna.fw.logger.TLogger;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.builder.EqualsBuilder;

/**
 * Rg[uCN`FbJ[.<br>
 */
public class ControlBreakChecker {

    /**
     * Log.
     */
    private static final TLogger LOGGER = TLogger
            .getLogger(ControlBreakChecker.class);

    /**
     * RXgN^.
     */
    protected ControlBreakChecker() {
    }

    /**
     * ORg[uCN胁\bh.<br>
     * @param collector Collector&lt;?&gt;
     * @param keys String...
     * @return true:Rg[uCNs/false:Rg[uCNȂ
     */
    public static boolean isPreBreak(Collector<?> collector, String... keys) {
        return isPreBreak(collector, null, keys);
    }

    /**
     * ORg[uCN胁\bh.<br>
     * keys̐compareStrategies̐ƁArɗpCompareStrategẙ֌W͈ȉ̂悤ɂȂ.<br>
     * <ul>
     * <li>keys : compareStrategies = N : N (܂Nȏ)̏ꍇ
     * <ul>
     * <li>keys[i]CompareStrategycompareStrategies[i]</li>
     * </ul>
     * </li>
     * <li>keys : compareStrategies = N : 1̏ꍇ
     * <ul>
     * <li>keys[i]CompareStrategycompareStrategies[0]</li>
     * </ul>
     * </li>
     * <li>keys : compareStrategies = N : M (N &gt; M)̏ꍇ
     * <ul>
     * <li>keys[i] (i &lt; M)CompareStrategycompareStrategies[i]</li>
     * <li>keys[i] (i &gt;= M)CompareStrategynull</li>
     * </ul>
     * </li>
     * </ul>
     * rdĺA{@link #equalsObjects(Object, Object, CompareStrategy)} QƂ̂.
     * @param collector Collector&lt;?&gt;
     * @param compareStrategies CompareStrategy&lt;?&gt;[]
     * @param keys String[]
     * @return true:Rg[uCNs/false:Rg[uCNȂ
     * @see #equalsObjects(Object, Object, CompareStrategy)
     */
    public static boolean isPreBreak(Collector<?> collector,
            CompareStrategy<?>[] compareStrategies, String[] keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getPrevious();

            return isBreakInternal(current, other, compareStrategies, keys);
        }
        return false;
    }

    /**
     * ㏈Rg[uCN胁\bh.<br>
     * @param collector Collector&lt;?&gt;
     * @param keys String...
     * @return true:Rg[uCNs/false:Rg[uCNȂ
     */
    public static boolean isBreak(Collector<?> collector, String... keys) {
        return isBreak(collector, null, keys);
    }

    /**
     * ㏈Rg[uCN胁\bh.<br>
     * keys̐compareStrategies̐ƁArɗpCompareStrategẙ֌W͈ȉ̂悤ɂȂ.<br>
     * <ul>
     * <li>keys : compareStrategies = N : N (܂Nȏ)̏ꍇ
     * <ul>
     * <li>keys[i]CompareStrategycompareStrategies[i]</li>
     * </ul>
     * </li>
     * <li>keys : compareStrategies = N : 1̏ꍇ
     * <ul>
     * <li>keys[i]CompareStrategycompareStrategies[0]</li>
     * </ul>
     * </li>
     * <li>keys : compareStrategies = N : M (N &gt; M)̏ꍇ
     * <ul>
     * <li>keys[i] (i &lt; M)CompareStrategycompareStrategies[i]</li>
     * <li>keys[i] (i &gt;= M)CompareStrategynull</li>
     * </ul>
     * </li>
     * </ul>
     * rdĺA{@link #equalsObjects(Object, Object, CompareStrategy)} QƂ̂.
     * @param collector Collector&lt;?&gt;
     * @param compareStrategies CompareStrategy&lt;?&gt;[]
     * @param keys String[]
     * @return true:Rg[uCNs/false:Rg[uCNȂ
     * @see #equalsObjects(Object, Object, CompareStrategy)
     */
    public static boolean isBreak(Collector<?> collector,
            CompareStrategy<?>[] compareStrategies, String[] keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getNext();

            return isBreakInternal(current, other, compareStrategies, keys);
        }
        return false;
    }

    /**
     * Rg[uCN胁\bh.<br>
     * ̃\bh́Aver.1.1.xȑOƂ̌݊ۂ߂ɎcĂ.<br>
     * VKɍ쐬R[h̏ꍇ́A<br>
     * {@link #isBreak(Collector, CompareStrategy[], String[])}A<br>
     * {@link #isPreBreak(Collector, CompareStrategy[], String[])}A<br>
     * {@link #isBreakInternal(Object, Object, CompareStrategy[], String...)}<br>
     * gp邱.<br>
     * @param current Object rIuWFNg
     * @param other Object rIuWFNg
     * @param comparators Comparator&lt;?&gt;[]
     * @param keys String...
     * @return true:Rg[uCNs/false:Rg[uCNȂ
     * @see #isBreak(Collector, CompareStrategy[], String[])
     * @see #isPreBreak(Collector, CompareStrategy[], String[])
     * @see #isBreakInternal(Object, Object, CompareStrategy[], String...)
     */
    protected static boolean isBreakInternal(Object current, Object other,
            Comparator<?>[] comparators, String... keys) {

        // comparator -> compareStrategyւ̋lߑւs
        if (comparators != null) {
            CompareStrategy<?>[] compareStrategies = new CompareStrategy[comparators.length];

            for (int i = 0; i < comparators.length; i++) {
                compareStrategies[i] = new ComparatorCompareStrategy(
                        comparators[i]);
            }
            return isBreakInternal(current, other, compareStrategies, keys);
        } else {
            return isBreakInternal(current, other, (CompareStrategy[]) null,
                    keys);
        }

    }

    /**
     * Rg[uCN胁\bh.<br>
     * keys̐compareStrategies̐ƁArɗpCompareStrategẙ֌W͈ȉ̂悤ɂȂ.<br>
     * <ul>
     * <li>keys : compareStrategies = N : N (܂Nȏ)̏ꍇ
     * <ul>
     * <li>keys[i]CompareStrategycompareStrategies[i]</li>
     * </ul>
     * </li>
     * <li>keys : compareStrategies = N : 1̏ꍇ
     * <ul>
     * <li>keys[i]CompareStrategycompareStrategies[0]</li>
     * </ul>
     * </li>
     * <li>keys : compareStrategies = N : M (N &gt; M)̏ꍇ
     * <ul>
     * <li>keys[i] (i &lt; M)CompareStrategycompareStrategies[i]</li>
     * <li>keys[i] (i &gt;= M)CompareStrategynull</li>
     * </ul>
     * </li>
     * </ul>
     * rɂ {@link #equalsObjects(Object, Object, CompareStrategy)} \bhgp.
     * @param current Object rIuWFNg
     * @param other Object rIuWFNg
     * @param compareStrategies CompareStrategy&lt;?&gt;[]
     * @param keys String...
     * @return true:Rg[uCNs/false:Rg[uCNȂ
     * @see #equalsObjects(Object, Object, CompareStrategy)
     */
    protected static boolean isBreakInternal(Object current, Object other,
            CompareStrategy<?>[] compareStrategies, String... keys) {

        // keyXgnull̏ꍇfalse
        if (keys == null || keys.length == 0) {
            // Rg[uCNȂ
            return false;
        }

        // ЕnullŁAЕnot null̏ꍇtrue
        if ((current != null && other == null)
                || (current == null && other != null)) {
            // Rg[uCN
            return true;
        }

        if (other != null && current != null) {

            for (int keyIndex = 0; keyIndex < keys.length; keyIndex++) {
                String key = keys[keyIndex];
                CompareStrategy<?> compareStrategy = null;

                if (compareStrategies != null) {
                    if (compareStrategies.length == 1) {
                        compareStrategy = compareStrategies[0];
                    } else if (keyIndex < compareStrategies.length) {
                        compareStrategy = compareStrategies[keyIndex];
                    }
                }

                if (key != null && key.length() != 0) {
                    Object currentValue = null;
                    Object otherValue = null;

                    // l擾
                    try {
                        currentValue = PropertyUtils.getProperty(current, key);
                    } catch (Exception e) {
                        logOutputPropNotFound(e, current, key);
                        // Oo͂Ď̍ڂ`FbN
                        continue;
                    }

                    // l擾
                    try {
                        otherValue = PropertyUtils.getProperty(other, key);
                    } catch (Exception e) {
                        logOutputPropNotFound(e, other, key);
                        // Oo͂Ď̍ڂ`FbN
                        continue;
                    }

                    // r
                    if (!equalsObjects(currentValue, otherValue, compareStrategy)) {
                        return true;
                    }
                }
            }
        }
        // Rg[uCNȂ
        return false;
    }

    /**
     * ORg[uCNL[擾.<br>
     * @param collector Collector&lt;?&gt;
     * @param keys String...
     * @return Rg[uCNL[Xg
     */
    public static Map<String, Object> getPreBreakKey(Collector<?> collector,
            String... keys) {
        return getPreBreakKey(collector, null, keys);
    }

    /**
     * ORg[uCNL[擾.<br>
     * keys̐compareStrategies̐ƁArɗpCompareStrategẙ֌W͈ȉ̂悤ɂȂ.<br>
     * <ul>
     * <li>keys : compareStrategies = N : N (܂Nȏ)̏ꍇ
     * <ul>
     * <li>keys[i]CompareStrategycompareStrategies[i]</li>
     * </ul>
     * </li>
     * <li>keys : compareStrategies = N : 1̏ꍇ
     * <ul>
     * <li>keys[i]CompareStrategycompareStrategies[0]</li>
     * </ul>
     * </li>
     * <li>keys : compareStrategies = N : M (N &gt; M)̏ꍇ
     * <ul>
     * <li>keys[i] (i &lt; M)CompareStrategycompareStrategies[i]</li>
     * <li>keys[i] (i &gt;= M)CompareStrategynull</li>
     * </ul>
     * </li>
     * </ul>
     * rdĺA{@link #equalsObjects(Object, Object, CompareStrategy)} QƂ̂.
     * @param collector Collector&lt;?&gt;
     * @param compareStrategies CompareStrategy&lt;?&gt;[]
     * @param keys String[]
     * @return Rg[uCNL[Xg
     * @see #equalsObjects(Object, Object, CompareStrategy)
     */
    public static Map<String, Object> getPreBreakKey(Collector<?> collector,
            CompareStrategy<?>[] compareStrategies, String[] keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getPrevious();

            return getBreakKeyInternal(current, other,
                    (CompareStrategy<?>[]) compareStrategies, keys);
        }
        return new LinkedHashMap<String, Object>();
    }

    /**
     * ㏈Rg[uCNL[擾.<br>
     * @param collector Collector&lt;?&gt;
     * @param keys String...
     * @return Rg[uCNL[Xg
     */
    public static Map<String, Object> getBreakKey(Collector<?> collector,
            String... keys) {
        return getBreakKey(collector, null, keys);
    }

    /**
     * ㏈Rg[uCNL[擾.<br>
     * keys̐compareStrategies̐ƁArɗpCompareStrategẙ֌W͈ȉ̂悤ɂȂ.<br>
     * <ul>
     * <li>keys : compareStrategies = N : N (܂Nȏ)̏ꍇ
     * <ul>
     * <li>keys[i]CompareStrategycompareStrategies[i]</li>
     * </ul>
     * </li>
     * <li>keys : compareStrategies = N : 1̏ꍇ
     * <ul>
     * <li>keys[i]CompareStrategycompareStrategies[0]</li>
     * </ul>
     * </li>
     * <li>keys : compareStrategies = N : M (N &gt; M)̏ꍇ
     * <ul>
     * <li>keys[i] (i &lt; M)CompareStrategycompareStrategies[i]</li>
     * <li>keys[i] (i &gt;= M)CompareStrategynull</li>
     * </ul>
     * </li>
     * </ul>
     * rdĺA{@link #equalsObjects(Object, Object, CompareStrategy)} QƂ̂.
     * @param collector Collector&lt;?&gt;
     * @param compareStrategies CompareStrategy&lt;?&gt;[]
     * @param keys String[]
     * @return Rg[uCNL[Xg
     * @see #equalsObjects(Object, Object, CompareStrategy)
     */
    public static Map<String, Object> getBreakKey(Collector<?> collector,
            CompareStrategy<?>[] compareStrategies, String[] keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getNext();

            return getBreakKeyInternal(current, other,
                    (CompareStrategy<?>[]) compareStrategies, keys);
        }
        return new LinkedHashMap<String, Object>();
    }

    /**
     * Rg[uCNL[擾.<br>
     * ̃\bh́Aver.1.1.xȑOƂ̌݊ۂ߂ɎcĂ.<br>
     * VKɍ쐬R[h̏ꍇ́A<br>
     * {@link #getBreakKey(Collector, CompareStrategy[], String[])}A<br>
     * {@link #getPreBreakKey(Collector, CompareStrategy[], String[])}A<br>
     * {@link #getBreakKeyInternal(Object, Object, CompareStrategy[], String...)}<br>
     * gp邱.<br>
     * @param current Object rIuWFNg
     * @param other Object rIuWFNg
     * @param comparators Comparator&lt;?&gt;[]
     * @param keys String...
     * @return Rg[uCNL[Xg
     * @see #getBreakKey(Collector, CompareStrategy[], String[])
     * @see #getPreBreakKey(Collector, CompareStrategy[], String[])
     * @see #getBreakKeyInternal(Object, Object, CompareStrategy[], String...)
     */
    protected static Map<String, Object> getBreakKeyInternal(Object current,
            Object other, Comparator<?>[] comparators, String... keys) {

        // comparator -> compareStrategyւ̋lߑւs
        if (comparators != null) {
            CompareStrategy<?>[] compareStrategies = new CompareStrategy[comparators.length];

            for (int i = 0; i < comparators.length; i++) {
                compareStrategies[i] = new ComparatorCompareStrategy(
                        comparators[i]);
            }
            return getBreakKeyInternal(current, other, compareStrategies, keys);
        } else {
            return getBreakKeyInternal(current, other,
                    (CompareStrategy[]) null, keys);
        }
    }

    /**
     * Rg[uCNL[擾.<br>
     * keys̐compareStrategies̐ƁArɗpCompareStrategẙ֌W͈ȉ̂悤ɂȂ.<br>
     * <ul>
     * <li>keys : compareStrategies = N : N (܂Nȏ)̏ꍇ
     * <ul>
     * <li>keys[i]CompareStrategycompareStrategies[i]</li>
     * </ul>
     * </li>
     * <li>keys : compareStrategies = N : 1̏ꍇ
     * <ul>
     * <li>keys[i]CompareStrategycompareStrategies[0]</li>
     * </ul>
     * </li>
     * <li>keys : compareStrategies = N : M (N &gt; M)̏ꍇ
     * <ul>
     * <li>keys[i] (i &lt; M)CompareStrategycompareStrategies[i]</li>
     * <li>keys[i] (i &gt;= M)CompareStrategynull</li>
     * </ul>
     * </li>
     * </ul>
     * rɂ {@link #equalsObjects(Object, Object, CompareStrategy)} \bhgp.
     * @param current Object rIuWFNg
     * @param other Object rIuWFNg
     * @param compareStrategies CompareStrategy&lt;?&gt;[]
     * @param keys String...
     * @return Rg[uCNL[Xg
     * @see #equalsObjects(Object, Object, CompareStrategy)
     */
    protected static Map<String, Object> getBreakKeyInternal(Object current,
            Object other, CompareStrategy<?>[] compareStrategies,
            String... keys) {
        boolean inBreak = false;
        Map<String, Object> result = new LinkedHashMap<String, Object>();

        // keyXgnull̏ꍇfalse
        if (keys == null || keys.length == 0) {
            // Rg[uCNȂ
            return result;
        }

        for (int keyIndex = 0; keyIndex < keys.length; keyIndex++) {
            String key = keys[keyIndex];
            CompareStrategy<?> compareStrategy = null;
            Object currentValue = null;
            Object otherValue = null;

            if (compareStrategies != null) {
                if (compareStrategies.length == 1) {
                    compareStrategy = compareStrategies[0];
                } else if (keyIndex < compareStrategies.length) {
                    compareStrategy = compareStrategies[keyIndex];
                }
            }

            if (key != null && key.length() != 0) {

                // l擾
                if (current != null) {
                    try {
                        currentValue = PropertyUtils.getProperty(current, key);
                    } catch (Exception e) {
                        logOutputPropNotFound(e, current, key);
                        // Oo͂Ď̍ڂ`FbN
                        continue;
                    }
                }

                // l擾
                if (other != null) {
                    try {
                        otherValue = PropertyUtils.getProperty(other, key);
                    } catch (Exception e) {
                        logOutputPropNotFound(e, other, key);
                        // Oo͂Ď̍ڂ`FbN
                        continue;
                    }
                }

                if (!inBreak) {
                    // ЕnullŁAЕnot null̏ꍇtrue
                    if ((current != null && other == null)
                            || (current == null && other != null)) {
                        // Rg[uCN
                        inBreak = true;
                    }

                    // r
                    if (!equalsObjects(currentValue, otherValue, compareStrategy)) {
                        // Rg[uCN
                        inBreak = true;
                    }
                }
            }

            if (inBreak) {
                result.put(key, currentValue);
            }
        }
        return result;
    }

    /**
     * IuWFNgƕʂ̃IuWFNgǂr.<br>
     * <code>equalsObjects(value1, value2, null);</code> ŝƓł.<br>
     * ̃\bh́Aver.1.1.xȑOƂ̃RpC݊ۂ߂ɎcĂ.<br>
     * 
     * ȉ̃NX<b></b>AComparableNX̃CX^Xm̔ŕA
     * ver.1.1.xȑOƂ͔rʂقȂ\.<br>
     * <ul>
     * <li>ver.1.1.xȑOłequals\bhŔrAA
     * Comparable̎equals̎ɈѐNX.
     * <ul>
     * <li>java.math.BigInteger</li>
     * <li>java.lang.Byte</li>
     * <li>java.lang.Double</li>
     * <li>java.lang.Float</li>
     * <li>java.lang.Integer</li>
     * <li>java.lang.Long</li>
     * <li>java.lang.Short</li>
     * <li>java.lang.Boolean</li>
     * <li>java.lang.Character</li>
     * <li>java.lang.String</li>
     * <li>java.util.Date(java.sql.DatẽTuNX܂܂Ȃ)</li>
     * </ul>
     * </li>
     * </ul>
     * 
     * ̃\bh̑ɁA<br>
     * {@link #equalsObjects(Object, Object, CompareStrategy)}<br>
     * gp邱.<br>
     * @param value1 Object rIuWFNg
     * @param value2 Object rIuWFNg
     * @return ꍇ:true / łȂꍇ:false
     * @see #equalsObjects(Object, Object, CompareStrategy)
     * @deprecated ̃\bh̑ɁA{@link #equalsObjects(Object, Object, CompareStrategy)}gp邱.
     */
    protected static boolean equalsObjects(Object value1, Object value2) {
        return equalsObjects(value1, value2, null);
    }

    /**
     * OóivpeBȂꍇj.<br>
     * @param e Exception
     * @param obj Object
     * @param key String
     */
    protected static void logOutputPropNotFound(Exception e, Object obj,
            String key) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(LogId.WAL041002, key, obj == null ? null : obj
                    .getClass().getSimpleName(),
                    e == null ? null : e.getMessage());
        }
    }

    /**
     * IuWFNgƕʂ̃IuWFNgǂr.<br>
     * <ul>
     * <li>ǂnullłȂꍇAȉ̂悤ɔr.
     * <ul>
     * <li>compareStrategynullłȂꍇAcompareStrategyŔr</li>
     * <li>compareStrategynullłꍇArIuWFNǧ^ɉāAȉ̂悤ɔr
     * <ul>
     * <li>rIuWFNgComparableNX̃CX^X̏ꍇAComparable#compareToŔr
     * <li>rIuWFNgClass܂͂̃X[p[NX̃CX^X̏ꍇAObject#equalsŔr
     * <li>L2ȊȌꍇAorg.apache.commons.lang.builder.EqualsBuilder#reflectionEqualsŔr
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>ǂnull̏ꍇAƂ݂Ȃ.</li>
     * <li>ǂ݂̂null̏ꍇAȂƂ݂Ȃ.</li>
     * </ul>
     * @param value1 Object rIuWFNg
     * @param value2 Object rIuWFNg
     * @param compareStrategy CompareStrategy
     * @return ꍇ:true / łȂꍇ:false
     */
    @SuppressWarnings({"rawtypes", "unchecked"})
    protected static boolean equalsObjects(Object value1,
            Object value2, CompareStrategy compareStrategy) {

        if (value1 != null && value2 != null) {
            // value1,value2̂ǂɂlĂꍇ
            if (compareStrategy != null) {
                return compareStrategy.equalsObjects(value1, value2);
            } else {
                Class<? extends Object> clazz = value1.getClass();

                if (value1 instanceof Comparable) {
                    // value1ComparableĂꍇcompareToŔr
                    return (((Comparable) value1).compareTo(value2) == 0);
                } else if (clazz.isAssignableFrom(Class.class)) {
                    // value1Class܂͂̃X[p[NX̃CX^X̏ꍇObject#equalsŔr
                    return value1.equals(value2);
                } else {
                    // ȊȌꍇreflectionEqualsŔr
                    return EqualsBuilder.reflectionEquals(value1, value2);
                }
            }
        } else if (value1 == null && value2 == null) {
            // value1,value2̂ǂɂlĂȂꍇ
            return true;
        }
        // value1,value2̂ǂ炩ɒlĂꍇ
        return false;

    }
}
