/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector.db;

import java.lang.reflect.InvocationTargetException;
import jp.terasoluna.fw.collector.db.InterruptedRuntimeException;
import jp.terasoluna.fw.collector.db.QueueingDataRowHandler;
import jp.terasoluna.fw.collector.db.QueueingDataRowHandlerImpl;
import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.logger.TLogger;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

public class Queueing1NRelationDataRowHandlerImpl
extends QueueingDataRowHandlerImpl
implements QueueingDataRowHandler {
    private static final TLogger LOGGER = TLogger.getLogger(Queueing1NRelationDataRowHandlerImpl.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delayCollect() {
        if (this.prevRow == null) return;
        if (Thread.currentThread().isInterrupted()) throw new InterruptedRuntimeException();
        long dtcnt = this.dataCount.incrementAndGet();
        try {
            Object copy = BeanUtils.cloneBean((Object)this.prevRow);
            PropertyUtils.copyProperties((Object)this.prevRow, this.prevRow.getClass().newInstance());
            if (this.dbCollector == null) return;
            this.dbCollector.addQueue(new DataValueObject(copy, dtcnt));
            return;
        }
        catch (IllegalAccessException e) {
            throw new SystemException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new SystemException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SystemException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new SystemException((Throwable)e);
        }
        catch (InterruptedException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("TAL041002", new Object[]{Thread.currentThread().getName()});
            }
            Thread.currentThread().interrupt();
            throw new InterruptedRuntimeException(e);
        }
    }
}

