/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector.db;

import jp.terasoluna.fw.collector.AbstractCollector;
import jp.terasoluna.fw.collector.db.DBCollectorConfig;
import jp.terasoluna.fw.collector.db.DBCollectorPrePostProcess;
import jp.terasoluna.fw.collector.db.DBCollectorPrePostProcessStatus;
import jp.terasoluna.fw.collector.db.Queueing1NRelationDataRowHandlerImpl;
import jp.terasoluna.fw.collector.db.QueueingDataRowHandler;
import jp.terasoluna.fw.collector.db.QueueingDataRowHandlerImpl;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import jp.terasoluna.fw.dao.event.DataRowHandler;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.logger.TLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCollector<P>
extends AbstractCollector<P> {
    private static final TLogger LOGGER = TLogger.getLogger(DBCollector.class);
    protected QueryRowHandleDAO queryRowHandleDAO = null;
    protected String sqlID = null;
    protected Object bindParams = null;
    protected QueueingDataRowHandler rowHandler = null;
    protected Class<? extends QueueingDataRowHandler> queueingDataRowHandlerClass = QueueingDataRowHandlerImpl.class;
    protected DBCollectorPrePostProcess dbCollectorPrePostProcess = null;

    protected DBCollector() {
    }

    public DBCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams));
    }

    public DBCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, boolean relation1n) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addRelation1n(relation1n));
    }

    public DBCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, int queueSize) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addQueueSize(queueSize));
    }

    public DBCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, CollectorExceptionHandler exceptionHandler) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addExceptionHandler(exceptionHandler));
    }

    public DBCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, int queueSize, boolean relation1n, CollectorExceptionHandler exceptionHandler, DBCollectorPrePostProcess dbCollectorPrePostProcess) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addQueueSize(queueSize).addRelation1n(relation1n).addExceptionHandler(exceptionHandler).addDbCollectorPrePostProcess(dbCollectorPrePostProcess));
    }

    public DBCollector(DBCollectorConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("The parameter is null.");
        }
        this.queryRowHandleDAO = config.getQueryRowHandleDAO();
        this.sqlID = config.getSqlID();
        this.bindParams = config.getBindParams();
        if (config.getQueueSize() > 0) {
            this.setQueueSize(config.getQueueSize());
        }
        if (config.isRelation1n()) {
            this.queueingDataRowHandlerClass = Queueing1NRelationDataRowHandlerImpl.class;
        }
        this.exceptionHandler = config.getExceptionHandler();
        this.dbCollectorPrePostProcess = config.getDbCollectorPrePostProcess();
        if (config.isExecuteByConstructor()) {
            this.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        try {
            DBCollectorPrePostProcessStatus expStatus = null;
            do {
                try {
                    this.preprocess();
                    this.queryRowHandleDAO.executeWithRowHandler(this.sqlID, this.bindParams, (DataRowHandler)this.rowHandler);
                    this.rowHandler.delayCollect();
                    this.postprocessComplete();
                }
                catch (Throwable th) {
                    try {
                        expStatus = this.postprocessException(th);
                        if (expStatus == null || DBCollectorPrePostProcessStatus.THROW.equals((Object)expStatus)) {
                            throw th;
                        }
                        if (expStatus != null && !DBCollectorPrePostProcessStatus.END.equals((Object)expStatus)) continue;
                        break;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.postprocessComplete();
                    }
                }
            } while (expStatus != null && DBCollectorPrePostProcessStatus.RETRY.equals((Object)expStatus));
        }
        catch (Throwable e) {
            if (!this.isFinish()) {
                try {
                    this.addQueue(new DataValueObject(e));
                }
                catch (InterruptedException ie) {
                    LOGGER.warn("WAL041003", e);
                    LOGGER.warn("WAL041003", (Throwable)ie);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("DAL041002", new Object[]{e.getClass().getName(), Thread.currentThread().getName()});
                }
            }
            Integer n = -1;
            return n;
        }
        finally {
            this.setFinish();
        }
        return 0;
    }

    protected void preprocess() {
        if (this.dbCollectorPrePostProcess != null) {
            this.dbCollectorPrePostProcess.preprocess(this);
        }
    }

    protected DBCollectorPrePostProcessStatus postprocessException(Throwable th) {
        DBCollectorPrePostProcessStatus expStatus = null;
        if (this.dbCollectorPrePostProcess != null) {
            expStatus = this.dbCollectorPrePostProcess.postprocessException(this, th);
        }
        return expStatus;
    }

    protected void postprocessComplete() {
        if (this.dbCollectorPrePostProcess != null) {
            this.dbCollectorPrePostProcess.postprocessComplete(this);
        }
    }

    protected QueueingDataRowHandler getDataRowHandler() {
        QueueingDataRowHandler dataRowHandler = null;
        try {
            dataRowHandler = this.queueingDataRowHandlerClass.newInstance();
        }
        catch (InstantiationException e) {
            SystemException exception = new SystemException((Throwable)e);
            exception.setMessage("Generation of an instance goes wrong.");
            throw exception;
        }
        catch (IllegalAccessException e) {
            SystemException exception = new SystemException((Throwable)e);
            exception.setMessage("Generation of an instance goes wrong.");
            throw exception;
        }
        return dataRowHandler;
    }

    protected Object clone() throws CloneNotSupportedException {
        Object obj = super.clone();
        if (obj instanceof DBCollector) {
            DBCollector qac = (DBCollector)obj;
            qac.rowHandler = this.getDataRowHandler();
            qac.rowHandler.setDbCollector(this);
        }
        return obj;
    }

    @Override
    protected void addQueue(DataValueObject dataValueObject) throws InterruptedException {
        super.addQueue(dataValueObject);
    }
}

