/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.util;

import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import jp.terasoluna.fw.dao.IllegalClassTypeException;
import jp.terasoluna.fw.logger.TLogger;
import jp.terasoluna.fw.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchUtil {
    private static final TLogger LOGGER = TLogger.getLogger(BatchUtil.class);

    protected BatchUtil() {
    }

    public static String cat(Object ... args) {
        StringBuilder str = new StringBuilder();
        if (args == null) {
            return null;
        }
        for (Object o : args) {
            if (o == null) continue;
            str.append(o);
        }
        return str.toString();
    }

    public static String getInfoLogStartMsg(String jobCd) {
        return BatchUtil.cat("[", jobCd, "] ", "\u51e6\u7406\u958b\u59cb");
    }

    public static String getInfoLogEndMsg(String jobCd) {
        return BatchUtil.cat("[", jobCd, "] ", "\u51e6\u7406\u7d42\u4e86");
    }

    public static TransactionDefinition getTransactionDefinition() {
        return new DefaultTransactionDefinition();
    }

    public static TransactionDefinition getTransactionDefinition(int propagationBehavior, int isolationLevel, int timeout, boolean readOnly) {
        DefaultTransactionDefinition td = new DefaultTransactionDefinition();
        td.setPropagationBehavior(propagationBehavior);
        td.setIsolationLevel(isolationLevel);
        td.setTimeout(timeout);
        td.setReadOnly(readOnly);
        return td;
    }

    public static TransactionStatus startTransaction(PlatformTransactionManager tran) {
        return BatchUtil.startTransaction(tran, BatchUtil.getTransactionDefinition(), null);
    }

    public static TransactionStatus startTransaction(PlatformTransactionManager tran, Log log) {
        return BatchUtil.startTransaction(tran, BatchUtil.getTransactionDefinition(), log);
    }

    public static TransactionStatus startTransaction(PlatformTransactionManager tran, int propagationBehavior, int isolationLevel, int timeout, boolean readOnly) {
        return BatchUtil.startTransaction(tran, BatchUtil.getTransactionDefinition(propagationBehavior, isolationLevel, timeout, readOnly), null);
    }

    public static TransactionStatus startTransaction(PlatformTransactionManager tran, int propagationBehavior, int isolationLevel, int timeout, boolean readOnly, Log log) {
        return BatchUtil.startTransaction(tran, BatchUtil.getTransactionDefinition(propagationBehavior, isolationLevel, timeout, readOnly), log);
    }

    public static TransactionStatus startTransaction(PlatformTransactionManager tran, TransactionDefinition def) {
        return BatchUtil.startTransaction(tran, def, null);
    }

    public static TransactionStatus startTransaction(PlatformTransactionManager tran, TransactionDefinition def, Log log) {
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                TLogger logger = (TLogger)log;
                logger.debug("DAL025033", new Object[]{tran});
                if (def != null) {
                    logger.debug("DAL025034", new Object[]{def.getPropagationBehavior(), def.getIsolationLevel(), def.getTimeout(), def.isReadOnly(), def.getName()});
                }
            } else {
                String msg033 = LOGGER.getLogMessage("DAL025033", new Object[]{tran});
                log.debug((Object)msg033);
                if (def != null) {
                    String msg034 = LOGGER.getLogMessage("DAL025034", new Object[]{def.getPropagationBehavior(), def.getIsolationLevel(), def.getTimeout(), def.isReadOnly(), def.getName()});
                    log.debug((Object)msg034);
                }
            }
        }
        TransactionStatus stat = null;
        if (tran != null) {
            stat = tran.getTransaction(def);
        }
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                TLogger logger = (TLogger)log;
                logger.debug("DAL025035", new Object[]{stat});
            } else {
                String msg035 = LOGGER.getLogMessage("DAL025035", new Object[]{stat});
                log.debug((Object)msg035);
            }
        }
        return stat;
    }

    public static Map<String, TransactionStatus> startTransactions(TransactionDefinition tranDef, Map<?, ?> tranMap) {
        return BatchUtil.startTransactions(tranDef, tranMap, null);
    }

    public static Map<String, TransactionStatus> startTransactions(TransactionDefinition tranDef, Map<?, ?> tranMap, Log log) {
        LinkedHashMap<String, TransactionStatus> statMap = new LinkedHashMap<String, TransactionStatus>();
        Set<Map.Entry<?, ?>> entrySet = tranMap.entrySet();
        if (entrySet != null) {
            for (Map.Entry<?, ?> entObj : entrySet) {
                Map.Entry<?, ?> ent;
                String key = null;
                PlatformTransactionManager ptm = null;
                if (entObj instanceof Map.Entry && (ent = entObj) != null) {
                    if (ent.getKey() instanceof String) {
                        key = (String)ent.getKey();
                    }
                    if (ent.getValue() instanceof PlatformTransactionManager) {
                        ptm = (PlatformTransactionManager)ent.getValue();
                    }
                }
                if (ptm == null) continue;
                if (log != null && log.isDebugEnabled()) {
                    if (log instanceof TLogger) {
                        TLogger logger = (TLogger)log;
                        logger.debug("DAL025033", new Object[]{key});
                        if (tranDef != null) {
                            logger.debug("DAL025034", new Object[]{tranDef.getPropagationBehavior(), tranDef.getIsolationLevel(), tranDef.getTimeout(), tranDef.isReadOnly(), tranDef.getName()});
                        }
                    } else {
                        String msg033 = LOGGER.getLogMessage("DAL025033", new Object[]{key});
                        log.debug((Object)msg033);
                        if (tranDef != null) {
                            String msg034 = LOGGER.getLogMessage("DAL025034", new Object[]{tranDef.getPropagationBehavior(), tranDef.getIsolationLevel(), tranDef.getTimeout(), tranDef.isReadOnly(), tranDef.getName()});
                            log.debug((Object)msg034);
                        }
                    }
                }
                TransactionStatus trnStat = null;
                try {
                    trnStat = ptm.getTransaction(tranDef);
                }
                catch (TransactionException e) {
                    if (log != null && log.isErrorEnabled()) {
                        if (log instanceof TLogger) {
                            TLogger logger = (TLogger)log;
                            logger.error("EAL025048", (Throwable)e, new Object[]{key});
                        } else {
                            String message = LOGGER.getLogMessage("EAL025048", new Object[]{key});
                            log.error((Object)message, (Throwable)e);
                        }
                    }
                    BatchUtil.endTransactions(tranMap, statMap, log);
                    throw e;
                }
                if (statMap != null) {
                    statMap.put(key, trnStat);
                }
                if (log == null || !log.isDebugEnabled()) continue;
                if (log instanceof TLogger) {
                    TLogger logger = (TLogger)log;
                    logger.debug("DAL025036", new Object[]{key, trnStat});
                    continue;
                }
                String msg036 = LOGGER.getLogMessage("DAL025036", new Object[]{key, trnStat});
                log.debug((Object)msg036);
            }
        }
        return statMap;
    }

    public static void commitTransaction(PlatformTransactionManager tran, TransactionStatus stat) {
        BatchUtil.commitTransaction(tran, stat, null);
    }

    public static void commitTransaction(PlatformTransactionManager tran, TransactionStatus stat, Log log) {
        TLogger logger;
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                logger = (TLogger)log;
                logger.debug("DAL025037", new Object[]{stat});
            } else {
                String msg037 = LOGGER.getLogMessage("DAL025037", new Object[]{stat});
                log.debug((Object)msg037);
            }
        }
        if (tran != null && stat != null) {
            tran.commit(stat);
        }
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                logger = (TLogger)log;
                logger.debug("DAL025038", new Object[]{stat});
            } else {
                String msg038 = LOGGER.getLogMessage("DAL025038", new Object[]{stat});
                log.debug((Object)msg038);
            }
        }
    }

    public static void commitTransactions(Map<?, ?> tranMap, Map<String, TransactionStatus> statMap) {
        BatchUtil.commitTransactions(tranMap, statMap, null);
    }

    public static void commitTransactions(Map<?, ?> tranMap, Map<String, TransactionStatus> statMap, Log log) {
        Set<Map.Entry<String, TransactionStatus>> statSet = statMap.entrySet();
        if (statSet == null || statSet.isEmpty()) {
            return;
        }
        Stack<Map.Entry<String, TransactionStatus>> stack = new Stack<Map.Entry<String, TransactionStatus>>();
        for (Map.Entry<String, TransactionStatus> stat : statSet) {
            stack.push(stat);
        }
        while (!stack.isEmpty()) {
            Object ptmObj;
            Map.Entry statEntry = (Map.Entry)stack.pop();
            String key = (String)statEntry.getKey();
            TransactionStatus trnStat = (TransactionStatus)statEntry.getValue();
            if (trnStat == null || (ptmObj = tranMap.get(key)) == null || !(ptmObj instanceof PlatformTransactionManager)) continue;
            PlatformTransactionManager ptm = (PlatformTransactionManager)ptmObj;
            if (log != null && log.isDebugEnabled()) {
                if (log instanceof TLogger) {
                    TLogger logger = (TLogger)log;
                    logger.debug("DAL025039", new Object[]{key, trnStat});
                    logger.debug("DAL025038", new Object[]{trnStat});
                } else {
                    String msg039 = LOGGER.getLogMessage("DAL025039", new Object[]{key, trnStat});
                    log.debug((Object)msg039);
                    String msg038 = LOGGER.getLogMessage("DAL025038", new Object[]{trnStat});
                    log.debug((Object)msg038);
                }
            }
            ptm.commit(trnStat);
        }
    }

    public static void endTransaction(PlatformTransactionManager tran, TransactionStatus stat) {
        BatchUtil.endTransaction(tran, stat, null);
    }

    public static void endTransaction(PlatformTransactionManager tran, TransactionStatus stat, Log log) {
        String message;
        TLogger logger;
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                logger = (TLogger)log;
                logger.debug("DAL025040", new Object[]{stat});
            } else {
                message = LOGGER.getLogMessage("DAL025040", new Object[]{stat});
                log.debug((Object)message);
            }
        }
        if (tran != null && stat != null && !stat.isCompleted()) {
            tran.rollback(stat);
        }
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                logger = (TLogger)log;
                logger.debug("DAL025041", new Object[]{stat});
            } else {
                message = LOGGER.getLogMessage("DAL025041", new Object[]{stat});
                log.debug((Object)message);
            }
        }
    }

    public static boolean endTransactions(Map<?, ?> tranMap, Map<String, TransactionStatus> statMap) {
        return BatchUtil.endTransactions(tranMap, statMap, null);
    }

    public static boolean endTransactions(Map<?, ?> tranMap, Map<String, TransactionStatus> statMap, Log log) {
        boolean isNormal = true;
        Set<Map.Entry<String, TransactionStatus>> statSet = statMap.entrySet();
        if (statSet == null || statSet.isEmpty()) {
            return isNormal;
        }
        Stack<Map.Entry<String, TransactionStatus>> stack = new Stack<Map.Entry<String, TransactionStatus>>();
        for (Map.Entry<String, TransactionStatus> stat : statSet) {
            stack.push(stat);
        }
        while (!stack.isEmpty()) {
            TLogger logger;
            Object ptmObj;
            Map.Entry statEntry = (Map.Entry)stack.pop();
            String key = (String)statEntry.getKey();
            TransactionStatus trnStat = (TransactionStatus)statEntry.getValue();
            if (trnStat == null || (ptmObj = tranMap.get(key)) == null || !(ptmObj instanceof PlatformTransactionManager)) continue;
            PlatformTransactionManager ptm = (PlatformTransactionManager)ptmObj;
            if (trnStat.isCompleted()) continue;
            if (log != null && log.isDebugEnabled()) {
                if (log instanceof TLogger) {
                    logger = (TLogger)log;
                    logger.debug("DAL025042", new Object[]{key, trnStat});
                    logger.debug("DAL025045", new Object[]{trnStat});
                } else {
                    String message42 = LOGGER.getLogMessage("DAL025042", new Object[]{key, trnStat});
                    log.debug((Object)message42);
                    String message45 = LOGGER.getLogMessage("DAL025045", new Object[]{trnStat});
                    log.debug((Object)message45);
                }
            }
            try {
                ptm.rollback(trnStat);
            }
            catch (TransactionException e) {
                if (log != null && log.isErrorEnabled()) {
                    if (log instanceof TLogger) {
                        TLogger logger2 = (TLogger)log;
                        logger2.error("EAL025045", (Throwable)e, new Object[]{key});
                    } else {
                        String message = LOGGER.getLogMessage("DAL025045", new Object[]{key});
                        log.error((Object)message, (Throwable)e);
                    }
                }
                isNormal = false;
            }
            if (log == null || !log.isDebugEnabled()) continue;
            if (log instanceof TLogger) {
                logger = (TLogger)log;
                logger.debug("DAL025041", new Object[]{trnStat});
                continue;
            }
            String message = LOGGER.getLogMessage("DAL025041", new Object[]{trnStat});
            log.debug((Object)message);
        }
        return isNormal;
    }

    public static Object setSavepoint(TransactionStatus stat) {
        return BatchUtil.setSavepoint(stat, null);
    }

    public static Object setSavepoint(TransactionStatus stat, Log log) {
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                TLogger logger = (TLogger)log;
                logger.debug("DAL025046", new Object[]{stat});
            } else {
                String message = LOGGER.getLogMessage("DAL025046", new Object[]{stat});
                log.debug((Object)message);
            }
        }
        Object savepoint = stat.createSavepoint();
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                TLogger logger = (TLogger)log;
                logger.debug("DAL025047", new Object[]{stat});
            } else {
                String message = LOGGER.getLogMessage("DAL025047", new Object[]{stat});
                log.debug((Object)message);
            }
        }
        return savepoint;
    }

    public static void releaseSavepoint(TransactionStatus stat, Object savepoint) {
        BatchUtil.releaseSavepoint(stat, savepoint, null);
    }

    public static void releaseSavepoint(TransactionStatus stat, Object savepoint, Log log) {
        String message;
        TLogger logger;
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                logger = (TLogger)log;
                logger.debug("DAL025048", new Object[]{stat});
            } else {
                message = LOGGER.getLogMessage("DAL025048", new Object[]{stat});
                log.debug((Object)message);
            }
        }
        stat.releaseSavepoint(savepoint);
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                logger = (TLogger)log;
                logger.debug("DAL025049", new Object[]{savepoint});
            } else {
                message = LOGGER.getLogMessage("DAL025049", new Object[]{savepoint});
                log.debug((Object)message);
            }
        }
    }

    public static void rollbackSavepoint(TransactionStatus stat, Object savepoint) {
        BatchUtil.rollbackSavepoint(stat, savepoint, null);
    }

    public static void rollbackSavepoint(TransactionStatus stat, Object savepoint, Log log) {
        String message;
        TLogger logger;
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                logger = (TLogger)log;
                logger.debug("DAL025050", new Object[]{stat});
            } else {
                message = LOGGER.getLogMessage("DAL025050", new Object[]{stat});
                log.debug((Object)message);
            }
        }
        stat.rollbackToSavepoint(savepoint);
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                logger = (TLogger)log;
                logger.debug("DAL025051", new Object[]{stat});
            } else {
                message = LOGGER.getLogMessage("DAL025051", new Object[]{stat});
                log.debug((Object)message);
            }
        }
    }

    public static void rollbackTransaction(PlatformTransactionManager tran, TransactionStatus stat) {
        BatchUtil.rollbackTransaction(tran, stat, null);
    }

    public static void rollbackTransaction(PlatformTransactionManager tran, TransactionStatus stat, Log log) {
        String message;
        TLogger logger;
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                logger = (TLogger)log;
                logger.debug("DAL025052", new Object[]{stat});
            } else {
                message = LOGGER.getLogMessage("DAL025052", new Object[]{stat});
                log.debug((Object)message);
            }
        }
        if (tran != null && stat != null && !stat.isCompleted()) {
            tran.rollback(stat);
        }
        if (log != null && log.isDebugEnabled()) {
            if (log instanceof TLogger) {
                logger = (TLogger)log;
                logger.debug("DAL025053", new Object[]{stat});
            } else {
                message = LOGGER.getLogMessage("DAL025053", new Object[]{stat});
                log.debug((Object)message);
            }
        }
    }

    public static TransactionStatus commitRestartTransaction(PlatformTransactionManager tran, TransactionStatus stat) {
        BatchUtil.commitTransaction(tran, stat, null);
        BatchUtil.endTransaction(tran, stat, null);
        return BatchUtil.startTransaction(tran);
    }

    public static TransactionStatus commitRestartTransaction(PlatformTransactionManager tran, TransactionStatus stat, Log log) {
        BatchUtil.commitTransaction(tran, stat, log);
        BatchUtil.endTransaction(tran, stat, log);
        return BatchUtil.startTransaction(tran, log);
    }

    public static TransactionStatus commitRestartTransaction(PlatformTransactionManager tran, TransactionStatus stat, TransactionDefinition def) {
        BatchUtil.commitTransaction(tran, stat, null);
        BatchUtil.endTransaction(tran, stat, null);
        return BatchUtil.startTransaction(tran, def);
    }

    public static TransactionStatus commitRestartTransaction(PlatformTransactionManager tran, TransactionStatus stat, TransactionDefinition def, Log log) {
        BatchUtil.commitTransaction(tran, stat, log);
        BatchUtil.endTransaction(tran, stat, log);
        return BatchUtil.startTransaction(tran, def, log);
    }

    public static TransactionStatus rollbackRestartTransaction(PlatformTransactionManager tran, TransactionStatus stat) {
        BatchUtil.rollbackTransaction(tran, stat, null);
        BatchUtil.endTransaction(tran, stat, null);
        return BatchUtil.startTransaction(tran);
    }

    public static TransactionStatus rollbackRestartTransaction(PlatformTransactionManager tran, TransactionStatus stat, Log log) {
        BatchUtil.rollbackTransaction(tran, stat, log);
        BatchUtil.endTransaction(tran, stat, log);
        return BatchUtil.startTransaction(tran, log);
    }

    public static TransactionStatus rollbackRestartTransaction(PlatformTransactionManager tran, TransactionStatus stat, TransactionDefinition def) {
        BatchUtil.rollbackTransaction(tran, stat, null);
        BatchUtil.endTransaction(tran, stat, null);
        return BatchUtil.startTransaction(tran, def);
    }

    public static TransactionStatus rollbackRestartTransaction(PlatformTransactionManager tran, TransactionStatus stat, TransactionDefinition def, Log log) {
        BatchUtil.rollbackTransaction(tran, stat, log);
        BatchUtil.endTransaction(tran, stat, log);
        return BatchUtil.startTransaction(tran, def, log);
    }

    public static <E> E[] changeListToArray(List<E> list, Class clazz) {
        if (clazz == null) {
            throw new IllegalClassTypeException();
        }
        List<E> castedList = list;
        Object[] retArray = (Object[])Array.newInstance(clazz, castedList.size());
        try {
            castedList.toArray(retArray);
        }
        catch (ArrayStoreException e) {
            throw new IllegalClassTypeException((Throwable)e);
        }
        return retArray;
    }

    public static List<String> getProperties(String propertyName, String grpKey) {
        Properties properties = PropertyUtil.loadProperties((String)propertyName);
        Enumeration propNames = PropertyUtil.getPropertyNames((Properties)properties, (String)grpKey);
        ArrayList<String> propNamesList = Collections.list(propNames);
        Collections.sort(propNamesList);
        ArrayList<String> resultList = new ArrayList<String>();
        for (String key : propNamesList) {
            resultList.add(PropertyUtil.getProperty((String)key));
        }
        return resultList;
    }

    public static String getMemoryInfo() {
        DecimalFormat f1 = new DecimalFormat("#,###KB");
        DecimalFormat f2 = new DecimalFormat("##.#");
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory() / 1024L;
        long total = rt.totalMemory() / 1024L;
        long max = rt.maxMemory() / 1024L;
        long used = total - free;
        double ratio = (double)(used * 100L) / (double)total;
        StringBuilder sb = new StringBuilder();
        sb.append("Java memory info : ");
        sb.append("used=");
        sb.append(f1.format(used));
        sb.append(" (");
        sb.append(f2.format(ratio));
        sb.append("%), ");
        sb.append("total=");
        sb.append(f1.format(total));
        sb.append(", ");
        sb.append("max=");
        sb.append(f1.format(max));
        return sb.toString();
    }
}

