/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.executor;

import java.util.concurrent.ConcurrentHashMap;
import jp.terasoluna.fw.logger.TLogger;
import org.springframework.context.ApplicationContext;

public class ThreadGroupApplicationContextHolder {
    private static final TLogger LOGGER = TLogger.getLogger(ThreadGroupApplicationContextHolder.class);
    private static final ConcurrentHashMap<ThreadGroup, ApplicationContext> tga = new ConcurrentHashMap();

    protected ThreadGroupApplicationContextHolder() {
    }

    public static ApplicationContext getCurrentThreadGroupApplicationContext() {
        return ThreadGroupApplicationContextHolder.getThreadGroupApplicationContext(ThreadGroupApplicationContextHolder.getThreadGroup());
    }

    public static ApplicationContext getThreadGroupApplicationContext(ThreadGroup threadGroup) {
        ApplicationContext applicationContext = null;
        if (threadGroup != null) {
            applicationContext = tga.get(threadGroup);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("TAL025003", new Object[]{ThreadGroupApplicationContextHolder.getThreadMessage()});
            }
        }
        return applicationContext;
    }

    protected static void setApplicationContext(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("WAL025004", new Object[]{ThreadGroupApplicationContextHolder.getThreadMessage()});
            }
            return;
        }
        ThreadGroup tg = ThreadGroupApplicationContextHolder.getThreadGroup();
        if (tg != null) {
            tga.put(tg, applicationContext);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("TAL025004", new Object[]{ThreadGroupApplicationContextHolder.getThreadMessage()});
            }
        }
    }

    protected static void removeApplicationContext() {
        ThreadGroup tg = ThreadGroupApplicationContextHolder.getThreadGroup();
        if (tg != null) {
            tga.remove(tg);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("TAL025005", new Object[]{ThreadGroupApplicationContextHolder.getThreadMessage()});
            }
        }
    }

    private static ThreadGroup getThreadGroup() {
        Thread ct = Thread.currentThread();
        if (ct != null && ct.getThreadGroup() != null) {
            return ct.getThreadGroup();
        }
        return null;
    }

    private static String getThreadMessage() {
        StringBuilder sb = new StringBuilder();
        Thread ct = Thread.currentThread();
        if (ct != null && ThreadGroupApplicationContextHolder.getThreadGroup() != null) {
            sb.append(" tg:[");
            sb.append(ThreadGroupApplicationContextHolder.getThreadGroup().getName());
            sb.append("]");
        }
        if (ct != null) {
            sb.append(" t:[");
            sb.append(ct.getName());
            sb.append("]");
        }
        return sb.toString();
    }
}

