/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.util.RegExpEvaluator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;

public abstract class PatternValidator {
    private String _pattern = null;
    private boolean _nillable = false;
    private RegExpEvaluator _regex = null;

    public PatternValidator() {
    }

    public PatternValidator(String pattern) {
        this._pattern = pattern;
    }

    public String getPattern() {
        return this._pattern;
    }

    public boolean isNillable() {
        return this._nillable;
    }

    public boolean hasPattern() {
        return this._pattern != null;
    }

    public void setNillable(boolean nillable) {
        this._nillable = nillable;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
        if (this._regex != null) {
            this._regex.setExpression(this._pattern);
        }
    }

    public void validate(String str, ValidationContext context) throws ValidationException {
        if (this._pattern != null) {
            if (this._regex == null) {
                this.initEvaluator(context);
            }
            if (!this._regex.matches(str)) {
                String err = "objects of this type must match the  following regular expression: " + this._pattern;
                throw new ValidationException(err);
            }
        }
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            if (!this._nillable) {
                String err = "PatternValidator cannot validate a null object.";
                throw new ValidationException(err);
            }
            return;
        }
        this.validate(object.toString(), context);
    }

    private void initEvaluator(ValidationContext context) {
        this._regex = context.getConfiguration().getRegExpEvaluator();
        if (this._regex == null) {
            this._regex = new DefaultRegExpEvaluator();
        }
        this._regex.setExpression(this._pattern);
    }

    class DefaultRegExpEvaluator
    implements RegExpEvaluator {
        DefaultRegExpEvaluator() {
        }

        public void setExpression(String rexpr) {
        }

        public boolean matches(String value) {
            return false;
        }
    }
}

