/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.transaction.annotation.TransactionAnnotationParser;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class SpringTransactionAnnotationParser
implements TransactionAnnotationParser,
Serializable {
    public TransactionAttribute parseTransactionAnnotation(AnnotatedElement ae) {
        Transactional ann = (Transactional)AnnotationUtils.getAnnotation((AnnotatedElement)ae, Transactional.class);
        if (ann != null) {
            return this.parseTransactionAnnotation(ann);
        }
        return null;
    }

    public TransactionAttribute parseTransactionAnnotation(Transactional ann) {
        String[] nrbfc;
        Class<? extends Throwable>[] nrbf;
        String[] rbfc;
        Class<? extends Throwable>[] rbf;
        RuleBasedTransactionAttribute rbta = new RuleBasedTransactionAttribute();
        rbta.setPropagationBehavior(ann.propagation().value());
        rbta.setIsolationLevel(ann.isolation().value());
        rbta.setTimeout(ann.timeout());
        rbta.setReadOnly(ann.readOnly());
        rbta.setQualifier(ann.value());
        ArrayList<RollbackRuleAttribute> rollBackRules = new ArrayList<RollbackRuleAttribute>();
        for (Class<? extends Throwable> rbRule : rbf = ann.rollbackFor()) {
            RollbackRuleAttribute rule = new RollbackRuleAttribute(rbRule);
            rollBackRules.add(rule);
        }
        for (String rbRule : rbfc = ann.rollbackForClassName()) {
            RollbackRuleAttribute rule = new RollbackRuleAttribute(rbRule);
            rollBackRules.add(rule);
        }
        for (Class<? extends Throwable> rbRule : nrbf = ann.noRollbackFor()) {
            NoRollbackRuleAttribute rule = new NoRollbackRuleAttribute((Class)rbRule);
            rollBackRules.add(rule);
        }
        for (String rbRule : nrbfc = ann.noRollbackForClassName()) {
            NoRollbackRuleAttribute rule = new NoRollbackRuleAttribute(rbRule);
            rollBackRules.add(rule);
        }
        rbta.getRollbackRules().addAll(rollBackRules);
        return rbta;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof SpringTransactionAnnotationParser;
    }

    public int hashCode() {
        return SpringTransactionAnnotationParser.class.hashCode();
    }
}

