/*/////////////////////////////////////////////////////////////////////////////
// confman ϥ饤֥
// confman.cc confman󥿥եؿμ
*/

/* إåե */
#include "confman.h"
#include "ConfImp.h"
#include <limits.h>
#include <string>
#include <wchar.h>
#include <widec.h>
using namespace std;

/* ޥ */
#define IMP( p ) ( (CConfImp*)( p->pConf ) )
#define SMB( p ) ( (map<wstring,ULONG>*)( p->smb ) )

/* CONFMAN */
CONFMAN confman_CreateConf( const char *FileName )
{
	CONFMAN p;

	/* ¤Τΰ */
	p = (CONFMAN)malloc( sizeof( tagConf ) );
	if ( p == NULL ) return NULL;

	/* 饹 */
	p->pConf = (void*)new CConfImp();
	if ( p->pConf == NULL ){
		free( p );		/* 饹ιۤ˼Ԥ */
		return NULL;	/* ΰNULL֤ */
	}

	/* ե̾Ͽ */
	IMP(p)->ConfImp_SetFileName( FileName );

	p->smb = NULL;	/* ȤʤNULLǼ */
	return p;
}

/* ɤ߹߻ؼ */
CF_BOOL confman_Open( CONFMAN p )
{
	return IMP(p)->ConfImp_Open();
}


/*  */

CF_BOOL confman_GetString(	CONFMAN p,
				const wchar_t *SectionName,
				const wchar_t *KeyName,
				wchar_t *buf,
				int length )
{
	return IMP( p )->ConfImp_GetString( SectionName, KeyName, buf, length );
}

/*  */

CF_BOOL confman_SetString(	CONFMAN p,
				const wchar_t *SectionName,
				const wchar_t *KeyName,
				const wchar_t *value )
{
	return IMP( p )->ConfImp_SetString( SectionName, KeyName, value );
}

/* եĤ */
CF_BOOL confman_Close( CONFMAN p )
{
	CF_BOOL r;

	/* ե¸ */
	r = IMP( p )->ConfImp_Close( );

	/* ֥Ȥ */
	delete IMP(p);

	/* ܥ뤬ѤƤϥ֥Ȥ */
	if ( SMB(p) != NULL )
		delete SMB(p);

	/* tagConfΥΰ */
	free( p );
	return r;
}

// ե饰
CF_BOOL confman_GetModify( CONFMAN p )
{
	return IMP( p )->ConfImp_GetModifyFlag();
}

// ե饰ѹ
void confman_SetModify( CONFMAN p, CF_BOOL b )
{
	IMP( p )->ConfImp_SetModifyFlag( b );
}

// ̾ꥹȤ
CF_BOOL confman_GetSectionList( CONFMAN p, wchar_t *buf, int Length )
{
	wstring w;
	CF_BOOL r;

	r = IMP( p )->ConfImp_GetSectionList( w, Length );
	memcpy( buf, w.c_str(), w.size() * sizeof( wchar_t ) );
	buf[Length-1] = L'\0';	// ǡʤɬǸˤNULLĤ
	return r;
}

/* ̾ΥꥹȤ */
CF_BOOL confman_GetKeyList( CONFMAN p, const wchar_t *SectionName, wchar_t *buf, int Length )
{
	wstring w;
	CF_BOOL r;

	r = IMP( p )->ConfImp_GetKeyList( SectionName, w, Length );
	memcpy( buf, w.c_str(), w.size() * sizeof( wchar_t ) );
	buf[Length-1] = L'\0';	// ǡʤɬǸˤNULLĤ
	return r;
}


/* ɲ */
CF_BOOL confman_AddSection( CONFMAN p, const wchar_t *SectionName )
{
	return IMP( p )->ConfImp_AddSection( SectionName );
}

/* ɲ */
CF_BOOL confman_AddKey( CONFMAN p, const wchar_t *SectionName, const wchar_t *KeyName, const wchar_t *Value )
{
	return IMP( p )->ConfImp_AddKey( SectionName, KeyName, Value );
}

/*  */
CF_BOOL confman_RemoveSection( CONFMAN p, const wchar_t *SectionName )
{
	return IMP( p )->ConfImp_RemoveSection( SectionName );
}


/* κ */
CF_BOOL confman_RemoveKey( CONFMAN p, const wchar_t *SectionName, const wchar_t *KeyName )
{
	return IMP( p )->ConfImp_RemoveKey( SectionName, KeyName );
}


/* 顼ͤμ */
unsigned long confman_GetLastError( CONFMAN p )
{
	return IMP( p )->ConfImp_GetLastError();
}

/* 顼ͤΥꥢ */
void confman_ClearLastError( CONFMAN p )
{
	IMP( p )->ConfImp_ClearLastError();
}

/* ĥǽ */
/* ܥɲ */
CF_BOOL exconf_AddSymbol( CONFMAN p, const wchar_t *symbol, ULONG val )
{
	/* ޤȤƤʤΰ */
	if ( p->smb == NULL ){
		p->smb = (void*)new map<wstring, ULONG>;
		/* ΰݤ˼Ԥ鵶֤ */
		if ( p->smb == NULL )
			return CF_FALSE;
	}

	/* ܥͤϿ */
	SMB(p)->insert( pair<wstring, ULONG>( (wstring)symbol, val ) );
	return CF_TRUE;
}

/* бʸ󤫤饷ܥͤ */
ULONG exconf_GetSymbol( CONFMAN p, const wchar_t *SectionName, const wchar_t *KeyName )
{
	wstring w;

	if ( SMB(p) == NULL ){
		// ܥ뵡ǽ̤
		IMP(p)->ConfImp_SetError(ECF_UNUSESYMBOL);
		return ULONG_MAX;
	}

	/* 򸡺 */
	if ( IMP(p)->ConfImp_GetSTLString( SectionName, KeyName, w ) == CF_FALSE )
		return ULONG_MAX;	/* Ĥʤ */

	/* б륷ܥ֤ͤ */
	return exconf_StrToVal( p, w.c_str() );
}

/* ܥǡ */
void exconf_ReleaseSymbol( CONFMAN p )
{
	if ( SMB(p) != NULL ){
		delete SMB(p);
		p->smb = NULL;
	}
}

/* ʸ󤫤饷ܥͤ */
ULONG exconf_StrToVal( CONFMAN p, const wchar_t *Symbol )
{
	map<wstring,ULONG>::iterator i;

	/* ܥ򸡺 */
	i = SMB(p)->find( (wstring)Symbol );
	if ( i == SMB(p)->end() ){
		// ܥ̾Ĥʤ
		IMP(p)->ConfImp_SetError(ECF_NOSYMBOL);
		return ULONG_MAX;
	}
	return i->second;
}

/* ͤǼ */
CF_BOOL exconf_GetInt( CONFMAN p, const wchar_t *SectionName, const wchar_t *KeyName, int *c )
{
	wstring w;
	if ( !IMP(p)->ConfImp_GetSTLString( SectionName, KeyName, w ) )
		return CF_FALSE;
	(*c) = watoi( w.c_str() );
	return CF_TRUE;
}

/* ̾ꥹȤ */
void* exconf_CreateInternalSectionList( CONFMAN p, int *Length )
{
	wstring *s;
	s = new wstring;
	if ( s == NULL ) return NULL;	// stringιۤ˼
	if ( !IMP( p )->ConfImp_GetSectionList( *s, -1 ) ){	// ꥹȤ
		delete s;		// 
		return NULL;
	}

	(*Length) = s->size();	// Ǽ
	return (void*)s;		// ɥ쥹֤
}

/* ̾ꥹȤ */
void* exconf_CreateInternalKeyList( CONFMAN p, const wchar_t *SectionName, int *Length )
{
	wstring *s;
	s = new wstring;
	if ( s == NULL ) return NULL;	// stringιۤ˼
	if ( !IMP( p )->ConfImp_GetKeyList( SectionName, *s, -1 ) ){	// ꥹȤ
		delete s;		// 
		return NULL;
	}

	(*Length) = s->size();	// Ǽ
	return (void*)s;		// ɥ쥹֤
}

/* ꥹȤ */
void exconf_GetInternalList( void *h, wchar_t *buf, int Length )
{
	wstring *p = ((wstring*)h);			// 㥹Ȥ
	int l = Length < p->size() ? Length : p->size();	// ۤ

	memcpy( buf, p->c_str(), l * sizeof( wchar_t ) );	// Хåե˳Ǽ
	buf[l-1] = L'\0';					// Ǹ夬NULLĤˤʤ뤳Ȥݾ
	buf[l-2] = L'\0';
	delete p;							// stringϤǳ
}

/* ݻƤͤΥɥ쥹 */
const wchar_t* exconf_GetConstStr( CONFMAN p, const wchar_t *SectionName, const wchar_t *KeyName )
{
	return IMP( p )->ConfImp_GetConstStr( SectionName, KeyName );
}

