////////////////////////////////////////////////////////////////////////////
// CFileReader 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "FileReader.h"
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CFileReader::CFileReader() :
	pData( NULL ),
	EnableExitFlg( false ),
	IsModifiedFlg( false ),
	InterruptFlg( false ),
	ErrorInfo(),
	CProcesingObj()
{

}

CFileReader::~CFileReader()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
void CFileReader::SetInfo( const string &argFileName, T_LineData *argData )
{
	FileName = argFileName;
	pData = argData;
	EnableExitFlg = false;
	IsModifiedFlg = false;
	InterruptFlg = false;
}

// ɤ߹ѥåɤΥȥݥ
void CFileReader::run()
{
	wchar_t wc[ TA_MAX_LINE_SIZE + 1 ];
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	bool NewLineFlg; // Ǹɤ߹Ԥ˲ԥɤޤޤƤݤݻ

	EnableExitFlg = false;
	IsModifiedFlg = false;
	InterruptFlg = false;
	ErrorInfo = true;

	// եΥץ
	FILE *infile = fopen( FileName.c_str(), "r" );
	if ( NULL == infile ) {
		ErrorInfo = CErrorBool( pConf->RefFaultFileOpenMsg() );
		EnableExitFlg = true;
		return ;
	}

	pData->clear();	// ǡ򥯥ꥢ
	IsModifiedFlg = true;
	NewLineFlg = false;
	while ( !feof( infile ) && !ferror( infile ) && !InterruptFlg ) {

		// ɤ߹
		if ( !fgetws( wc, TA_MAX_LINE_SIZE + 1, infile ) ) break;

		size_t wc_len = wslen( wc );	// ʸĹ

		// ɤ߹Ԥ˲ԥɤĤƤ뤫ݤ
		if ( L'\n' == wc[ wc_len - 1 ] ) {
			wc[ wc_len - 1 ] = L'\0';	// ԥɤĤƤ
			NewLineFlg = true;		// ե饰ꤹ
			wc_len--;
		}
		else
			NewLineFlg = false;

		// ԤĹγǧ
		if ( wc_len >= TA_MAX_LINE_SIZE ) {
			ErrorInfo = CErrorBool( pConf->RefBrokenLineMsg() );
			break;
		}

		// ꥹȤ˹Ԥɲ
		pData->push_back( wc );
	}
	if ( ferror( infile ) )
		ErrorInfo = CErrorBool( pConf->RefIOErrorMsg( errno ) );

	fclose( infile );

	// Ǹɤ߹Ԥ˲ԥɤޤޤƤ硢
	// ⤷ϰԤɤ߹Ǥʤˤ
	// ιԤդäɬפ
	if ( NewLineFlg || pData->size() == 0 ) pData->push_back( L"" );

	EnableExitFlg = true;
}

// λǽݤ
bool CFileReader::EnableExit() const
{
	return EnableExitFlg;
}

// 
void CFileReader::Interrupt()
{
	InterruptFlg = true;
}

// 顼
CErrorBool CFileReader::GetErrorInfo() const
{
	return ErrorInfo;
}

// ѹݤ
bool CFileReader::IsModified() const
{
	return IsModifiedFlg;
}

