////////////////////////////////////////////////////////////////////////////
// CConsruction 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "CommandID.h"
#include "Consruction.h"
#include "TaEditShell.h"
#include "ConfigInfo.h"
#include "TaEdit_glo.h"
#include "NegCmd.h"
#include "VPtr.h"
#include "lang/LangConfig.h"
#include "ProcStart.h"

#include <unistd.h>

using namespace std;
using namespace NNabikiVPtr;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CConsruction::CConsruction() :
	toSvrFD( -1 ),
	fromSvrFD( -1 ),
	EnableInputSource( false ),
	DetachConstruction( false )
{

}

CConsruction::~CConsruction()
{
	Clear();
}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
bool CConsruction::Initialize()
{
	int tsPipe[2] = { -1, -1 };	// ->ɮΥѥ
	int fsPipe[2] = { -1, -1 };	// ɮ->ФΥѥ
	pid_t pid;

	pid = getpid();
	if ( pid == (pid_t)-1 ) return false;

	// ѤΥѥפۤ
	if ( pipe( tsPipe ) ) goto ERR_EXIT;
	if ( pipe( fsPipe ) ) goto ERR_EXIT;

	// ե˥å
	toSvrFileName = AttachFile( pid, SCPX_FROM_SYUHITU, tsPipe[0] );
	fromSvrFName = AttachFile( pid, SCPX_TO_SYUHITU, fsPipe[1] );
	if ( toSvrFileName.empty() || fromSvrFName.empty() )
		goto ERR_EXIT;

	// door򳫤
	if ( !OpenDoor() ) goto ERR_EXIT;

	toSvrFD = tsPipe[1];
	fromSvrFD = fsPipe[0];

	// åμؿϿ
	InputID = XtAppAddInput( app_context, fromSvrFD, (XtPointer)XtInputReadMask, ReceiveMsg_entry, this );
	EnableInputSource = true;

	DetachConstruction = false;
	return true;
	
ERR_EXIT:
	if ( tsPipe[0] >= 0 ) close( tsPipe[0] );
	if ( tsPipe[1] >= 0 ) close( tsPipe[1] );
	if ( fsPipe[0] >= 0 ) close( fsPipe[0] );
	if ( fsPipe[1] >= 0 ) close( fsPipe[1] );
	Clear();
	return false;
}

// ˴
void CConsruction::Clear()
{
	// ѥפĤ
	if ( toSvrFD >= 0 ) close( toSvrFD );
	if ( fromSvrFD >= 0 ) close( fromSvrFD );
	toSvrFD = -1;
	fromSvrFD = -1;

	// ѥפ򥢥åե
	if ( !toSvrFileName.empty() ) {
		fdetach( toSvrFileName.c_str() );
		unlink( toSvrFileName.c_str() );
		toSvrFileName = "";
	}
	if ( !fromSvrFName.empty() ) {
		fdetach( fromSvrFName.c_str() );
		unlink( fromSvrFName.c_str() );
		fromSvrFName = "";
	}

	// doorĤ
	Door.Close();

	// XtϿϥϿ
	if ( EnableInputSource ) {
		XtRemoveInput( InputID );
		EnableInputSource = false;
	}
}

// ե򳫤Ȥ򥵡ФΤ
CErrorBool CConsruction::OpenFile( const string &FName, bool *pComplateFlg )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CNegCmd negcmd;
	int pid = getpid();

	assert( NULL != this && NULL != pComplateFlg );
	if ( pid < 0 ) return CErrorBool( pConf->RefFailToGetPID() );

	// å
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_OPENFILE_TS );
	negcmd.AddData( SCI_S_FILE_NAME, FName );
	negcmd.AddData( SCI_S_PID, pid );

	// å
	return SetEventToServer( negcmd, pComplateFlg );
}

// ե뤳Ȥ򥵡ФΤ
CErrorBool CConsruction::NewFile( bool *pComplateFlg )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CNegCmd negcmd;
	int pid = getpid();

	assert( NULL != this && NULL != pComplateFlg );
	if ( pid < 0 ) return CErrorBool( pConf->RefFailToGetPID() );

	// å
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_NEWFILE_TS );
	negcmd.AddData( SCI_S_PID, pid );

	// å
	return SetEventToServer( negcmd, pComplateFlg );
}

// ե̾դ¸򥵡ФΤ
CErrorBool CConsruction::WriteFile( const string &FName, bool *pComplateFlg )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CNegCmd negcmd;
	int pid = getpid();

	assert( NULL != this && NULL != pComplateFlg );
	if ( pid < 0 ) return CErrorBool( pConf->RefFailToGetPID() );

	// å
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_WRITEFILE_TS );
	negcmd.AddData( SCI_S_FILE_NAME, FName );
	negcmd.AddData( SCI_S_PID, pid );

	// å
	return SetEventToServer( negcmd, pComplateFlg );
}

// λ򥵡ФΤ
CErrorBool CConsruction::OnExit()
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CNegCmd negcmd;
	bool wCF;	// ߡ
	int pid = getpid();

	assert( NULL != this );
	if ( pid < 0 ) return CErrorBool( pConf->RefFailToGetPID() );

	// å
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_EXIT_TS );
	negcmd.AddData( SCI_S_PID, pid );

	// å
	return SetEventToServer( negcmd, &wCF );
}

// ɮưƥե򳫤
CErrorBool CConsruction::OpenFileWithNewWnd( const string &FName, int Line, bool *pComplateFlg )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CNegCmd negcmd;
	int pid = getpid();

	assert( NULL != this );
	if ( pid < 0 ) return CErrorBool( pConf->RefFailToGetPID() );

	// å
	// ޥɼ̤
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_OPENFILE_NW_TS );
	if ( !FName.empty() )
		negcmd.AddData( SCI_S_FILE_NAME, FName );
	if ( Line > 0 )
		negcmd.AddData( SCI_S_LINE_NUMBER, Line );
	negcmd.AddData( SCI_S_PID, pid );

	// å
	return SetEventToServer( negcmd, pComplateFlg );
}

// 󥹥ȥ饯󡦥⡼ɤؤλäΤ
CErrorBool CConsruction::NoticeJoin( const string &FName )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CNegCmd negcmd;
	bool wFLG;
	int pid = getpid();
	CErrorBool r;

	assert( NULL != this );
	if ( pid < 0 ) return CErrorBool( pConf->RefFailToGetPID() );

	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_JOIN_TS );
	negcmd.AddData( SCI_S_PID, pid );
	if ( !FName.empty() ) negcmd.AddData( SCI_S_FILE_NAME, FName );
	return SetEventToServer( negcmd, &wFLG );
}

// 󥹥ȥ饯󡦥⡼ɤæΤ
CErrorBool CConsruction::NoticeUnJoin()
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CNegCmd negcmd;
	bool wFLG;
	int pid = getpid();

	// ڤΥλؼǤƤΤ顢虜虜æΤ򤹤ɬפϤʤ
	if ( DetachConstruction ) return true;

	assert( NULL != this );
	if ( pid < 0 ) return CErrorBool( pConf->RefFailToGetPID() );

	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_UNJOIN_TS );
	negcmd.AddData( SCI_S_PID, pid );
	return SetEventToServer( negcmd, &wFLG );
}

// ե˥å
string CConsruction::AttachFile( int pid, const char *prefix, int fd ) const
{
	char buf[15];
	char *p;
	string fname;
	int wd;

	p = getenv( SCEV_COMMUNITY_PATH );
	if ( NULL == p ) return "";

	// åоݤΥե̾
	snprintf( buf, sizeof( buf ) * sizeof( char ), "%s%d", prefix, pid );
	fname = p;
	if ( fname[ fname.length() - 1 ] != '/' )
		fname += '/';
	fname += buf;

	// ե
	wd = open( fname.c_str(), O_RDWR | O_CREAT | O_EXCL, 0600 );
	if ( wd < 0 ) return "";
	close( wd );

	// ǰΤ
	fdetach( fname.c_str() );

	// å
	if ( !fattach( fd, fname.c_str() ) )
		return fname;	// 

	// Ԥե
	remove( fname.c_str() );
	return "";
}

// Ф˥٥ȤΤ
CErrorBool CConsruction::SetEventToServer( const CNegCmd &negcmd, bool *pComplateFlg )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	VPtr< char > pRet;
	bool SvrDownFlg = false;
	int len;
	int i;

	assert( NULL != this && NULL != pComplateFlg );
	if ( !Door.Enable() )
		return CErrorBool( pConf->RefConstructionCommunicationErrorMsg() );

	// å
	pRet = Door.Call( &negcmd, &SvrDownFlg );
	if ( !pRet.GetPtr() && SvrDownFlg ) {
		// ФƤ顢Фư
		if ( StartServer() ) {
			// 桼Ʊ⤦ٹԤ碌
			(*pComplateFlg) = true;
			return CErrorBool( pConf->RefRebootServerMsg() );
		}
		else {
			// 
			(*pComplateFlg) = false;
			return CErrorBool( pConf->RefFailedToRebootServerMsg() );
		}
	}

	// ͤ
	CNegCmd rmsg( pRet.GetPtr(), pRet.GetLen() );

	// ³Բݤ
	if ( rmsg.GetData( SCI_R_STOPPED, SCID_RSTOP_STOP ) == SCID_RSTOP_RESUME )
		(*pComplateFlg) = false;	// ³
	else
		(*pComplateFlg) = true;		// 

	// 귿Ūʥ顼åä顢˱åɽ
	switch( rmsg.GetData( SCI_R_MSG_NUMBER, SCID_RMSG_UNEXPENTED ) ) {
	case SCID_RMSG_OUTOFMEMORY:
		return CErrorBool( pConf->RefOutOfMemoryErrorMsg() );
	case SCID_RMSG_FILEISOPEND:
		return CErrorBool( pConf->RefFileIsOpenedByAnotherMsg() );
	case SCID_RMSG_SERVER_REVOKED:
		// Фߤ褦ȤƤϡɥ⡼ɤذܹԤ
		// ʻߤޤȤƤΤ˺ƵưƤʤ
		DetachConstruction = true;
		return CErrorBool( pConf->RefServerRevokedMsg() );
	}

	// 귿ʥåäϡǰΤɸ२顼Ϥɽ
	const string &FreeMsg = rmsg.GetData( SCI_R_FREE_MSG, "" );
	if ( !FreeMsg.empty() )
		fprintf( stderr, "Syuhitu : It failed to communication to server : \"%s\".", FreeMsg.c_str() );

	// ｪλǡġåʤп֤
	if ( rmsg.GetData( SCI_R_STATUS, SCID_RSTAT_ERR ) == SCID_RSTAT_OK )
		return true;

	// ¾Υ顼¸ߤ
	fprintf( stderr, "Syuhitu : It failed to communication to server with unknown error." );
	return CErrorBool( pConf->RefConstructionCommunicationErrorMsg() );
}

// door򳫤
bool CConsruction::OpenDoor()
{
	string DoorFileName;
	const char *p;

	// doorΥե̾
	p = getenv( SCEV_COMMUNITY_PATH );;
	if ( NULL == p ) return false;
	DoorFileName = p;
	if ( DoorFileName.length() == 0 ) return false;
	if ( DoorFileName[ DoorFileName.length() - 1 ] != '/' )
		DoorFileName += '/';
	DoorFileName += SCPX_DOOR;

	// door򳫤
	return Door.Open( DoorFileName.c_str() );
}

// doorФư
bool CConsruction::StartServer()
{
	int pid;
	int status;
	CProcStart procStart;
	const char *p = getenv( SCEV_CLIENT_PATH );
	if ( NULL == p ) return false;

	// 饤Ȥư륳ޥɤȰ
	procStart.SpecifyCommand( string( p ) );
	procStart.AddArg( string( "-b" ) );

	// 饤Ȥư
	pid = procStart.Start();
	if ( pid < 0 ) return false;

	// 饤Ȥνλơơ
	// еưݤǧ٤ǤϤ뤬
	// ȥǥåɥåƤޤ
	return true;
}

////////////////////////////////////////////////////////////////////////////
// ФΥå

// ФΥåΥȥݥ
void CConsruction::ReceiveMsg_entry( XtPointer ptr, int *source, XtInputId *id )
{
	CConsruction *p = reinterpret_cast< CConsruction* >( ptr );

	// å
	p->ReceiveMsg( (*source) );

	if ( p->GetDetachConstruction() ) {
		// ɥ󡦥⡼ɤذܹԤ
		m_TaEditShell->ProcErrorMsg( m_TaEditShell->SetStandaloneMode() );
	}
}

// ФΥåμ
void CConsruction::ReceiveMsg( int src )
{
	CNegCmd negret;	// 
	string RetStr;
	string fname;

	if ( toSvrFD < 0 ) {
		// Фط̤֤ʤ
		fprintf( stderr, "Syuhitu : Unexpected error." );
		return ;
	}

	// ޥɤ᤹
	CNegCmd negcmd( src );

	switch ( negcmd.GetData( SCI_S_COMMAND, SC_NOT_AVAILABLE ) ) {
	case SCID_CMD_ACTIVATE_ST:
		// ƥֲ
		if ( Activatewindow( negcmd ) )
			negret.AddData( SCI_R_STATUS, SCID_RSTAT_OK );
		else
			negret.AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		break;

	case SCID_CMD_RQ_FNAME_ST:
		// ե̾׵᤹
		fname = m_TaEditShell->GetDocument()->GetFileName();
		negret.AddData( SCI_S_FILE_NAME, fname.c_str() );
		break;

	case SCID_CMD_SVR_RESTART_ST:
		// ФƵư줿
		Door.Close();
		if ( OpenDoor() )
			negret.AddData( SCI_R_STATUS, SCID_RSTAT_OK );
		else
			negret.AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		break;

	case SCID_CMD_SET_STANDALONE_ST:
		// ɥ⡼ɤˤ
		negret.AddData( SCI_R_STATUS, SCID_RSTAT_OK );
		// ե饰ꤷڤΥ
		DetachConstruction = true;
		break;

	default:
		// ǧǤʤޥ
		negret.AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		negret.AddData( SCI_R_FREE_MSG, "Unknown command." );
	}

	// ֤
	RetStr = negret.GetSendData();
	write( toSvrFD, RetStr.c_str(), RetStr.length() );
}

// ɥ򥢥ƥֲ
bool CConsruction::Activatewindow( const CNegCmd &rCmd )
{
	int LineNumber;
	string Syntax;

	// ֹȹʸ̤
	LineNumber = rCmd.GetData( SCI_S_LINE_NUMBER, 0 );
	Syntax = rCmd.GetData( SCI_S_SYNTAX, "" );

	// ʸ̤ꤹ
	if ( !Syntax.empty() ) {
		enumLANGTYPE LangType = NLangExt::GetLangTypeID_ByLangName( Syntax.c_str() );
		switch ( LangType ) {
		case LANGTYPE_TEXT:
			m_TaEditShell->SetFileTypeTXT( NULL, NULL );
			break;
		case LANGTYPE_CPP:
			m_TaEditShell->SetFileTypeCPP( NULL, NULL );
			break;
		case LANGTYPE_JAVA:
			m_TaEditShell->SetFileTypeJAVA( NULL, NULL );
			break;
		case LANGTYPE_CBL:
			m_TaEditShell->SetFileTypeCBL( NULL, NULL );
			break;
		case LANGTYPE_JS:
			m_TaEditShell->SetFileTypeVBS( NULL, NULL );
			break;
		case LANGTYPE_VBS:
			m_TaEditShell->SetFileTypeJS( NULL, NULL );
			break;
		case LANGTYPE_CS:
			m_TaEditShell->SetFileTypeCS( NULL, NULL );
			break;
		}
	}

	// ɥ򥢥ƥ֤ˤ
	m_TaEditShell->RaiseWindow();

	// ΰ֤ꤹ
	if ( LineNumber > 0 )
		m_TaEditShell->MoveTo( LineNumber );

	return true;
}

// 󥹥ȥ饯⡼ɤڤΥݤ
bool CConsruction::GetDetachConstruction() const
{
	return DetachConstruction;
}


