////////////////////////////////////////////////////////////////////////////
// CFD 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string>

#include "FD.h"

using namespace std;
using namespace NNabikiVPtr;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CFD::CFD() :
	fd( -1 )
{

}

CFD::~CFD()
{
	Close();
}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
bool CFD::Open( const char *pFName, int flg, int mode )
{
	assert( NULL != pFName && NULL != this );

	// Ǥ˳Ƥ顢öĤ
	if ( fd >= 0 ) Close();

	// 
	fd = open( pFName, flg, mode );
	if ( fd < 0 ) return false;
	return true;
}

// 񤭹
bool CFD::Write( const void *pBuf, int len ) const
{
	if ( fd < 0 ) return false;

	return write( fd, pBuf, len ) == len;
}


// ֥åޤǥǡɤ߹
VPtr< char > CFD::Read() const
{
	VPtr< char > pRetBuf;
	string wStr;
	char Buf[512];
	const int BufLen = sizeof( Buf ) / sizeof( Buf[0] );
	int len;

	if ( fd < 0 )
		return VPtr< char >( NULL );

	if ( fcntl( fd, F_SETFL, O_NONBLOCK ) )
		return VPtr< char >( NULL );

	// ǡɤ߹
	wStr = "";
	len = read( fd, Buf, BufLen );
	while ( len > 0 ) {
		wStr += string( Buf, len );
		len = read( fd, Buf, BufLen );
	}

	// ѤΥХåե
	if ( !pRetBuf.Malloc( sizeof( char ) * wStr.length() ) )
		return VPtr< char >( NULL );
	memcpy( pRetBuf.GetPtr(), wStr.c_str(), wStr.length() );

	return pRetBuf;
}

// ɤ߹
int CFD::Read( void *pBuf, int len ) const
{
	if ( fd < 0 ) return -1;
	return read( fd, pBuf, len );
}

// Ĥ
void CFD::Close()
{
	assert( NULL != this );

	// ǤĤƤ顢äˤ뤳ȤϤʤ
	if ( fd < 0 ) return ;

	close( fd );
	fd = -1;
}

// ǥץμ
CFD::operator int() const
{
	return fd;
}

