////////////////////////////////////////////////////////////////////////////
// CServer 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <door.h>
#include <unistd.h>
#include <assert.h>
#include <alloca.h>

#include "Server.h"
#include "NegCmd.h"
#include "CommandID.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CServer::CServer( CSyInstance *pI ) :
	semaWait( 1 ),
	pInstanceMgr( pI ),
	semaAcsInstance( 1 ),
	IsRevoked( false )
{
	assert( pI );
}

CServer::~CServer()
{
	semaWait.V();
}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// doorȤƸ³
extern"C" void DoorEntry( void *cookie, char *argp, size_t arg_size, door_desc_t *dp, uint_t desc )
{
	CServer *p = reinterpret_cast< CServer* >( cookie );
	p->Door( argp, arg_size, dp, desc );
}

// doorФư
bool CServer::StartServer( const char *pFName, int fd )
{
	int dd;
	struct stat wStat;
	int w;

	assert( this && pFName );

	// door򥢥å뤿ΥեѰդ
	if ( lstat( pFName, &wStat ) < 0 ) {
		int newfd;
		// ե
		newfd = creat( pFName, 0600 );
		if ( newfd < 0 ) {
			fprintf( stderr, "ERROR Syuhitu server : It failed to create %s file.\n", pFName );
			return false;
		}
		close( newfd );
	}
	else {
		// Ǥdoor˴ϢŤƤơ
		// doorФͭǤСäˤ뤳ȤϤʤ
		if ( wStat.st_mode & S_IFDOOR && EnableDoorServer( pFName ) )
			return true;
	}

	// door
	dd = door_create( DoorEntry, this, 0 );
	if ( dd < 0 ) return false;

	fdetach( pFName );

	// ۤdoorΥե뵭һҤ򥢥å
	if ( fattach( dd, pFName ) < 0 ) {
		fprintf( stderr, "ERROR Syuhitu server : It failed to fattach %s file.\n", pFName );
		return false;
	}

	DoorFileName = pFName;
	IsRevoked = false;

	// Ǥ˵ưƤɮξ
	pInstanceMgr->UpdateExistTaEditInfo();

	// ưץˡФưȤΤƤ
	write( fd, "OK\n", 3 );

	// ФνλޤԤ碌
	semaWait.P();
	semaWait.P();	// ïV򤷤ƤޤԤ
	semaWait.V();
	IsRevoked = true;

	// doorФ˴
	if ( door_revoke( dd ) ) {
		fprintf( stderr, "ERROR Syuhitu server : It failed to revoke server.\n" );
	}
	fdetach( pFName );
	remove( pFName );

	return true;
}

// doorФξ֤ǧ
bool CServer::EnableDoorServer( const char *pFName )
{
	int d;
	bool r = false;
	struct door_info info;

	// doorȤܤե򳫤
	d = open( pFName, O_RDWR );
	if ( d < 0 ) return false;

	// doorξ
	if ( !door_info( d, &info ) ) {
		if ( !( info.di_attributes & DOOR_REVOKED ) )
			r = true;
	}

	close( d );

	return r;
}

// doorȤƸ³
void CServer::Door( char *argp, size_t arg_size, door_desc_t *dp, uint_t desc )
{
	CNegCmd ToClient;
	string ToClientStr;
	char *pRetBuf = NULL;
	int i;
	int RetryCnt = 2;

	// ޥɤ᤹
	CNegCmd negcmd( argp, arg_size );

	// ޥɤμ̤
	int CmdType = negcmd.GetData( SCI_S_COMMAND, SC_NOT_AVAILABLE );
	if ( CmdType == SC_NOT_AVAILABLE ) {
		ToClient.AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		ToClient.AddData( SCI_R_STOPPED, SCID_RSTOP_STOP );
		ToClient.AddData( SCI_R_FREE_MSG, "Unexpected error. Command is empty." );
		RetryCnt = 0;
	}

	while ( RetryCnt > 0 ) {

		// ɮΥ󥹥󥹤˥Ǥ褦ˤʤޤԤ碌
		semaAcsInstance.P();

		// Ԥ碌Ƥ֤ˡФߤ줿ݤǧ
		if ( IsRevoked ) {
			semaAcsInstance.V();
			ToClient.AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
			ToClient.AddData( SCI_R_STOPPED, SCID_RSTOP_RESUME );
			ToClient.AddData( SCI_R_MSG_NUMBER, SCID_RMSG_SERVER_REVOKED );
			RetryCnt = 0;
			break;
		}

		// ޥɤμ̤˽Ԥ
		switch ( CmdType ) {
		case SCID_CMD_OPENFILE_CS:
			// ե򳫤
			pInstanceMgr->OpenFile_CS( negcmd, &ToClient );
			break;
		case SCID_CMD_OPENFILE_TS:
			// ɮǥե뤬
			pInstanceMgr->OpenFile_TS( negcmd, &ToClient );
			break;
		case SCID_CMD_NEWFILE_TS:
			// ɮǥե뤬˺
			pInstanceMgr->NewFile_TS( negcmd, &ToClient );
			break;
		case SCID_CMD_WRITEFILE_TS:
			// ɮ̾դ¸Ԥ
			pInstanceMgr->WriteFile_TS( negcmd, &ToClient );
			break;
		case SCID_CMD_EXIT_TS:
			// ɮλ
			pInstanceMgr->Exit_TS( negcmd, &ToClient );
			break;
		case SCID_CMD_STOP_CS:
			// Фߤ
			if ( pInstanceMgr->CanBeStopServer() ) {
				// ߤǤߤ
				IsRevoked = true;
				semaWait.V();
				ToClient.AddData( SCI_R_STATUS, SCID_RSTAT_OK );
				ToClient.AddData( SCI_R_STOPPED, SCID_RSTOP_RESUME );
			}
			else {
				// ɮΥ󥹥󥹤ĤäƤ뤿ᡢߤǤʤ
				ToClient.AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
				ToClient.AddData( SCI_R_STOPPED, SCID_RSTOP_RESUME );
				ToClient.AddData( SCI_R_MSG_NUMBER, SCID_RMSG_TAEDIT_IS_EXIST );
			}
			break;
		case SCID_CMD_STOP_FORCE_CS:
			// ФŪߤ
			pInstanceMgr->StopServerByForce_CS();
			ToClient.AddData( SCI_R_STATUS, SCID_RSTAT_OK );
			ToClient.AddData( SCI_R_STOPPED, SCID_RSTOP_RESUME );
			IsRevoked = true;
			semaWait.V();
			break;
		case SCID_CMD_OPENFILE_NW_TS:
			// ɥǥե򳫤
			pInstanceMgr->OpenFileNW_TS( negcmd, &ToClient );
			break;
		case SCID_CMD_JOIN_TS:
			// ɮ󥹥ȥ饯󡦥⡼ɤ˻ä
			pInstanceMgr->Join_TS( negcmd, &ToClient );
			break;
		case SCID_CMD_UNJOIN_TS:
			// ɮ󥹥ȥ饯󡦥⡼ɤæह
			pInstanceMgr->Exit_TS( negcmd, &ToClient );
			break;
		}

		// 顼֤ϡưƤɮξ򹹿Ƥ顢
		// ⤦ٽ롣ʥ饤ȤΥޥɤξΤߡ
		if ( ToClient.GetData( SCI_R_STATUS, SCID_RSTAT_ERR ) == SCID_RSTAT_ERR &&
				RetryCnt > 1 &&
				CmdType & SCID_CMD_CS_MASK ) {

			// ưμɮξ򹹿
			pInstanceMgr->UpdateExistTaEditInfo();
			// ͤΥå
			ToClient.Initialize();
			RetryCnt--;
		}
		else
			RetryCnt = 0;

		semaAcsInstance.V();
	}

	// ƤӽФ˷̤֤
	ToClientStr = ToClient.GetSendData();
	pRetBuf = (char*)alloca( sizeof( char ) * ToClientStr.length() );
	memcpy( pRetBuf, ToClientStr.c_str(), ToClientStr.length() );

	door_return( pRetBuf, ToClientStr.length(), NULL, 0 );
}

