////////////////////////////////////////////////////////////////////////////
// CCmdOpt 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include "CmdOpt.h"
#include <assert.h>

#define SWITCH_CHAR '-'

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CCmdOpt::CCmdOpt() :
	FileName( "" ),
	LineNumber( 1 ),
	LangType( "" ),
	StandAlone( false ),
	StopSvrByForce( false ),
	CmdType( CT_FILE_OPEN )
{

}

CCmdOpt::~CCmdOpt()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
// η³Բǽʾϵ֤
bool CCmdOpt::Initialize( int argc, char *argv[] )
{
	int i;

	if ( argc <= 1 ) return true;

	// ǽΰåǤʤС[file][-s]η
	if ( argv[1][0] != SWITCH_CHAR ) {
		if ( argc >= 4 ) return help( argv[0] );
		if ( argc == 3 ) {
			// ɥ⡼
			if ( strcmp( argv[2], "-s" ) ) return help( argv[0] );
			StandAlone = true;
		}
		FileName = argv[1];	// ե̾
		CmdType = CT_FILE_OPEN;
		return true;
	}

	if ( !strcmp( argv[1], "-h" ) ) return help( argv[0] );

	if ( !strcmp( argv[1], "-b" ) ) {
		// ФΥ֡ȤΤ
		if ( argc >= 3 ) return help( argv[0] );
		CmdType = CT_BOOT_SERVER;
		return true;
	}

	if ( !strcmp( argv[1], "-k" ) ) {
		// Ф
		if ( argc >= 3 ) return help( argv[0] );
		CmdType = CT_STOP_SERVER;
		StopSvrByForce = false;
		return true;
	}

	if ( !strcmp( argv[1], "-K" ) ) {
		// Фζ
		if ( argc >= 3 ) return help( argv[0] );
		CmdType = CT_STOP_SERVER;
		StopSvrByForce = true;
		return true;
	}

	// ե򳫤
	CmdType = CT_FILE_OPEN;
	i = 1;
	while ( i < argc ) {
		if ( !strcmp( argv[i], "-f" ) ) {
			// ե̾
			// -fμΰϡʶŪˡ˥ե̾ȸʤ
			// -fθ˲ʤä顢ե̾Ͼά줿ʪȸʤ
			if ( i >= argc - 1 ) {
				FileName = "";
				i++;
			}
			else {
				FileName = argv[i+1];
				i += 2;
			}
		}
		else if ( !strcmp( argv[i], "-l" ) ) {
			// ֹ
			// -lθˤϹֹ椬ɬ
			if ( i >= argc - 1 ) return help( argv[0] );
			LineNumber = atoi( argv[i+1] );
			i += 2;
		}
		else if ( !strcmp( argv[i], "-t" ) ) {
			// ʸ
			// -tθˤϹʸ̤ɬ
			if ( i >= argc - 1 ) return help( argv[0] );
			LangType = argv[i+1];
			i += 2;
		}
		else if ( !strcmp( argv[i], "-s" ) ) {
			// ɥ⡼
			StandAlone = true;
			i++;
		}
		else {
			// 顼
			return help( argv[0] );
		}
	}

	return true;
}

// ޥɤΥץɽ
bool CCmdOpt::help( const char *cmd )
{
	string CmdName;
	int len;
	int i;

	assert( cmd );

	// ̤ɽ륳ޥ̾ꤹ
	len = strlen( cmd );
	if ( len == 0 ) {
		CmdName = "TaEditClient";
	}
	else {
		for ( i = len - 1; i >= 0 && cmd[i] != '/'; i-- );
		if ( i < 0 )
			CmdName = cmd;
		else
			CmdName = cmd + i + 1;
	}

	fprintf( stderr, "%s : Syuhitu Client\n", CmdName.c_str() );
	fprintf( stderr, "\tCommand Option\n" );
	fprintf( stderr, "\t %s [file] [ -s ]\n", CmdName.c_str() );
	fprintf( stderr, "\t %s -f file [ -l line ] [ -t syntax ] [ -s ]\n", CmdName.c_str() );
	fprintf( stderr, "\t %s -h\n", CmdName.c_str() );
	fprintf( stderr, "\t %s -b\n", CmdName.c_str() );
	fprintf( stderr, "\t %s -k\n", CmdName.c_str() );
	fprintf( stderr, "\t %s -K\n", CmdName.c_str() );
	fprintf( stderr, "\t-s : Stand alone mode.\n" );	
	fprintf( stderr, "\t-l : Cursor position.\n" );	
	fprintf( stderr, "\t-t : Syntax mode.\n" );	
	fprintf( stderr, "\t-h : Show this message.\n" );	
	fprintf( stderr, "\t-b : Boot server only.\n" );
	fprintf( stderr, "\t-k : Stop server.\n" );
	fprintf( stderr, "\t-k : Stop server by force.\n" );
	return false;
}

// ե饰Ϥ
int CCmdOpt::RecognizeFlg( int argc, char *argv[], const char *pFlg )
{
	int i;

	for ( i = 0; i < argc; i++ ) {
		if ( strcmp( argv[i], pFlg ) == 0 )
			return i;
	}
	return i;
}

// ޥɤμ̤
CMDTYPE CCmdOpt::GetCmdType() const
{
	return CmdType;
}

const string& CCmdOpt::GetFileName() const
{
	return FileName;
}

int CCmdOpt::GetLineNumber() const
{
	return LineNumber;
}

const string& CCmdOpt::GetLangType() const
{
	return LangType;
}

bool CCmdOpt::GetStandAlone() const
{
	return StandAlone;
}

bool CCmdOpt::GetStopSvrByForce() const
{
	return StopSvrByForce;
}

