package jp.sf.stconv.wiki.pukiwiki.pipeline.valve;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import jp.sf.stconv.pipeline.PipelineException;
import jp.sf.stconv.pipeline.StreamConverterPipeline;
import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.storage.StreamStorageException;
import jp.sf.stconv.storage.impl.FileStreamStorageImpl;
import junit.framework.TestCase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractValveTest extends TestCase
{

	/**
	 * Logger for this class
	 */
	protected final Log log = LogFactory.getLog(this.getClass());

	StreamConverterPipeline pipeline = null;

	List valveList = new ArrayList();

	public AbstractValveTest()
	{
		super();
	}

	public AbstractValveTest(String arg0)
	{
		super(arg0);
	}
    
    protected void addCallbacks(StreamStorage storage) {

    }

	protected String doLineInvoke(String str)
	{
		StringBuffer buffer = new StringBuffer();
		try
		{
			this.pipeline = new StreamConverterPipeline("", this.valveList);
			StreamStorage storage = new FileStreamStorageImpl(
					new ByteArrayInputStream(str.getBytes("UTF-8")), "UTF-8");
            addCallbacks(storage);
			this.pipeline.invoke(storage);
	
			BufferedReader r = null;
			try
			{
				r = new BufferedReader(new InputStreamReader(storage
						.getResultInputStream(), storage.getEncoding()));
				String l = null;
				while ((l = r.readLine()) != null)
				{
					buffer.append(l);
				}
			}
			catch (UnsupportedEncodingException e)
			{
				this.log.warn("Unsupported Encoding. ", e);
			}
			catch (StreamStorageException e)
			{
				this.log.warn("Stream Storage Exception. ", e);
			}
			catch (IOException e)
			{
				this.log.error("I/O Exception. ", e);
			}
			finally
			{
				if(r != null)
				{
					try
					{
						r.close();
					}
					catch (IOException e)
					{
					}
				}
			}
			storage.destroy();
		}
		catch (StreamStorageException e)
		{
			this.log.error("StreamStorage Exception.", e);
		}
		catch (PipelineException e)
		{
			this.log.error("Pipeline Exception.", e);
		}
		catch (Exception e)
		{
			this.log.error("Exception.", e);
		}
		return buffer.toString();
	}
	
}
