package jp.sf.stconv.pipeline;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

import jp.sf.stconv.AbstractTestCase;
import jp.sf.stconv.pipeline.StreamConverterPipeline;
import jp.sf.stconv.pipeline.PipelineException;
import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.storage.StreamStorageException;
import jp.sf.stconv.storage.impl.FileStreamStorageImpl;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/**
 * Unit test for simple App.
 *
 * @author <a href="mailto:jason@zenplex.com">Jason van Zyl</a>
 */
public class StreamConverterPipelineTest extends AbstractTestCase
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(StreamConverterPipelineTest.class);

    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public StreamConverterPipelineTest(String testName)
    {
        super(testName);
    }

    /**
     * @return the suite of tests being tested
     */
    public static Test suite()
    {
        return new TestSuite(StreamConverterPipelineTest.class);
    }

    /**
     * Rigourous Test :-)
     */
    public void testPipeline()
    {
        SingletonS2ContainerFactory
                .setConfigPath("jp/sf/stconv/StreamConverter.dicon");
        SingletonS2ContainerFactory.init();
        S2Container container = SingletonS2ContainerFactory.getContainer();

        StreamConverterPipeline pipeline = (StreamConverterPipeline) container
                .getComponent(StreamConverterPipeline.class);

        StringBuffer buffer = new StringBuffer();
        try
        {
            StreamStorage storage = new FileStreamStorageImpl(
                    new ByteArrayInputStream("abc\nABC\ndef\nDEF\n".getBytes()),
                    "UTF-8");
            pipeline.invoke(storage);

            BufferedReader r = null;
            try
            {
                r = new BufferedReader(new InputStreamReader(storage
                        .getResultInputStream(), storage.getEncoding()));
                String l = null;
                while ((l = r.readLine()) != null)
                {
                    buffer.append(l);
                    buffer.append("\n");
                }
            }
            catch (UnsupportedEncodingException e)
            {
                log.warn("Unsupported Encoding. ", e);
            }
            catch (StreamStorageException e)
            {
                log.warn("Stream Storage Exception. ", e);
            }
            catch (IOException e)
            {
                log.error("I/O Exception. ", e);
            }
            finally
            {
                if (r != null)
                {
                    try
                    {
                        r.close();
                    }
                    catch (IOException e)
                    {
                    }
                }
            }
            storage.destroy();
        }
        catch (StreamStorageException e)
        {
            log.error("StreamStorage Exception.", e);
        }
        catch (PipelineException e)
        {
            log.error("Pipeline Exception.", e);
        }

        assertEquals(buffer.toString(), "ABC\nABC\nDEF\nDEF\n");
    }
}
