package jp.sf.stconv.pipeline.valve.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

import jp.sf.stconv.pipeline.PipelineException;
import jp.sf.stconv.pipeline.valve.AbstractValve;
import jp.sf.stconv.pipeline.valve.ValveContext;
import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.storage.StreamStorageException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ToUpperCaseValve extends AbstractValve
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(ToUpperCaseValve.class);

    public void invoke(StreamStorage storage, ValveContext context)
            throws PipelineException
    {
        BufferedReader reader = null;
        try
        {
            reader = new BufferedReader(new InputStreamReader(storage
                    .getInputStream(), storage.getEncoding()));
        }
        catch (UnsupportedEncodingException e)
        {
            log.warn("Unsupported Encoding. ", e);
            reader = new BufferedReader(new InputStreamReader(storage
                    .getInputStream()));
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(
                storage.getOutputStream()));

        String line = null;
        try
        {
            while ((line = reader.readLine()) != null)
            {
                writer.write(line.toUpperCase());
                writer.write("\n");
            }
            writer.flush();
            storage.commit();
        }
        catch (StreamStorageException e)
        {
            log.error("Stream Storage Exception. ", e);
            throw new PipelineException(e);
        }
        catch (IOException e)
        {
            log.error("Stream Storage Exception. ", e);
            throw new PipelineException(e);
        }

        if (log.isDebugEnabled())
        {
            log
                    .debug("invoke(StreamStorage, ValveContext) - getResultInputStream()=\n");
            BufferedReader r = null;
            try
            {
                r = new BufferedReader(new InputStreamReader(storage
                        .getResultInputStream(), storage.getEncoding()));
                String l = null;
                while ((l = r.readLine()) != null)
                {
                    log.debug(l);
                }
            }
            catch (UnsupportedEncodingException e)
            {
                log.warn("Unsupported Encoding. ", e);
            }
            catch (StreamStorageException e)
            {
                log.warn("Stream Storage Exception. ", e);
            }
            catch (IOException e)
            {
                log.error("I/O Exception. ", e);
            }
            finally
            {
                if (r != null)
                {
                    try
                    {
                        r.close();
                    }
                    catch (IOException e)
                    {
                    }
                }
            }

        }

        context.invokeNext(storage);

    }
}
