package jp.sf.stconv.hatena.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;

/**
 * BR - Line Break
 * 
 * 改行を2回続けて入れると<br>タグを挿入します。
 * 
 * @author takeharu
 *
 */
public class ConvertLineBreakValve extends AbstractHatenaValve
{

	private String pattern = "^$";

	private boolean breakFlg;

	protected String getPattern()
	{
		return pattern;
	}

	protected void writeMatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		if(breakFlg)
		{
			writer.write("<br />");
			writer.newLine();
			breakFlg = false;
		}
		else {
			breakFlg = true;
		}
	}

	protected void writeUnmatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		if(breakFlg) {			
			breakFlg = false;
		}
		writer.write(line);
		writer.newLine();
	}
}
