/**
 * 
 */
package jp.sf.stconv.hatena.pipeline.valve;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;

import jp.sf.stconv.pipeline.PipelineException;
import jp.sf.stconv.pipeline.valve.AbstractValve;
import jp.sf.stconv.pipeline.valve.ValveContext;
import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.storage.StreamStorageException;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author takeharu
 */
public abstract class AbstractHatenaValve extends AbstractValve
{

	/**
	 * Logger for this class
	 */
	protected final Log log = LogFactory.getLog(this.getClass());

	/*
	 * (非 Javadoc)
	 * 
	 * @see jp.sf.stconv.pipeline.valve.AbstractValve#invoke(jp.sf.stconv.storage.StreamStorage,
	 *      jp.sf.stconv.pipeline.valve.ValveContext)
	 */
	public void invoke(StreamStorage storage, ValveContext context)
			throws PipelineException
	{
		BufferedReader reader = null;
		BufferedWriter writer = null;
		Pattern ptn = Pattern.compile(getPattern());

		try
		{
			reader = new BufferedReader(new InputStreamReader(storage
					.getInputStream(), storage.getEncoding()));
			writer = new BufferedWriter(new OutputStreamWriter(storage
					.getOutputStream(), storage.getEncoding()));
		}
		catch (UnsupportedEncodingException e)
		{
			log.warn("Unsupported Encoding. ", e);
			reader = new BufferedReader(new InputStreamReader(storage
					.getInputStream()));
		}

		String line = null;
		try
		{
			while ((line = reader.readLine()) != null)
			{
				line = StringEscapeUtils.unescapeHtml(line);
//				log.debug("LINE:"+line);
				if(ptn.matcher(line).find())
				{
//					log.debug("HIT:"+line);
					writeMatchLine(storage, writer, line);
				}
				else
				{
					writeUnmatchLine(writer, line);
				}
			}
			finish(writer);
			writer.flush();
			storage.commit();
		}
		catch (StreamStorageException e)
		{
			log.error("Stream Storage Exception. ", e);
			throw new PipelineException(e);
		}
		catch (IOException e)
		{
			log.error("Stream Storage Exception. ", e);
			throw new PipelineException(e);
		}

//		if(log.isDebugEnabled())
//		{
//			log
//					.debug("invoke(StreamStorage, ValveContext) - getResultInputStream()=\n");
//			BufferedReader r = null;
//			try
//			{
//				r = new BufferedReader(new InputStreamReader(storage
//						.getResultInputStream(), storage.getEncoding()));
//				String l = null;
//				while ((l = r.readLine()) != null)
//				{
//					log.debug(l);
//				}
//			}
//			catch (UnsupportedEncodingException e)
//			{
//				log.warn("Unsupported Encoding. ", e);
//			}
//			catch (StreamStorageException e)
//			{
//				log.warn("Stream Storage Exception. ", e);
//			}
//			catch (IOException e)
//			{
//				log.error("I/O Exception. ", e);
//			}
//			finally
//			{
//				if(r != null)
//				{
//					try
//					{
//						r.close();
//					}
//					catch (IOException e)
//					{
//					}
//				}
//			}
//
//		}

		context.invokeNext(storage);

	}

	protected void finish(BufferedWriter writer) throws IOException
	{

	}

	protected void writeUnmatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		
		writer.write(line);
		writer.newLine();
	}

    protected void writeMatchLine(StreamStorage storage, BufferedWriter writer,
            String line)
            throws IOException
    {
        writeMatchLine(writer, line);
    }

    protected void writeMatchLine(BufferedWriter writer, String line)
            throws IOException 
    {
		writer.write(line);
		writer.newLine();
	}

	protected String getPattern()
	{
		return "";
	}

}
