/*
 * Copyright 2003-2006 Stream Converter Project Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.stconv.storage.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import jp.sf.stconv.storage.Callback;
import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.storage.StreamStorageException;

/**
 * @author shinsuke
 * 
 */
public abstract class AbstractStreamStorage implements StreamStorage {

    private Map callbackMap;

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.storage.StreamStorage#commit()
     */
    public abstract void commit() throws StreamStorageException;

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.storage.StreamStorage#destroy()
     */
    public abstract void destroy();

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.storage.StreamStorage#getEncoding()
     */
    public abstract String getEncoding();

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.storage.StreamStorage#getInputStream()
     */
    public abstract InputStream getInputStream();

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.storage.StreamStorage#getOutputStream()
     */
    public abstract OutputStream getOutputStream();

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.storage.StreamStorage#getResultInputStream()
     */
    public abstract InputStream getResultInputStream()
            throws StreamStorageException;

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.storage.StreamStorage#init(java.io.InputStream,
     *      java.lang.String)
     */
    public abstract void init(InputStream in, String encoding)
            throws StreamStorageException;

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.storage.StreamStorage#addCallback(java.lang.String,
     *      jp.sf.stconv.storage.Callback)
     */
    public void addCallback(String key, Callback callback) {
        // TODO Auto-generated method stub
        if (callbackMap == null) {
            callbackMap = new HashMap();
        }
        callbackMap.put(key, callback);
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.storage.StreamStorage#getCallback(java.lang.String)
     */
    public Callback getCallback(String key) {
        if (callbackMap == null) {
            return null;
        }
        return (Callback) callbackMap.get(key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.storage.StreamStorage#removeCallback(java.lang.String)
     */
    public Callback removeCallback(String key) {
        if (callbackMap != null) {
            return (Callback) callbackMap.remove(key);
        }
        return null;
    }

}
