/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.stconv.pipeline.valve.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jp.sf.stconv.pipeline.PipelineException;
import jp.sf.stconv.pipeline.valve.AbstractValve;
import jp.sf.stconv.pipeline.valve.ValveContext;
import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.storage.StreamStorageException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ToLowerCaseValve
extends AbstractValve {
    private static final Log log = LogFactory.getLog((Class)ToLowerCaseValve.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(StreamStorage storage, ValveContext context) throws PipelineException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(storage.getInputStream(), storage.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)"Unsupported Encoding. ", (Throwable)e);
            reader = new BufferedReader(new InputStreamReader(storage.getInputStream()));
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(storage.getOutputStream()));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                writer.write(line.toLowerCase());
                writer.write("\n");
            }
            writer.flush();
            storage.commit();
        }
        catch (StreamStorageException e) {
            log.error((Object)"Stream Storage Exception. ", (Throwable)e);
            throw new PipelineException((Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Stream Storage Exception. ", (Throwable)e);
            throw new PipelineException((Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"invoke(StreamStorage, ValveContext) - getResultInputStream()=\n");
            BufferedReader r = null;
            try {
                r = new BufferedReader(new InputStreamReader(storage.getResultInputStream(), storage.getEncoding()));
                String l = null;
                while ((l = r.readLine()) != null) {
                    log.debug((Object)l);
                }
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)"Unsupported Encoding. ", (Throwable)e);
            }
            catch (StreamStorageException e) {
                log.warn((Object)"Stream Storage Exception. ", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"I/O Exception. ", (Throwable)e);
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        context.invokeNext(storage);
    }
}

