/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.stconv.storage.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.storage.StreamStorageException;
import jp.sf.stconv.storage.impl.AbstractStreamStorage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileStreamStorageImpl
extends AbstractStreamStorage
implements StreamStorage {
    private static final Log log = LogFactory.getLog((Class)FileStreamStorageImpl.class);
    private String DEFAULT_TMPFILE_PREFIX = "STREAMSTORAGE_";
    private String DEFAULT_TMPFILE_SUFFIX = ".tmp";
    private InputStream inputStream;
    private OutputStream outputStream;
    private String encoding;
    private File previousFile;
    private File currentFile;

    public FileStreamStorageImpl(InputStream in, String encoding) throws StreamStorageException {
        this.init(in, encoding);
    }

    public void init(InputStream in, String encoding) throws StreamStorageException {
        try {
            this.inputStream = in;
            this.encoding = encoding;
            this.previousFile = null;
            this.currentFile = File.createTempFile(this.DEFAULT_TMPFILE_PREFIX, this.DEFAULT_TMPFILE_SUFFIX);
            this.outputStream = new FileOutputStream(this.currentFile);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Cannot find the temp file: " + this.currentFile.getName()), (Throwable)e);
            throw new StreamStorageException(e);
        }
        catch (IOException e) {
            log.error((Object)"I/O error occurs. ", (Throwable)e);
            throw new StreamStorageException(e);
        }
    }

    public void destroy() {
        if (this.previousFile != null && this.previousFile.isFile()) {
            this.previousFile.deleteOnExit();
        }
        if (this.currentFile != null && this.currentFile.isFile()) {
            this.currentFile.deleteOnExit();
        }
    }

    public void commit() throws StreamStorageException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
            }
            if (this.previousFile != null && this.previousFile.isFile()) {
                this.previousFile.deleteOnExit();
            }
            this.previousFile = this.currentFile;
            this.currentFile = File.createTempFile(this.DEFAULT_TMPFILE_PREFIX, this.DEFAULT_TMPFILE_SUFFIX);
            this.inputStream = new FileInputStream(this.previousFile);
            this.outputStream = new FileOutputStream(this.currentFile);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Cannot find the temp file. ", (Throwable)e);
            throw new StreamStorageException(e);
        }
        catch (IOException e) {
            log.error((Object)"I/O error occurs. ", (Throwable)e);
            throw new StreamStorageException(e);
        }
    }

    public InputStream getResultInputStream() throws StreamStorageException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getResultInputStream() - previousFile=" + this.previousFile));
            }
            if (this.previousFile == null) {
                if (this.inputStream.markSupported()) {
                    this.inputStream.reset();
                }
                return this.inputStream;
            }
            return new FileInputStream(this.previousFile);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Cannot find the temp file: " + this.previousFile.getName()), (Throwable)e);
            throw new StreamStorageException(e);
        }
        catch (IOException e) {
            log.error((Object)"I/O error occurs. ", (Throwable)e);
            throw new StreamStorageException(e);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

