/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.stconv.storage.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.storage.StreamStorageException;
import jp.sf.stconv.storage.impl.AbstractStreamStorage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ByteArrayStreamStorageImpl
extends AbstractStreamStorage
implements StreamStorage {
    private static final Log log = LogFactory.getLog((Class)ByteArrayStreamStorageImpl.class);
    private int DEFAULT_ARRAY_SIZE = 512;
    private InputStream inputStream;
    private ByteArrayOutputStream outputStream;
    private String encoding;
    private byte[] buffer = null;

    public ByteArrayStreamStorageImpl(InputStream in, String encoding) throws StreamStorageException {
        this.init(in, encoding);
    }

    public void init(InputStream in, String encoding) throws StreamStorageException {
        this.inputStream = in;
        this.encoding = encoding;
        this.outputStream = new ByteArrayOutputStream(this.DEFAULT_ARRAY_SIZE);
    }

    public void destroy() {
        this.buffer = null;
        this.outputStream = null;
    }

    public void commit() throws StreamStorageException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
            }
            this.buffer = this.outputStream.toByteArray();
            this.inputStream = new ByteArrayInputStream(this.buffer);
            this.outputStream = new ByteArrayOutputStream(this.DEFAULT_ARRAY_SIZE);
        }
        catch (IOException e) {
            log.error((Object)"I/O error occurs. ", (Throwable)e);
            throw new StreamStorageException(e);
        }
    }

    public InputStream getResultInputStream() throws StreamStorageException {
        try {
            if (this.buffer == null) {
                if (this.inputStream.markSupported()) {
                    this.inputStream.reset();
                }
                return this.inputStream;
            }
            return new ByteArrayInputStream(this.buffer);
        }
        catch (IOException e) {
            log.error((Object)"I/O error occurs. ", (Throwable)e);
            throw new StreamStorageException(e);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        if (!(outputStream instanceof ByteArrayOutputStream)) {
            throw new IllegalArgumentException("The output stream is not ByteArrayOutputStream.");
        }
        this.outputStream = (ByteArrayOutputStream)outputStream;
    }
}

