/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.stconv.wiki.pukiwiki.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;
import jp.sf.stconv.wiki.pukiwiki.pipeline.valve.AbstractWikiValve;

public class ConvertTableValve
extends AbstractWikiValve {
    private String pattern = "\\|.*\\|$";
    private boolean isTagStarted;

    protected String getPattern() {
        return this.pattern;
    }

    protected void writeMatchLine(BufferedWriter writer, String line) throws IOException {
        if (!this.isTagStarted) {
            writer.write("<table>");
            writer.newLine();
            this.isTagStarted = true;
        }
        String[] values = line.split("\\|");
        writer.write("<tr>");
        for (int i = 1; i < values.length; ++i) {
            String s = values[i];
            if (s.startsWith("*")) {
                s = s.substring(1);
                writer.write("<th>" + s + "</th>");
                continue;
            }
            writer.write("<td>" + s + "</td>");
        }
        writer.write("</tr>");
        writer.newLine();
    }

    protected void writeUnmatchLine(BufferedWriter writer, String line) throws IOException {
        if (this.isTagStarted) {
            writer.write("</table>");
            writer.newLine();
            writer.write(line);
            writer.newLine();
            this.isTagStarted = false;
        } else {
            super.writeUnmatchLine(writer, line);
        }
    }

    protected void finish(BufferedWriter writer) throws IOException {
        if (this.isTagStarted) {
            writer.write("</table>");
            writer.newLine();
            this.isTagStarted = false;
        } else {
            super.finish(writer);
        }
    }
}

