/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.stconv.wiki.pukiwiki.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;
import jp.sf.stconv.wiki.pukiwiki.pipeline.valve.AbstractWikiValve;

public class ConvertParagraphValve
extends AbstractWikiValve {
    private String pattern = "^([^>\\|,\\-\\+\\*:#\\s\\/]|~)";
    private boolean isTagStarted;

    protected String getPattern() {
        return this.pattern;
    }

    protected void writeMatchLine(BufferedWriter writer, String line) throws IOException {
        String str;
        if (!this.isTagStarted) {
            writer.write("<p>");
            this.isTagStarted = true;
        }
        if ((str = line).startsWith("~")) {
            str = str.substring(1);
        }
        writer.write(str);
        writer.newLine();
    }

    protected void writeUnmatchLine(BufferedWriter writer, String line) throws IOException {
        if (this.isTagStarted) {
            writer.write("</p>");
            writer.newLine();
            this.isTagStarted = false;
        }
        super.writeUnmatchLine(writer, line);
    }

    protected void finish(BufferedWriter writer) throws IOException {
        if (this.isTagStarted) {
            writer.write("</p>");
            this.isTagStarted = false;
        } else {
            super.finish(writer);
        }
    }
}

