/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.stconv.wiki.pukiwiki.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.wiki.pipeline.callback.LinkGeneratorCallback;
import jp.sf.stconv.wiki.pukiwiki.pipeline.valve.AbstractWikiValve;

public class ConvertPageNameLinkValve
extends AbstractWikiValve {
    private String pattern = ".*[A-Z][a-z]+[A-Z][a-z]+.*";

    protected String getPattern() {
        return this.pattern;
    }

    protected void writeMatchLine(StreamStorage storage, BufferedWriter writer, String line) throws IOException {
        LinkGeneratorCallback callback = (LinkGeneratorCallback)storage.getCallback("jp.sf.stconv.wiki.pipeline.callback.LinkGeneratorCallback");
        if (callback == null) {
            this.writeUnmatchLine(writer, line);
            return;
        }
        Pattern pattern = Pattern.compile("([A-Z][a-z]+([A-Z][a-z]+)+)");
        Matcher matcher = pattern.matcher(line);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String pageName = matcher.group(1);
            callback.init();
            callback.addAttribute("pageName", pageName);
            matcher.appendReplacement(buf, "<a href=\"" + callback.getUrl() + "\">" + pageName + "</a>");
        }
        matcher.appendTail(buf);
        writer.write(buf.toString());
        writer.newLine();
    }
}

