/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.stconv.hatena.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;
import jp.sf.stconv.hatena.pipeline.valve.AbstractHatenaValve;

public class ConvertHttpLinkValve
extends AbstractHatenaValve {
    private static final String KEYWORD_TITLE = ":title=";
    private static final String URI_CHARACTERS = "\\[?http://[a-zA-Z0-9\\;\\/\\?\\:\\@\\&\\=\\+\\$\\,\\-\\_\\.\\!\\~\\*\\'\\(\\)\\#]*";
    private static final String pattern = ".*http:.*";

    protected String getPattern() {
        return pattern;
    }

    protected void writeMatchLine(BufferedWriter writer, String line) throws IOException {
        String ln = line.trim();
        int sp = (ln = ln.replaceAll("\\[|\\]", "")).indexOf("http:");
        if (sp < 0) {
            return;
        }
        boolean addParagraph = ln.startsWith("http:");
        String[] strs = ln.split(URI_CHARACTERS);
        StringBuffer sb = new StringBuffer();
        if (addParagraph) {
            sb.append("<p>");
        }
        if (strs.length == 0) {
            ln = "<a href=\"" + ln + "\">" + ln + "</a>";
            sb.append(ln);
        } else {
            String url = "";
            String value = "";
            for (int i = 0; i < strs.length; ++i) {
                int ep = 0;
                ep = i + 1 < strs.length ? ln.indexOf(strs[i + 1], sp) : -1;
                sb.append(strs[i]);
                if (ep > 0) {
                    sb.append("<a href=\"");
                    value = url = ln.substring(sp, ep);
                    if (url.indexOf("http:") > 0) {
                        value = url = url.substring(url.indexOf("http:"));
                    }
                    if (url.indexOf(KEYWORD_TITLE) != -1) {
                        url = url.substring(0, url.indexOf(KEYWORD_TITLE));
                        value = line.substring(line.indexOf(KEYWORD_TITLE, sp) + KEYWORD_TITLE.length(), line.indexOf("]", line.indexOf(KEYWORD_TITLE, sp)));
                        strs[i + 1] = strs[i + 1].replaceAll(value, "");
                        this.log.debug((Object)(url + " : " + value));
                    }
                    sb.append(url);
                    sb.append("\">");
                    sb.append(value);
                    sb.append("</a>");
                }
                sp = ep;
            }
        }
        if (addParagraph) {
            sb.append("</p>");
        }
        writer.write(sb.toString());
        writer.newLine();
    }
}

