/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.stconv.hatena.pipeline.valve;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import jp.sf.stconv.pipeline.PipelineException;
import jp.sf.stconv.pipeline.valve.AbstractValve;
import jp.sf.stconv.pipeline.valve.ValveContext;
import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.storage.StreamStorageException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHatenaValve
extends AbstractValve {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void invoke(StreamStorage storage, ValveContext context) throws PipelineException {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        Pattern ptn = Pattern.compile(this.getPattern());
        try {
            reader = new BufferedReader(new InputStreamReader(storage.getInputStream(), storage.getEncoding()));
            writer = new BufferedWriter(new OutputStreamWriter(storage.getOutputStream(), storage.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            this.log.warn((Object)"Unsupported Encoding. ", (Throwable)e);
            reader = new BufferedReader(new InputStreamReader(storage.getInputStream()));
        }
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if (ptn.matcher(line = StringEscapeUtils.unescapeHtml((String)line)).find()) {
                    this.writeMatchLine(storage, writer, line);
                    continue;
                }
                this.writeUnmatchLine(writer, line);
            }
            this.finish(writer);
            writer.flush();
            storage.commit();
        }
        catch (StreamStorageException e) {
            this.log.error((Object)"Stream Storage Exception. ", (Throwable)e);
            throw new PipelineException((Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)"Stream Storage Exception. ", (Throwable)e);
            throw new PipelineException((Throwable)e);
        }
        context.invokeNext(storage);
    }

    protected void finish(BufferedWriter writer) throws IOException {
    }

    protected void writeUnmatchLine(BufferedWriter writer, String line) throws IOException {
        writer.write(line);
        writer.newLine();
    }

    protected void writeMatchLine(StreamStorage storage, BufferedWriter writer, String line) throws IOException {
        this.writeMatchLine(writer, line);
    }

    protected void writeMatchLine(BufferedWriter writer, String line) throws IOException {
        writer.write(line);
        writer.newLine();
    }

    protected String getPattern() {
        return "";
    }
}

