;-------------------------------------------------------------------------------
; Welche Muster(nummern) wurden ueberhaupt erkannt ?
;-------------------------------------------------------------------------------
(defun erkannt ()
   (let (result)
      (dolist (x !patterns nil)
         (if (not (member (car x) result))
             (setq result (cons (car x) result))
         )
      )
      result
   )
)




;-------------------------------------------------------------------------------
; Assoziationsliste Muster <-> Aktionen
; Die Muster sind durch ihre Nummer aus MUSTER.TXT eindeutig identifiziert.
; In welcher Orientierung die Muster vorliegen, ist in der Liste !PATTERNS
; beschrieben. Es werden der Reihe nach alle mit einem Muster assoziierten
; Funktionsaufrufe durchgefuehrt, wobei noch der Musterort und die Orientierung
; an den Funktionsaufruf als zusaetzliche Parameter angefuegt werden.
;-------------------------------------------------------------------------------


(setq Muster-Aktionen (make-array 350))

(defmacro Index (i liste)
   `(setf (aref Muster-aktionen ,i) ',liste)
)

(Index 1 (
          ($eck-besetzen 0)
          ($eck-besetzen 1)
          ($eck-besetzen 4)
          ($eck-besetzen 5)
          ($eck-besetzen 6)
         ))
(Index 2 (
          ($rand-besetzen 0)
          ($rand-besetzen 7)
         ))
(Index 3 (
          ($basiszug 5 10)
         ))
(Index 6 (
          ($shimari 0 15)
          ($shimari 0 34)
         ))
(Index 7  (($shimari 5 1)
                                 ($shimari 5 8)
                                 ($shimari 5 9)))
(Index 8  (($shimari 1 5)
                                 ($shimari 1 4)))
(Index 9  (($shimari 6 1)
                                 ($shimari 6 10)))
(Index 10  (($shimari 4 7)))
(Index 11  (($ecktripel 6)
                                  ($ecktripel 7)
                                  ($ecktripel 22)))
(Index 12  (($ecktripel 21)
                                  ($ecktripel 22)
                                  ($invasion-verhindern 21)
                                  ($invasion-verhindern 22)))
(Index 14  (($feinde 0 1)
                                  ($feinde 1 0)))
(Index 15 (
           ($lokal-optimal 1)
; evtl. etwas gewagt              ($kontextbezogen 1 4)
; evtl. etwas gewagt              ($kontextbezogen 1 6)
           ))
(Index 16  (
            ($lokal-optimal 0)
            ($abdichten 1 0)
            ($abdichten 2 0)
            ($abdichten 7 0)
           ))
(Index 17  (($lokal-optimal 1)))
(Index 18  (($lokal-optimal 11)))
(Index 19  (($lokal-optimal 0)))
(Index 20  (($lokal-optimal 1)))
(Index 21  (($vorschlag 1 15)))
(Index 22  (($vorschlag 2 15)))
(Index 23  (($vorschlag 2 15)))
(Index 24  (($vorschlag 2 18)))
(Index 25  (($vorschlag 0  4)))
(Index 26  (($vorschlag 1  15)))
(Index 27  (($vorschlag 13 12)))
(Index 28  (($vorschlag  5 18)
                                  ($vorschlag  6 18) ))
(Index 29  (($kontextbezogen 3 0)
                                  ($kontextbezogen 3 5)
                                  ($kontextbezogen 3 6)))
(Index 30  (($abdichten 7 0)))
(Index 31  (($fest-verbinden 5 0)))
(Index 32  (($verbinden      5 3)
                                  ($verbinden      5 1)
                                  ($verbinden      7 3)
                                  ($verbinden      7 1)))
(Index 33  (($verbinden 1 0)
                                  ($verbinden 6 0)))
(Index 34  (($kontextbezogen 1 0)
                                  ($kontextbezogen 1 3)))
(Index 35  (($kontextbezogen 5 0)
                                  ($kontextbezogen 5 1)
                                  ($kontextbezogen 5 2)
                                  ($kontextbezogen 5 3)))
(Index 36  (($abdichten 7 0)
                                  ($kontextbezogen 0 5)
                                  ($kontextbezogen 0 8)))
(Index 37  (($kontextbezogen 0 7)
                                  ($kontextbezogen 0 9)
                                  ($kontextbezogen 0 18)))

(Index 38 nil)

(Index 39  (($kontextbezogen 7 0)))
(Index 40  (($kontextbezogen 5 7)
                                  ($kontextbezogen 5 19)))
(Index 41  (($kontextbezogen 3 0)
                                  ($kontextbezogen 3 1)
                                  ($kontextbezogen 3 2)
                                  ($kontextbezogen 3 4)))
(Index 42  (($kontextbezogen 0 1)
                                  ($kontextbezogen 0 3)
                                  ($kontextbezogen 0 5)))
(Index 43  (($kontextbezogen 0 1)
                                  ($kontextbezogen 0 3)))
(Index 44  (($abdichten 7 0)
                                  ($abdichten 23 0)))
(Index 45  (($abdichten 18 5)))
(Index 46  (($formzug   11 3)))
(Index 47  (($abdichten 0 3)
                                  ($kontextbezogen 3 0)
                                  ($kontextbezogen 3 11)))
(Index 48  (($formzug  12 2)))
(Index 49  (($kontextbezogen 0 1)
                                  ($kontextbezogen 0 3)
                                  ($kontextbezogen 0 11)))
(Index 50  (($kontextbezogen 1 0)
                                  ($kontextbezogen 1 3)
                                  ($kontextbezogen 1 8)))
(Index 51  (($kontextbezogen 0 2)
                                  ($kontextbezogen 0 3)
                                  ($kontextbezogen 0 5)
                                  ($kontextbezogen 0 8)
                                  ($schneiden      3 0)
                                  ($schneiden      8 0)))
(Index 52  (($kontextbezogen 7 0)
                                  ($kontextbezogen 7 22)))
(Index 53  (($kontextbezogen 1 0)
                                  ($kontextbezogen 1 2)
                                  ($kontextbezogen 1 3)
                                  ($kontextbezogen 1 11)))
(Index 54  (($abdichten 10 1)))
(Index 55  (($vorschlag 7 10)
                                  ($kontextbezogen 7 19)
                                  ($kontextbezogen 7 25)))
(Index 56  (($schneiden 1 0)))
(Index 57  (($schneiden 4 14)
                                  ($schneiden 4 15)))
(Index 58  (($verbinden 2 0)
                                  ($verbinden 2 1)
                                  ($verbinden 7 0)
                                  ($verbinden 7 1)))
(Index 59  (($kontextbezogen 0 7)
                                  ($kontextbezogen 0 8)))
(Index 60  (($feinde 0 2)
                                  ($feinde 2 0)))
(Index 61  (($verbinden 3 0)
                                  ($verbinden 7 0)
                                  ($abdichten 1 0)))
(Index 62  (($abdichten 8 1)))
(Index 63  (($abdichten 7 3)))
(Index 64  (($schnitt-drohen 3 0)
                                  ($schnitt-drohen 8 0)))
(Index 65  (($verbinden 3 0)))
(Index 66  (($verbinden 4 2)
                                  ($verbinden 11 2)
                                  ($abdichten 13 2)))
(Index 67  (($verbinden 2 0)))
(Index 68  (($verbinden 2 0)))
(Index 69  (($kontextbezogen 8 6)
                                  ($kontextbezogen 8 9)
                                  ($kontextbezogen 8 23)))
(Index 70  (($kontextbezogen 1 8)
                                  ($kontextbezogen 1 11)
                                  ($kontextbezogen 2  8)
                                  ($kontextbezogen 2 11)))
(Index 71  (($vorschlag 46 15)
                                  ($vorschlag 47 15)
                                  ($vorschlag 51 15)
                                  ($kontextbezogen 51 52)
                                  ($kontextbezogen 51  9)
                                  ($kontextbezogen 47 52)
                                  ($kontextbezogen 47  9)))
(Index 72  (($kontextbezogen 47 9)
                                  ($fluchtsprung 9 25)))
(Index 73  (($abdichten 7 0)))
(Index 74  (($kontextbezogen 0 1)))
(Index 75  (($fluchtsprung 5 1)))
(Index 76  (($kontextbezogen 1 6)
                                  ($kontextbezogen 1 27)))
(Index 77  (($schneiden 0 3)
                                  ($schneiden 2 3)))
(Index 78  (($kontextbezogen 27 8)
                                  ($kontextbezogen 27 26)))
(Index 79  (($kontextbezogen 1 0)
                                  ($kontextbezogen 1 3)))
(Index 80  (($kontextbezogen 14 2)
                                  ($kontextbezogen 14 3)))
(Index 81  (($abdichten 5 0)
                                  ($abdichten 7 0)))
(Index 82  (($kontextbezogen 13 2)
                                  ($kontextbezogen 13 11)
                                  ($kontextbezogen 13 9)))
(Index 83  (($kontextbezogen 26 1)
                                  ($kontextbezogen 26 27)
                                  ($kontextbezogen 26 28)
                                  ($kontextbezogen 26 52)))
(Index 84  (($abdichten 5 0)
                                  ($abdichten 7 0)
                                  ($abdichten 8 0)))
(Index 85  (($abdichten 5 0)
                                  ($abdichten 7 0)))
(Index 86  (($fluchtsprung 10 0)))
(Index 87  (($kontextbezogen 0 1)
                                  ($kontextbezogen 0 2)))
(Index 88  (($verbinden 4 2)
                                  ($verbinden 11 2)))
(Index 89  (($verbinden 12 14)
                                  ($verbinden 16 14)
                                  ($abdichten 16 4)
                                  ($abdichten 17 4)))
(Index 90  (($fluchtsprung 17 1)))
(Index 91  (($abdichten  7 0)
                                  ($abdichten  8 0)))
(Index 92  (($abdichten 3 1)
                                  ($abdichten 3 7)))
(Index 93  (($kontextbezogen 0 8)
                                  ($kontextbezogen 0 11)
                                  ($kontextbezogen 0 21)
                                  ($abdichten      8 0)))
(Index 94  (($abdichten 0  2)
                                  ($abdichten 9  2)
                                  ($abdichten 12 2)))
(Index 95  (($invasion-verhindern 14)
                                  ($invasion-verhindern 33)))
(Index 96  (($invasion-verhindern 33)))
(Index 111  (($vorschlag 14 18)))
(Index 112  (($vorschlag 28 20)))
(Index 115  (($formzug 6 3)))
(Index 142  (($verbinden  5 0)
                                   ($verbinden 10 0)
                                   ($abdichten  5 0)
                                   ($abdichten 10 0)
                                   ($abdichten  6 0)))
(Index 143  (($schneiden  5 0)
                                   ($schneiden 10 0)))
(Index 148  (
                                   ($abdichten 10 3)
                                   ($abdichten 13 3)
                                   ($abdichten 14 3)
                                  ))
(Index 149  (
                                   ($schneiden  5 0)
                                   ($schneiden 10 0)
                                  ))
(Index 150  (
                                   ($abdichten  5 0)
                                   ($verbinden  5 0)
                                   ($abdichten 10 0)
                                   ($verbinden 10 0)
                                   ($abdichten  7 0)
                                  ))
(Index 151  (
                                   ($kontextbezogen 13 1)
                                   ($kontextbezogen 13 10)
                                  ))
(Index 152  (
                                   ($hane 1 0)
                                   ($hane 2 0)
                                  ))
(Index 153  (
                                   ($hane 0 7)
                                   ($hane 1 7)
                                  ))
(Index 154  (
                                   ($feinde 3 7)
                                   ($feinde 7 3)
                                  ))
(Index 155  (
                                   ($feinde 2 5)
                                   ($feinde 5 2)
                                   ($kontextbezogen 1 2)
                                   ($kontextbezogen 1 5)
                                  ))
(Index 156  (
                                   ($kontextbezogen 1 2)
                                   ($kontextbezogen 1 4)
                                   ($kontextbezogen 1 11)
                                   ($kontextbezogen 1 13)
                                  ))
(Index 157  (
                                   ($abdichten      9 1)
                                   ($abdichten     12 1)
                                   ($abdichten     14 1)
                                  ))
(Index 158  (
                                   ($abdichten     10 0)
                                   ($abdichten     10 1)
                                   ($abdichten     10 3)
                                   ($abdichten     13 0)
                                   ($abdichten     13 1)
                                   ($abdichten     13 3)
                                  ))
(Index 159  (
                                   ($abdichten     10 0)
                                   ($abdichten     10 1)
                                   ($abdichten     10 3)
                                   ($abdichten     12 0)
                                   ($abdichten     12 1)
                                   ($abdichten     12 3)
                                  ))
(Index 160  (
                                   ($abdichten     11 2)
                                   ($abdichten     13 2)
                                  ))
(Index 161  (
                                   ($abdichten      8 1)
                                   ($abdichten     10 1)
                                   ($abdichten     13 1)
                                  ))
(Index 162  (
                                   ($abdichten     1 11)
                                  ))
(Index 163  (
                                   ($abdichten     2 1)
                                  ))
(Index 164  (
                                   ($kontextbezogen 2 0)
                                   ($kontextbezogen 2 1)
                                   ($kontextbezogen 2 3)
                                  ))
(Index 165  (
                                   ($kontextbezogen 2 0)
                                   ($kontextbezogen 2 1)
                                   ($kontextbezogen 2 3)
                                  ))
(Index 166  (
                                   ($verbinden      1 0)
                                   ($verbinden      7 0)
                                  ))
(Index 169  (
                                   ($abdichten      2 0)
                                   ($verbinden      3 0)
                                   ($verbinden      8 0)
                                  ))
(Index 170  (
                                   ($abdichten      1 3)
                                   ($verbinden     12 3)
                                   ($verbinden     14 3)
                                  ))
(Index 171  (
                                   ($formzug        2 0)
                                   ($formzug       14 0)
                                  ))
(Index 172  (
                                   ($fluchtsprung   5 1)
                                  ))
(Index 173  (
             ($kontextbezogen 2 1)
             ($formzug        5 2)
             ($formzug       15 2)
            ))
(Index 174  (
                                   ($abdichten 10 8)
                                   ($abdichten 23 8)
                                   ($formzug   24 8)
                                   ($verbinden 24 8)
                                   ($verbinden 10 8)
                                  ))
(Index 175  (
                                   ($verbinden  9 0)
                                   ($verbinden 18 0)
                                  ))
(Index 176  (
                                   ($vorschlag 13 16)
                                  ))
(Index 177  (
                                   ($vorschlag 27 16)
                                   ($vorschlag 28 16)
                                  ))
(Index 178  (
                                   ($kontextbezogen 2  0)
                                   ($vorschlag      2 16)
                                  ))
(Index 179  (
                                   ($kontextbezogen  8  0)
                                   ($kontextbezogen  8 13)
                                   ($kontextbezogen  8 22)
                                  ))

(Index 186  (
                                   ($abdichten      23 8)
                                  ))
(Index 187  (
                                   ($formzug        10 8)
                                   ($verbinden      10 8)
                                   ($verbinden      13 8)
                                  ))
(Index 188  (
                                   ($verbinden       3 0)
                                   ($verbinden       5 0)
                                  ))
(Index 189  (
                                   ($schneiden       3 0)
                                   ($schneiden       5 0)
                                  ))
(Index 190  (
                                   ($kontextbezogen  1 0)
                                  ))
(Index 191  (
                                   ($vorschlag      32 15)
                                  ))
(Index 192  (
                                   ($vorschlag      12 15)
                                   ($vorschlag      13 15)
                                  ))
(Index 193  (
                                   ($dreivier        9 2)
                                  ))
(Index 194  (
                                   ($schneiden       8 1)
                                   ($schneiden      14 1)
                                  ))
(Index 195  (
                                   ($formzug         8 3)
                                  ))
(Index 196  (
                                   ($schneiden       3 0)
                                   ($schneiden       7 0)
                                  ))
(Index 197  (
                                   ($schneiden       3 0)
                                   ($schneiden       8 0)
                                  ))
(Index 198  (
                                   ($schneiden       2 0)
                                   ($schneiden       8 0)
                                  ))
(Index 199  (
                                   ($verbinden       2 0)
                                   ($verbinden       4 0)
                                   ($verbinden       6 0)
                                  ))
(Index 200  (
                                   ($fest-verbinden  1 7)
                                   ($fest-verbinden  6 7)
                                   ($verbinden       1 5)
                                   ($verbinden       6 5)
                                  ))
(Index 205  (
                                   ($fluchtsprung   4 1)
                                   ($fluchtsprung   6 1)
                                  ))
(Index 206  (
                                   ($formzug       12 0)
                                  ))
(Index 207  (
                                   ($formzug       10 8)
                                   ($formzug       24 8)
                                   ($abdichten     10 8)
                                   ($abdichten     24 8)
                                   ($abdichten     23 8)
                                  ))
(Index 208  (
                                   ($formzug       10 8)
                                   ($formzug       24 8)
                                   ($abdichten     10 8)
                                   ($abdichten     24 8)
                                   ($abdichten     23 8)
                                  ))
(Index 215  (
                                   ($formzug        1 10)
                                  ))
(Index 220  (
                                   ($abdichten      9 8)
                                   ($abdichten     23 8)
                                  ))
(Index 225  (
                                   ($abdichten      2 1)
                                   ($abdichten      8 1)
                                   ($abdichten      9 1)
                                  ))
(Index 226  (
                                   ($formzug       10 5)
                                  ))
(Index 228  (
                                   ($schnitt-drohen 3 5)
                                   ($schnitt-drohen 6 5)
                                  ))
(Index 229  (
                                   ($kontextbezogen 4 13)
                                   ($kontextbezogen 4 15)
                                  ))
(Index 230  (
                                   ($kontextbezogen 1  4)
                                   ($kontextbezogen 1 13)
                                  ))
(Index 231  (
                                   ($formzug       12  9)
                                  ))
(Index 232  (
                                   ($formzug       19 15)
                                   ($formzug       21 15)
                                  ))
(Index 235  (
                                   ($verbinden      4  3)
                                   ($verbinden     10  3)
                                  ))
(Index 238  (
                                   ($schneiden      4  1)
                                   ($schneiden     10  1)
                                  ))
(Index 241  (
                                   ($kontextbezogen 9  1)
                                   ($kontextbezogen 9  8)
                                   ($kontextbezogen 9 10)
                                  ))
(Index 242  (
                                   ($kontextbezogen 5  0)
                                   ($kontextbezogen 5  3)
                                   ($kontextbezogen 5  4)
                                  ))
(Index 243  (
                                   ($schneiden      2  0)
                                   ($schneiden      7  0)
                                  ))
(Index 244  (
                                   ($formzug        8  5)
                                  ))
(Index 247  (
                                   ($verbinden      5  1)
                                   ($verbinden      9  1)
                                  ))
(Index 249  (
                                   ($schnitt-drohen 4  0)
                                   ($schnitt-drohen 6  0)
                                  ))
(Index 254  (
                                   ($verbinden      2  0)
                                   ($verbinden      4  0)
                                   ($verbinden      8  0)
                                   ($abdichten      2  0)
                                   ($abdichten      4  0)
                                   ($abdichten      8  0)
                                   ($abdichten      7  0)
                                  ))
(Index 255  (
                                   ($formzug        8  0)
                                  ))
(Index 258  (
                                   ($abdichten      0  1)
                                  ))
(Index 259  (
                                   ($schneiden      4  2)
                                   ($schneiden     11  2)
                                  ))
(Index 260  (
                                   ($formzug        2  0)
                                   ($formzug        8  0)
                                  ))
(Index 261  (
                                   ($formzug        2  0)
                                   ($formzug        8  0)
                                  ))
(Index 262  (
                                   ($verbinden      1  0)
                                  ))
(Index 269  (
                                   ($formzug        0  5)
                                  ))
(Index 270  (
                                   ($schneiden      1  2)
                                  ))
(Index 277  (
                                   ($kontextbezogen 4  2)
                                   ($kontextbezogen 4 12)
                                   ($kontextbezogen 4 13)
                                   ($kontextbezogen 4 15)
                                  ))
(Index 280  (
                                   ($verbinden  4 1)
                                   ($verbinden 10 1)
                                   ($abdichten  2 1)
                                   ($abdichten  4 1)
                                   ($abdichten 10 1)
                                  ))
(Index 281  (
                                   ($schneiden  0 3)
                                   ($schneiden  2 3)
                                  ))
(Index 282  (
                                   ($formzug    6 1)
                                  ))
(Index 283  (
                                   ($hane    2 1)
                                   ($hane    3 1)
                                  ))
(Index 284  (
                                   ($abdichten 10 2)
                                   ($abdichten 13 2)
                                  ))
(Index 285  (
                                   ($formzug    9 1)
                                   ($abdichten  9 1)
                                   ($abdichten 11 1)
                                  ))
(Index 292  (
                                   ($schnitt-drohen 2 1)
                                   ($schnitt-drohen 8 1)
                                  ))
(Index 293  (
                                   ($formzug        5 3)
                                   ($formzug        7 3)
                                  ))
(Index 294  (
                                   ($abdichten      6 0)
                                   ($abdichten      7 0)
                                   ($abdichten     17 0)
                                  ))
(Index 295  (
                                   ($abdichten      2 1)
                                   ($abdichten      7 1)
                                   ($abdichten      8 1)
                                  ))
(Index 296  (
                                   ($formzug        2 4)
                                   ($formzug       22 4)
                                  ))
(Index 298  (
                                   ($abdichten      8 1)
                                   ($abdichten     10 1)
                                  ))
(Index 299  (
                                   ($formzug        0 2)
                                   ($formzug        4 2)
                                  ))
(Index 300  (
                                   ($verbinden      1 3)
                                   ($verbinden      5 3)
                                  ))
(Index 304  (
                                   ($kontextbezogen 0 2)
                                   ($kontextbezogen 0 7)
                                   ($kontextbezogen 0 8)
                                  ))
(Index 305  (
                                   ($fluchtsprung   9 0)
                                   ($fluchtsprung  11 0)
                                   ($fluchtsprung   9 5)
                                   ($fluchtsprung  11 5)
                                  ))
(Index 308  (
                                   ($formzug        4 0)
                                   ($formzug        6 0)
                                  ))
(Index 309  (
                                   ($fluchtsprung   6 0)
                                   ($fluchtsprung  18 0)
                                  ))
(Index 310  (
                                   ($schnitt-drohen  3 2)
                                   ($schnitt-drohen 12 2)
                                  ))
(Index 311  (
                                   ($kontextbezogen 14  2)
                                   ($kontextbezogen 14  3)
                                   ($kontextbezogen 14 12)
                                  ))
(Index 312  (
                                   ($formzug         4  1)
                                   ($formzug         6  1)
                                  ))
(Index 314  (
                                   ($kontextbezogen  2  1)
                                   ($kontextbezogen  2  9)
                                   ($kontextbezogen  2 10)
                                   ($kontextbezogen  2 12)
                                  ))
(Index 315  (
                                   ($kontextbezogen  5  0)
                                   ($kontextbezogen  5  3)
                                   ($kontextbezogen  5  7)
                                   ($kontextbezogen  5  8)
                                  ))
(Index 316  (
                                   ($kontextbezogen  6  0)
                                   ($kontextbezogen  6  7)
                                   ($kontextbezogen  6 22)
                                   ($kontextbezogen  6 23)
                                  ))
(Index 317  (
                                   ($abdichten      21  6)
                                   ($abdichten      22  6)
                                  ))
(Index 318  (
                                   ($abdichten      21  6)
                                   ($abdichten      22  6)
                                  ))
(Index 320  (
                                   ($schnitt-drohen  2  1)
                                   ($schnitt-drohen  7  1)
                                  ))
(Index 321  (
                                   ($formzug         6  8)
                                   ($formzug        22  8)
                                   ($formzug        25  8)
                                  ))
(Index 322  (
             ($schneiden       6  1)
             ($schneiden      11  1)
            ))
(Index 323  (
             ($lebensvorhand   4  2)
             ($lebensvorhand  14  2)
            ))
(Index 324  (
             ($schneiden       1  0)
             ($schneiden       4  0)
             ($verbinden       3  0)
             ($verbinden       8  0)
            ))
(Index 325  (
             ($schneiden       4  0)
             ($schneiden       7  0)
             ($schnitt-drohen  4  5)
             ($schnitt-drohen  7  5)
            ))
(Index 326  (
             ($verbinden       2  0)
             ($verbinden       2  1)
             ($verbinden       2  3)
             ($verbinden       4  0)
             ($verbinden       4  1)
             ($verbinden       4  3)
            ))
(Index 327  (
             ($verbinden       4  3)
             ($verbinden      11  3)
             ($abdichten      14  3)
            ))
(Index 328  (
             ($hane           11  2)
             ($hane           13  2)
            ))
(Index 331  (
             ($lebensvorhand   1  3)
            ))
;...............................................................................
;-------------------------------------------------------------------------------
; Als erster ein Eck besetzen
;-------------------------------------------------------------------------------
(defun $eck-besetzen (Vorschlag Musterort Orientierung)
  (let ((x (!transkoord Musterort Vorschlag Orientierung)))
     (if (not (member x Muster-Eckzuege))
         (setq Muster-Eckzuege (cons x Muster-Eckzuege))
     )
  )
)

;-------------------------------------------------------------------------------
; Einen Sicherungszug machen, um eine Invasion zu verhindern
;-------------------------------------------------------------------------------
(defun $invasion-verhindern (Vorschlag Musterort Orientierung)
  (let ((x (!transkoord Musterort Vorschlag Orientierung)))
     (if (not (member x Muster-Invasion-Verhindern))
         (setq Muster-Invasion-Verhindern (cons x Muster-Invasion-Verhindern))
     )
  )
)

;-------------------------------------------------------------------------------
; Einen Stein auf der 3. oder 4. Reihe plazieren
;-------------------------------------------------------------------------------
(defun $rand-besetzen (Vorschlag Musterort Orientierung)
  (let ((x (!transkoord Musterort Vorschlag Orientierung)))
     (if (not (member x Muster-Randzuege))
         (setq Muster-Randzuege (cons x Muster-Randzuege))
     )
  )
)

;-------------------------------------------------------------------------------
; Einer Gruppe eine Lebensbasis geben
;-------------------------------------------------------------------------------
(defun $basiszug (Kette Zug Musterort Orientierung)
   (setq Muster-Basiszuege
         (cons (list (!name (!transkoord Musterort Kette Orientierung))
                     (!transkoord Musterort Zug Orientierung)
               )
               Muster-Basiszuege
         )
   )
)

;-------------------------------------------------------------------------------
; Assoziationsliste ((Zug Wert)) fuer lokale Optimalitaet
;-------------------------------------------------------------------------------
(defun $lokal-optimal (Vorschlag Musterort Orientierung)
   (let ((x (!transkoord Musterort Vorschlag Orientierung)))
      (if (assoc x Muster-lokal-optimal)
          (dolist (temp Muster-lokal-optimal nil)
             (if (eql (car temp) x)
                 (rplaca (cdr temp) (+ (cadr temp) 1))
             )
          )
          (setq muster-lokal-optimal (cons (list x 1) muster-lokal-optimal))
      )
   )
)



;-------------------------------------------------------------------------------
; Ein Zugvorschlag, der mit einem Punktewert assoziiert ist
;-------------------------------------------------------------------------------
(defun $vorschlag (Stein1 Wert Musterort Orientierung)
   (setq Muster-Vorschlaege
         (cons (list (!transkoord Musterort Stein1 Orientierung) wert)
               Muster-Vorschlaege
         )
   )
)

;-------------------------------------------------------------------------------
; Ein Zug, dessen Wert vom Wert des Kontextes abhaengt
;-------------------------------------------------------------------------------
(defun $kontextbezogen (Zug Kette Musterort Orientierung)
   (setq Muster-Kontextbezogen
         (cons (list (!transkoord Musterort Zug   Orientierung)
                     (!name (!transkoord Musterort Kette Orientierung))
               )
               Muster-Kontextbezogen
         )
   )
)


;-------------------------------------------------------------------------------
; Eine gegnerische Gruppe einschliessen oder deren Eindringen verhindern
;-------------------------------------------------------------------------------
(defun $abdichten (Kette Zug Musterort Orientierung)
   (setq Muster-Abdichten
         (cons (list (!name (!transkoord Musterort Kette Orientierung))
                     (!transkoord Musterort Zug Orientierung)
               )
               Muster-Abdichten
         )
   )
)

;-------------------------------------------------------------------------------
; Einen Keima-Angriff von der 3. Reihe auf einen Stein der 4. Reihe machen
;-------------------------------------------------------------------------------
(defun $dreivier (Kette Zug Musterort Orientierung)
   (setq Muster-DreiVier
         (cons (list (!name (!transkoord Musterort Kette Orientierung))
                     (!transkoord Musterort Zug Orientierung)
               )
               Muster-DreiVier
         )
   )
)

;-------------------------------------------------------------------------------
; Eine Kette durch einen Sprung nach "aussen" sichern
;-------------------------------------------------------------------------------
(defun $fluchtsprung (Kette Zug Musterort Orientierung)
   (setq Muster-Fluchtsprung
         (cons (list (!name (!transkoord Musterort Kette Orientierung))
                     (!transkoord Musterort Zug Orientierung)
               )
               Muster-Fluchtsprung
         )
   )
)


;-------------------------------------------------------------------------------
; Eine gegnerische Gruppe von einer anderen abschneiden
;-------------------------------------------------------------------------------
(defun $schneiden (Kette Zug Musterort Orientierung)
   (setq Muster-Schneiden
         (cons (list (!name (!transkoord Musterort Kette Orientierung))
                     (!transkoord Musterort Zug Orientierung)
               )
               Muster-Schneiden
         )
   )
)


;-------------------------------------------------------------------------------
; Einen Schnitt einer gegnerischen Kette androhen
;-------------------------------------------------------------------------------
(defun $schnitt-drohen (Kette Zug Musterort Orientierung)
   (setq Muster-Schnitt-drohen
         (cons (list (!name (!transkoord Musterort Kette Orientierung))
                     (!transkoord Musterort Zug Orientierung)
               )
               Muster-Schnitt-drohen
         )
   )
)


;-------------------------------------------------------------------------------
; Eine Kette durch einen Formzug staerken
;-------------------------------------------------------------------------------
(defun $formzug (Kette Zug Musterort Orientierung)
   (setq Muster-Formzug
         (cons (list (!name (!transkoord Musterort Kette Orientierung))
                     (!transkoord Musterort Zug Orientierung)
               )
               Muster-Formzug
         )
   )
)


;-------------------------------------------------------------------------------
; Eine Kette an eine andere fest anbinden
;-------------------------------------------------------------------------------
(defun $fest-verbinden (Kette Zug Musterort Orientierung)
   (setq Muster-fest-verbinden
         (cons (list (!name (!transkoord Musterort Kette Orientierung))
                     (!transkoord Musterort Zug Orientierung)
               )
               Muster-fest-verbinden
         )
   )
)

;-------------------------------------------------------------------------------
; Eine Kette an eine andere binden
;-------------------------------------------------------------------------------
(defun $verbinden (Kette Zug Musterort Orientierung)
   (setq Muster-verbinden
         (cons (list (!name (!transkoord Musterort Kette Orientierung))
                     (!transkoord Musterort Zug Orientierung)
               )
               Muster-verbinden
         )
   )
)


;-------------------------------------------------------------------------------
; Einen Zug machen, der einigermaen droht, eine Gruppe lebendig zu machen
;-------------------------------------------------------------------------------
(defun $lebensvorhand (Kette Zug Musterort Orientierung)
   (setq Muster-Lebensvorhand
         (cons (list (!name (!transkoord Musterort Kette Orientierung))
                     (!transkoord Musterort Zug Orientierung)
               )
               Muster-Lebensvorhand
         )
   )
)




(defun $feinde (Stein1 Stein2 Musterort Orientierung)
   (let ((temp1 (!transkoord Musterort Stein1 Orientierung))
         (temp2 (!transkoord Musterort Stein2 Orientierung)))

        (let ((temp3 (list (!name temp1) (!name temp2))))
           (if (not (member temp3 muster-feinde))
               (setq muster-feinde (cons temp3 muster-feinde))
           )
        )
        (if (< (memavail) 10000)
            (progn (sound 500) (delay 300) (garbage-collection) (nosound))
        )
   )
)

(defun $shimari (Stein1 Ausdehnung Musterort Orientierung)
   (setq Muster-Shimaris
         (cons (cons (!transkoord Musterort Stein1 Orientierung)
                     (cons (!transkoord Musterort Ausdehnung Orientierung) nil))
               Muster-Shimaris
         )
   )
)


(defun $ecktripel (Vorschlag Musterort Orientierung)
  (let ((x (!transkoord Musterort Vorschlag Orientierung)))
     (if (not (member x Muster-Ecktripel))
         (setq Muster-Ecktripel (cons x Muster-Ecktripel))
     )
  )
)




;-------------------------------------------------------------------------------
; Einen Hane-Zug gegen eine gegnerische Kette machen. Von Weiss und Schwarz aus
;-------------------------------------------------------------------------------
(defun $hane (Kette Zug Musterort Orientierung)
   (setq Muster-Hane
         (cons (list (!name (!transkoord Musterort Kette Orientierung))
                     (!transkoord Musterort Zug Orientierung)
               )
               Muster-Hane
         )
   )
)


