;-------------------------------------------------------------------------------
; Dieses File dient dazu, die Ketten zu klassifizieren, d.h. den Status bzgl.
; Lebendigkeit, Freiheitswert etc. festzustellen.
;-------------------------------------------------------------------------------



;-------------------------------------------------------------------------------
; Folgende Liste besteht aus Zuordnungen zwischen Steine-Leer-Paaren und
; Einschaetzungen der Staerke der Kette
;-------------------------------------------------------------------------------
(setq erfahrungswerte
   '(
      (( 1  3) sehr-schwach)
      (( 1 24) sehr-stark  )
      (( 2 24) schwach     )
      (( 3 14) schwach     )
      (( 4  5) sehr-schwach)
      (( 5 28) sehr-stark  )
      (( 8 24) sehr-stark  )
      ((16 16) stark       )
      ((22  8) stark       )
    )
)


;-------------------------------------------------------------------------------
; Die Anzahl d. eigenen Steine und der leeren Punkte innerhalb einer Kette holen
;-------------------------------------------------------------------------------
(defun Steine-Leer (x)
   (let (temp (steine 0) (leer 0))
      (if (eql (!color x) 1)
          (setq temp (!connected x (!black-territory)))
          (setq temp (!connected x (!white-territory)))
      )
      (dolist (y temp (list steine leer))
         (if (eql (!color y) 0)
             (setq leer   (1+ leer  ))
             (setq steine (1+ steine))
         )
      )
   )
)




;-------------------------------------------------------------------------------
; Die Staerke einer Gruppe bestimmen
;-------------------------------------------------------------------------------
(defun staerke (x)
   (let (temp minimum)
      (setq temp (Steine-leer x))
      (setq minimum (car erfahrungswerte))
      (dolist (y (cdr erfahrungswerte) (cadr minimum))
         (if (< (abstand temp (car y)) (abstand temp (car minimum)))
             (setq minimum y)
         )
      )
   )
)



;-------------------------------------------------------------------------------
; Ein Abstandsmass fuer Paare von Stein/Leer-Paaren
;-------------------------------------------------------------------------------
(defun abstand (v1 v2)
   (+ (sqr (- (car  v1) (car  v2)))
      (sqr (- (cadr v1) (cadr v2)))
   )
)
