/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 titlescreen.sc
 Contains the title screen room.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script TITLESCREEN_SCRIPT)
/******************************************************************************/
(use "main")
(use "game")
(use "menubar")
(use "obj")
(use "cycle")
(use "user")
(use "controls")
(use "feature")
(use "wander")
/******************************************************************************/
(instance public TitleScreen of Rm
	(properties
		picture scriptNumber
	)
	(method (init)
        // Set up the title screen
		ProgramControl() 
		= gProgramControl FALSE
		(send gGame:setSpeed(1))
		(SL:disable())
		(TheMenuBar:hide())
		
		(super:init())
		(self:setScript(RoomScript))
		
		(send gEgo:
			init()
			hide()
		)
		

	    (snowflake:init())
        //(snowflake:setCycle(Fwd))
        (snowflake:loop(-1))
		(snowflake:setCycle(Walk))
		(snowflake:setMotion(MoveTo 20 202))

  
        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)       */

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
		Display(
			"A short tale of Christmas survival."
			dsCOORD 95 155
			dsCOLOUR clMAROON
			dsBACKGROUND clTRANSPARENT
		)
	    Display(
			"By Gumby"
			dsCOORD 140 170
			dsCOLOUR clGREEN
			dsBACKGROUND clTRANSPARENT
		)
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)     /*
    (method (changeState newState)
        = state newState
        /************************************
         * Add the state related stuff here *
         ************************************/
    //)
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))
        (if( not (send pEvent:claimed) )
			(if( (== (send pEvent:type) evKEYBOARD) and (== (send pEvent:message) $3C00) )
				ToggleSound()
			)(else
                /******************************************
                 * If the title screen has music, fade it *
                 ******************************************/
				//(send gTheMusic:fade())
    
                // End the title screen, start the game
				(send gRoom:newRoom(INITROOMS_SCRIPT))
		    )
		)
	)
)
/******************************************************************************/
(instance snowflake of Act (properties y 0 x 320 view 9))