/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import net.argius.stew.Logger;

final class ClipboardHelper {
    private static final Logger log = Logger.getLogger(ClipboardHelper.class);

    private ClipboardHelper() {
    }

    static String getString() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Object object = clipboard.getData(DataFlavor.stringFlavor);
            if (log.isTraceEnabled()) {
                log.trace("received from clipboard: [%s]", object);
            }
            return (String)object;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            throw new RuntimeException("at ClipboardHelper.getString", unsupportedFlavorException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("at ClipboardHelper.getString", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setStrings(Iterable<String> iterable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            for (String string : iterable) {
                printWriter.println(string);
            }
        }
        finally {
            printWriter.close();
        }
        ClipboardHelper.setString(stringWriter.toString().replaceFirst("[\\r\\n]+$", ""));
    }

    static void setString(String string) {
        if (log.isTraceEnabled()) {
            log.trace("sending to clipboard: [%s]", (Object)string);
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, stringSelection);
    }

    static Reader getReaderForText() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        try {
            return DataFlavor.stringFlavor.getReaderForText(transferable);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            throw new RuntimeException("at ClipboardHelper.getReaderForText", unsupportedFlavorException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("at ClipboardHelper.getReaderForText", iOException);
        }
    }
}

