/*
HMBlkComboBoxCell.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

static NSImage* _blkComboBoxBack = nil;
static NSSize   _blkComboBoxBackSize;

#import "HMBlkComboBoxCell.h"

@implementation HMBlkComboBoxCell

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (id)initTextCell:(NSString*)string
{
    self = [super initTextCell:string];
    if (!self) {
        return nil;
    }
    
    // Load image
    if (!_blkComboBoxBack) {
        NSBundle*   bundle;
        bundle = [NSBundle bundleForClass:[self class]];
        
        _blkComboBoxBack = [[NSImage alloc] initWithContentsOfFile:
                [bundle pathForImageResource:@"blkTextFieldBack"]];
        _blkComboBoxBackSize = [_blkComboBoxBack size];
    }
    
    // Configure itself
    [self setTextColor:[NSColor whiteColor]];
    [self setBordered:NO];
    [self setBezeled:NO];
    
    return self;
}

- (void)popUp:(id)sender
{
    // Do nothing
}

//--------------------------------------------------------------//
#pragma mark -- Appearance --
//--------------------------------------------------------------//

- (float)_buttonWidth
{
    return 0.0f;
}

- (NSRect)boundsForButtonCell:(NSRect)cellFrame
{
    return NSMakeRect(cellFrame.origin.x + cellFrame.size.width, 0, 0, 0);
}

- (NSRect)boundsForTextCell:(NSRect)cellFrame
{
    return cellFrame;
}

//--------------------------------------------------------------//
#pragma mark -- Text attributes --
//--------------------------------------------------------------//

- (NSText*)setUpFieldEditorAttributes:(NSText*)textObj
{
    textObj = [super setUpFieldEditorAttributes:textObj];
    
    // Set insertion color
    [(NSTextView*)textObj setInsertionPointColor:[NSColor whiteColor]];
    
    return textObj;
}

//--------------------------------------------------------------//
#pragma mark -- Drawing --
//--------------------------------------------------------------//

- (NSFocusRingType)focusRingType
{
    return NSFocusRingTypeNone;
}

- (void)_drawThemeBezelWithFrame:(NSRect)cellFrame inView:(NSView*)controlView
{
    NSColor*    gridColor;
    gridColor = [NSColor colorWithCalibratedWhite:0.38f alpha:1.0f];
    
    [gridColor set];
    NSFrameRect(cellFrame);
}

- (void)drawWithFrame:(NSRect)cellFrame inView:(NSView *)controlView
{
    // Set draws background
    if ([self drawsBackground]) {
        [self setDrawsBackground:NO];
    }
    
    // Draw background
    NSRect  srcRect, destRect;
    srcRect.origin = NSZeroPoint;
    srcRect.size = _blkComboBoxBackSize;
    destRect = cellFrame;
    [_blkComboBoxBack drawInRect:destRect fromRect:srcRect 
            operation:NSCompositeSourceOver fraction:1.0f];
    
    // Invoke super
    [super drawWithFrame:cellFrame inView:controlView];
}

@end
