/*
SRBookmarksBarView.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

@class SRBookmark;

@interface SRBookmarksBarView : NSView
{
    NSMutableArray* _bookmarkButtons;
    int             _indicatorIndex;
    int             _dropAccpetFrolderIndex;
    SRBookmark*     _bookmarksBar;
    
    BOOL            _acceptDrag;
}

- (void)updateButtons;
- (void)updateButtonForURL:(NSString*)URLString;

- (void)setAcceptDrag:(BOOL)acceptDrag;

- (SRBookmark*)bookmarksBar;
- (void)setBookmarksBar:(SRBookmark*)bookmark;

- (void)addBookmark:(SRBookmark*)bookmark;
- (void)insertBookmark:(SRBookmark*)bookmark atIndex:(int)index;
- (void)removeBookmark:(SRBookmark*)bookmark;
- (void)removeAllBookmarks;

@end
