/*
  HTSRTabBarView.h
Author: Hetima Computer

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/
/*
ChangeLog
2004.05.04 Hetima Computer <>
	* tab style submenu

2004.04.26 Hetima Computer <>

2004.04.20 Hetima Computer <>
	* marge nightly 040419

2004.04.18 Hetima Computer <>
	* add drag and drop
	* add new Tab Button

2004.04.16-2 Hetima Computer <>
	* add "According To Title Width" feature
	* add NSProgressIndicator animation
	* remove NSMatrix

2004.04.16 Hetima Computer <>
	* initial release

@interface HTSRTabBarView : NSView
@interface HTSRTabBarMatrixCell : NSActionCell
@interface HTSRTabBarClippedPopUpBtn : NSPopUpButton
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

enum{
	track_normal=0,
	track_close_btn=1,
	track_drag=2,
	track_ROver_close_btn=3
};

enum {
	HTSRTab_SelectedMask			= 1 << 1,
	HTSRTab_LeftIsSelectedMask		= 1 << 2,
	HTSRTab_RightIsSelectedMask	= 1 << 3,

	HTSRTab_PositionLeftMask		= 1 << 4,
	HTSRTab_PositionMiddleMask		= 1 << 5,
	HTSRTab_PositionRightMask		= 1 << 6,
	HTSRTab_PositionSingleMask		= 1 << 7
};

@class SRTabView;

@interface HTSRTabBarView : NSView {
    int             _selectedCellIndex;
    int             _tabDefaultWidth;
    int             _tabMinWidth;
    int             _accordingMaxWidth;
    int             _trackingMode;
    int             _destIndex;
    NSPoint         _trackingStartPoint;
    NSMutableArray* _cells;
    NSMutableArray* _indicators;
    NSMutableArray* _srIndicators;
    SEL             _action;
    
    BOOL            _hasCloseButton;
    BOOL            _accordingToLabelWidth;
    
    NSColor*        _color;
    Class           _cellClass;
    NSPopUpButton*  _clippedPopUpBtn;
    NSButton*       _newTabBtn;
    
    SRTabView*      _parentTabView;
}

-(void)tabViewItemStartedLoading:(int)idx;
-(void)tabViewItemFinishedLoading:(int)idx;
-(void)tabViewItemEstimateChanged:(int)idx progress:(double)progress;
-(void)_updateIndicatorOfIndex:(int)idx active:(BOOL)active;

-(Class)cellClass;
-(void)setCellClass:(Class)aClass;
-(void)setCellClassWithName:(NSString*)className;

-(void)setParentTabView:(SRTabView*)parentTabView;

-(void)setTabDefaultWidth:(int)width;
-(void)setTabMinWidth:(int)width;

-(BOOL)hasCloseButton;
-(void)setHasCloseButton:(BOOL)flag;
-(BOOL)accordingToLabelWidth;
-(void)setAccordingToLabelWidth:(BOOL)flag;
-(NSColor*)color;
-(void)setColor:(NSColor*)aColor;


-(float)tabBarViewHeight;
-(float)leftMargin;
-(float)rightMargin;
- (int)indexOfCell:(id)cell;

//-(float)marginBottom;

- (void)changeTabStyle:(id)sender;
- (void)setAction:(SEL)action;
- (void)mouseDown:(NSEvent *)theEvent;

- (NSMenu *)_backgroundMenuForEvent:(NSEvent*)event;
- (NSMenu *)_menuForCell:(id)cell event:(NSEvent*)event;
+ (NSMenu*)_sharedTabStyleMenu;
- (NSMenu*)_tabStyleMenu;

//-(NSRect)_cellFrameForIndex:(int)idx
- (id)cellForPoint:(NSPoint)point cellFrame:(NSRectPointer)outFrame;
- (NSDragOperation)_myDraggingEnterdOrUpdated:(id <NSDraggingInfo>)info;

- (void)tabView:(NSTabView *)senderTabView didSelectTabViewItem:(NSTabViewItem *)tabViewItem;

-(void)_updateMatrixAndMenu;
-(float)_cellSpaceWidth;
-(NSRect)_cellSpaceRect;
@end

@protocol HTSRTabBarItemCellProtocol
+(NSString*)name;
+(float)cellHeight;
+(float)cellTopMargin;
+(float)cellBottomMargin;
+(float)displayWidthOfString:(NSString*)label;
-(void)drawWithFrame:(NSRect)cellFrame  inView:(NSView *)controlView;
//-(BOOL)myTrackMouse:(NSEvent *)theEvent inRect:(NSRect)cellFrame ofView:(HTSRTabBarView *)controlView point:(NSPoint)mousePt;
+(BOOL)canHaveCloseButton;
+(BOOL)canHaveIndicator;
//-(NSRect)closeBtnRectForFrame:(NSRect)cellFrame;
//-(NSRect)indicatorRectForFrame:(NSRect)cellFrame;
@end

extern NSImage* gHTTabBarGeneralCloseBtn;
extern NSImage* gHTTabBarGeneralClosePress;
extern NSImage* gHTTabBarGeneralCloseROver;
extern NSMutableParagraphStyle*	gTruncatingTailParagraphStyle;

@interface HTSRTabBarItemCell : NSCell
{
//	float   _width;
	NSRect  _frame;
	int		_tag;
	int		_tabState;
	BOOL	_isLoading;
	BOOL	_hasCloseButton;

	int		_trackingMode;
	BOOL	_trackingHilite;
	NSRect  _trackingRect;
	NSPoint _trackingStartPoint;

	NSTrackingRectTag   _closeBtnTrackingTag;
	NSColor*	_color;
	HTSRTabBarView* _keeperView;
}
+(NSString*)name;
+(BOOL)reverseEnumerateWhenDraw;
-(void)drawBackgroundRect:(NSRect)rect inView:(HTSRTabBarView *)controlView;  //should override
-(void)draw;
+(void)myDrawWindowBackgroundRect:(NSRect)rect inView:(NSView*)controlView; //utility
-(id)initWithKeeperView:(id)keeperView contentView:(id)webView;

- (int)tag;
- (void)setTag:(int)anInt;
-(BOOL)isLoading;
-(void)setIsLoading:(BOOL)flag;
-(NSTrackingRectTag)closeBtnTrackingTag;
-(void)setCloseBtnTrackingTag:(NSTrackingRectTag)tag;

-(int)tabState;
-(void)setTabState:(int)state;
-(float)width;
//-(void)setWidth:(float)newWidth;
-(NSRect)frame;
-(void)setFrame:(NSRect)newRect;

-(BOOL)hasCloseButton;
-(void)setHasCloseButton:(BOOL)hasClose;
-(NSColor*)color;
-(void)setColor:(NSColor*)aColor;
+(BOOL)canHaveCloseButton; //default = return NO;
-(NSRect)closeBtnRectForFrame:(NSRect)cellFrame; //must override if canHaveCloseButton return YES
+(BOOL)canHaveIndicator; //default = return NO;
-(NSRect)indicatorRectForFrame:(NSRect)cellFrame; //must override if canHaveIndicator return YES

//must if custom tracking
//default: track close button
-(BOOL)myTrackMouse:(NSEvent *)theEvent inRect:(NSRect)cellFrame ofView:(HTSRTabBarView *)controlView point:(NSPoint)mousePt;

@end

@interface HTSRTabBarClippedPopUpBtn:NSPopUpButton
{
}
@end

@interface  NSBezierPath(RoundRect)
-(void)appendBezierPathWithRoundedRectangle:(NSRect)aRect withRadius:(float) radius;
@end
