/*
SRDebugWindowController.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRDefaultsKey.h"

#import "SRDebugWindowController.h"

extern void _NSSetLogCStringFunction(void(*)(const char*, unsigned, BOOL));

static void _SRLogCString(const char* message, unsigned length, BOOL withSysLogBanner)
{
    NSAutoreleasePool*  pool;
    pool = [[NSAutoreleasePool alloc] init];
    
    // Append debug string
    NSString*   string;
    string = [NSString stringWithCString:message length:length];
    [[SRDebugWindowController sharedInstance] appendDebugString:string];
    [[SRDebugWindowController sharedInstance] appendDebugString:@"\n"];
    
    [pool release];
}

@implementation SRDebugWindowController

#pragma mark -
//--------------------------------------------------------------//
// Initialize
//--------------------------------------------------------------//

+ (SRDebugWindowController*)sharedInstance
{
    static SRDebugWindowController* _sharedInstance = nil;
    if (!_sharedInstance) {
        // Load debug window
        _sharedInstance = [[SRDebugWindowController alloc] initWithWindowNibName:@"Debug"];
        if (!_sharedInstance) {
            // Fatal
            SR_FATAL(@"Could not load Debug.nib");
        }
        // Load nib
        [_sharedInstance window];
    }
    
    return _sharedInstance;
}

- (void)awakeFromNib
{
    // Register customized log function
    setbuf(stderr, NULL);
//    _NSSetLogCStringFunction(_SRLogCString);
    
    [[self window] setFrameAutosaveName:SRDebugWindowFrame];
}

#pragma mark -
//--------------------------------------------------------------//
// Debug
//--------------------------------------------------------------//

- (void)appendDebugString:(NSString*)string
{
    NSAttributedString* attrString;
    attrString = [[NSAttributedString alloc] initWithString:string];
    [[_debugTextView textStorage] appendAttributedString:attrString];
    [string release];
}

#pragma mark -
//--------------------------------------------------------------//
// Actions
//--------------------------------------------------------------//

- (IBAction)reportAction:(id)sender
{
    // Create mailto URL scheme
    NSString*   toString;
    NSString*   subjectString;
    NSString*   versionString;
    NSString*   debugString;
    NSString*   commentString;
    NSString*   bodyString;
    toString = @"mkino@xd5.so-net.ne.jp";
    subjectString = @"Shiira Debug";
    versionString = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"];
    debugString = [[_debugTextView textStorage] string];
    commentString = [[_commentTextView textStorage] string];
    bodyString = [NSString stringWithFormat:@"(%@)\n\n%@\n----------------\n%@", 
            versionString, commentString, debugString];
    
    NSString*   URLString;
    NSURL*      mailToURL;
    URLString = [NSString stringWithFormat:@"mailto:%@?subject=%@&body=%@", 
            toString, 
            [subjectString stringByAddingPercentEscapesUsingEncoding:NSASCIIStringEncoding], 
            [bodyString stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
    mailToURL = [NSURL URLWithString:URLString];
    
    // Send e-mail
    [[NSWorkspace sharedWorkspace] openURL:mailToURL];
}

@end
