/*
 * JRParameterDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 9 maggio 2003, 17.25
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.*;
/**
 *
 * @author  Administrator
 */
public class JRGroupDialog extends javax.swing.JDialog {
    /** Creates new form JRParameterDialog */
    private String groupName;
    private String expression;
    private int minHeightStartNewPage = 0;
    private int headerBandHeight = 0;
    private int footerBandHeight = 0;
    private boolean startNewPage = false;
    private boolean startNewColumn = false;
    private boolean printHeaderEachPage = false;
    private boolean resetPageNumber = false;
    
    private JReportFrame jReportFrame = null;
    
    public JRGroupDialog(JReportFrame jReportFrame, boolean modal) {
        super((java.awt.Frame)null, modal);
        initComponents();
        this.jReportFrame = jReportFrame;
        this.setSize(350, 344);
        this.jRTextExpressionArea.setText("");
        Misc.centerFrame(this);
    }
    
      
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jLabel1 = new javax.swing.JLabel();
        jTextFieldName = new javax.swing.JTextField();
        jCheckBoxStartNewColumn = new javax.swing.JCheckBox();
        jLabel3 = new javax.swing.JLabel();
        jRTextExpressionArea = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jButtonCancel = new javax.swing.JButton();
        jButtonOK = new javax.swing.JButton();
        jCheckBoxStartNewPage = new javax.swing.JCheckBox();
        jCheckBoxResetPageNumber = new javax.swing.JCheckBox();
        jCheckBoxPrintHeaderEachPage = new javax.swing.JCheckBox();
        jLabel5 = new javax.swing.JLabel();
        jNumberFieldMinStartNewPage = new it.businesslogic.ireport.gui.JNumberField();
        jLabel6 = new javax.swing.JLabel();
        jNumberFieldHeaderBand = new it.businesslogic.ireport.gui.JNumberField();
        jLabel7 = new javax.swing.JLabel();
        jNumberFieldFooterBand = new it.businesslogic.ireport.gui.JNumberField();

        getContentPane().setLayout(null);

        setTitle("Add/modify group");
        setModal(true);
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel1.setText("Group name");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(4, 4, 250, 15);

        jTextFieldName.setFont(new java.awt.Font("Dialog", 0, 11));
        getContentPane().add(jTextFieldName);
        jTextFieldName.setBounds(4, 20, 332, 22);

        jCheckBoxStartNewColumn.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxStartNewColumn.setText("Start on a new column");
        getContentPane().add(jCheckBoxStartNewColumn);
        jCheckBoxStartNewColumn.setBounds(6, 44, 166, 23);

        jLabel3.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel3.setText("Group expression");
        getContentPane().add(jLabel3);
        jLabel3.setBounds(4, 116, 250, 15);

        jRTextExpressionArea.setBorder(new javax.swing.border.EtchedBorder());
        getContentPane().add(jRTextExpressionArea);
        jRTextExpressionArea.setBounds(4, 134, 328, 78);

        jButtonCancel.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        getContentPane().add(jButtonCancel);
        jButtonCancel.setBounds(252, 286, 86, 25);

        jButtonOK.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonOK.setMnemonic('o');
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        getContentPane().add(jButtonOK);
        jButtonOK.setBounds(178, 286, 70, 25);

        jCheckBoxStartNewPage.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxStartNewPage.setText("Start on a new page");
        getContentPane().add(jCheckBoxStartNewPage);
        jCheckBoxStartNewPage.setBounds(6, 62, 166, 23);

        jCheckBoxResetPageNumber.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxResetPageNumber.setText("Reset page number");
        getContentPane().add(jCheckBoxResetPageNumber);
        jCheckBoxResetPageNumber.setBounds(176, 44, 162, 23);

        jCheckBoxPrintHeaderEachPage.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxPrintHeaderEachPage.setText("Print header on each page");
        getContentPane().add(jCheckBoxPrintHeaderEachPage);
        jCheckBoxPrintHeaderEachPage.setBounds(176, 62, 162, 23);

        jLabel5.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel5.setText("Min height to start new page");
        getContentPane().add(jLabel5);
        jLabel5.setBounds(6, 92, 144, 15);

        jNumberFieldMinStartNewPage.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        try {
            jNumberFieldMinStartNewPage.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        getContentPane().add(jNumberFieldMinStartNewPage);
        jNumberFieldMinStartNewPage.setBounds(150, 88, 48, 20);

        jLabel6.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel6.setText("Group header band height");
        getContentPane().add(jLabel6);
        jLabel6.setBounds(8, 226, 144, 15);

        jNumberFieldHeaderBand.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        try {
            jNumberFieldHeaderBand.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            jNumberFieldHeaderBand.setValue(50.0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        getContentPane().add(jNumberFieldHeaderBand);
        jNumberFieldHeaderBand.setBounds(152, 222, 48, 20);

        jLabel7.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel7.setText("Group footer band height");
        getContentPane().add(jLabel7);
        jLabel7.setBounds(8, 248, 144, 15);

        jNumberFieldFooterBand.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        try {
            jNumberFieldFooterBand.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            jNumberFieldFooterBand.setValue(50.0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        getContentPane().add(jNumberFieldFooterBand);
        jNumberFieldFooterBand.setBounds(152, 244, 48, 20);

        pack();
    }//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        
        if (this.jTextFieldName.getText().trim().length() <= 0)
        {
            javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid group name!","Invalid name!",javax.swing.JOptionPane.WARNING_MESSAGE );
            return;
        }
        
        setGroupName( this.jTextFieldName.getText() );
        // TODO: Control height!
        setHeaderBandHeight( (int)this.jNumberFieldHeaderBand.getValue());
        setFooterBandHeight( (int)this.jNumberFieldFooterBand.getValue());
        setMinHeightStartNewPage( (int)this.jNumberFieldMinStartNewPage.getValue());
        
        setStartNewColumn( jCheckBoxStartNewColumn.isSelected());
        setStartNewPage( jCheckBoxStartNewPage.isSelected());
        setPrintHeaderEachPage( jCheckBoxPrintHeaderEachPage.isSelected());
        setResetPageNumber( jCheckBoxResetPageNumber.isSelected());
        
        setExpression( jRTextExpressionArea.getText() );
        
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new JRParameterDialog(new javax.swing.JFrame(), true).show();
    }
    
    /** Setter for property tmpParameter.
     * @param tmpParameter New value of property tmpParameter.
     *
     */
    public void setGroup(it.businesslogic.ireport.Group group) {
        this.jTextFieldName.setText( new String(group.getName() ));
        this.jCheckBoxStartNewPage.setSelected( group.isIsStartNewPage() );
        this.jCheckBoxStartNewColumn.setSelected( group.isIsStartNewColumn() );
        this.jCheckBoxPrintHeaderEachPage.setSelected( group.isIsReprintHeaderOnEachPage());
        this.jCheckBoxResetPageNumber.setSelected( group.isIsResetPageNumber() );
        this.jRTextExpressionArea.setText( new String(group.getGroupExpression().trim()));
        
        try {
        this.jNumberFieldMinStartNewPage.setValue( group.getMinHeightToStartNewPage() );
        this.jNumberFieldHeaderBand.setValue( group.getGroupHeader().getHeight());
        this.jNumberFieldFooterBand.setValue( group.getGroupFooter().getHeight());        
        } catch (Exception ex) {}
    }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
        return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    /** Getter for property expression.
     * @return Value of property expression.
     *
     */
    public java.lang.String getExpression() {
        return expression;
    }
    
    /** Setter for property expression.
     * @param expression New value of property expression.
     *
     */
    public void setExpression(java.lang.String expression) {
        this.expression = expression;
    }
    
    /** Getter for property footerBandHeight.
     * @return Value of property footerBandHeight.
     *
     */
    public int getFooterBandHeight() {
        return footerBandHeight;
    }
    
    /** Setter for property footerBandHeight.
     * @param footerBandHeight New value of property footerBandHeight.
     *
     */
    public void setFooterBandHeight(int footerBandHeight) {
        this.footerBandHeight = footerBandHeight;
    }
    
    /** Getter for property groupName.
     * @return Value of property groupName.
     *
     */
    public java.lang.String getGroupName() {
        return groupName;
    }
    
    /** Setter for property groupName.
     * @param groupName New value of property groupName.
     *
     */
    public void setGroupName(java.lang.String groupName) {
        this.groupName = groupName;
    }
    
    /** Getter for property headerBandHeight.
     * @return Value of property headerBandHeight.
     *
     */
    public int getHeaderBandHeight() {
        return headerBandHeight;
    }
    
    /** Setter for property headerBandHeight.
     * @param headerBandHeight New value of property headerBandHeight.
     *
     */
    public void setHeaderBandHeight(int headerBandHeight) {
        this.headerBandHeight = headerBandHeight;
    }
    
    /** Getter for property minHeightStartNewPage.
     * @return Value of property minHeightStartNewPage.
     *
     */
    public int getMinHeightStartNewPage() {
        return minHeightStartNewPage;
    }
    
    /** Setter for property minHeightStartNewPage.
     * @param minHeightStartNewPage New value of property minHeightStartNewPage.
     *
     */
    public void setMinHeightStartNewPage(int minHeightStartNewPage) {
        this.minHeightStartNewPage = minHeightStartNewPage;
    }
    
    /** Getter for property printHeaderEachPage.
     * @return Value of property printHeaderEachPage.
     *
     */
    public boolean isPrintHeaderEachPage() {
        return printHeaderEachPage;
    }
    
    /** Setter for property printHeaderEachPage.
     * @param printHeaderEachPage New value of property printHeaderEachPage.
     *
     */
    public void setPrintHeaderEachPage(boolean printHeaderEachPage) {
        this.printHeaderEachPage = printHeaderEachPage;
    }
    
    /** Getter for property resetPageNumber.
     * @return Value of property resetPageNumber.
     *
     */
    public boolean isResetPageNumber() {
        return resetPageNumber;
    }
    
    /** Setter for property resetPageNumber.
     * @param resetPageNumber New value of property resetPageNumber.
     *
     */
    public void setResetPageNumber(boolean resetPageNumber) {
        this.resetPageNumber = resetPageNumber;
    }
    
    /** Getter for property startNewColumn.
     * @return Value of property startNewColumn.
     *
     */
    public boolean isStartNewColumn() {
        return startNewColumn;
    }
    
    /** Setter for property startNewColumn.
     * @param startNewColumn New value of property startNewColumn.
     *
     */
    public void setStartNewColumn(boolean startNewColumn) {
        this.startNewColumn = startNewColumn;
    }
    
    /** Getter for property startNewPage.
     * @return Value of property startNewPage.
     *
     */
    public boolean isStartNewPage() {
        return startNewPage;
    }
    
    /** Setter for property startNewPage.
     * @param startNewPage New value of property startNewPage.
     *
     */
    public void setStartNewPage(boolean startNewPage) {
        this.startNewPage = startNewPage;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField jTextFieldName;
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JCheckBox jCheckBoxPrintHeaderEachPage;
    private javax.swing.JLabel jLabel3;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldMinStartNewPage;
    private javax.swing.JCheckBox jCheckBoxStartNewPage;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldHeaderBand;
    private javax.swing.JCheckBox jCheckBoxResetPageNumber;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JCheckBox jCheckBoxStartNewColumn;
    private javax.swing.JButton jButtonOK;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldFooterBand;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionArea;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel5;
    // End of variables declaration//GEN-END:variables

    private int dialogResult;    
    
}
