/* Test of language code determination.
   Copyright (C) 2007-2010 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* Written by Bruno Haible <bruno@clisp.org>, 2009.  */

#include <config.h>

#include <stdlib.h>

#include "unicase.h"

#include <locale.h>
#include <string.h>

#include "macros.h"

int
main (int argc, char *argv[])
{
  const char *expected;
  const char *language;
#ifdef __MINGW32__
  char *lc_all = getenv ("LC_ALL");

  /* Kludge alert: the below is fragile, and will break if
     test-locale-language.sh is modified to use different locales.  */
  if (lc_all)
    {
      if (strcmp (lc_all, "fr_FR") == 0)
	lc_all = "fra_FRA";
      else if (strncmp (lc_all, "fr_FR", 5) == 0)
	lc_all = "fra_FRA.1252";
      else if (strcmp (lc_all, "ja_JP") == 0)
	lc_all = "jpn_JPN";
      else if (strncmp (lc_all, "tr_TR", 5) == 0)
	lc_all = "trk_TUR.1254";
      else if (strncmp (lc_all, "zh_CN", 5) == 0)
	lc_all = "chs_CHN.936";
      if (setlocale (LC_ALL, lc_all) == NULL)
	return 1;
    }
  else
#endif

  /* configure should already have checked that the locale is supported.  */
  if (setlocale (LC_ALL, "") == NULL)
    return 1;

  expected = argv[1];

  language = uc_locale_language ();
  ASSERT (strcmp (language, expected) == 0);

  return 0;
}
